/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.declare.apply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tpo.refund.TaxRefundServiceHelper;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQEvent;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQSender;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQType;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundApplyService;
import kd.taxc.tcvat.business.service.taxrefund.WriteBackToAccountService;

public class TaxRefundApplyUnAuditOp
extends AbstractOperationServicePlugIn {
    private TaxRefundApplyService taxRefundApplyService = new TaxRefundApplyService();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity.bljd");
        e.getFieldKeys().add("entryentity.zytssj");
        super.onPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                Map deleResult;
                if (!"unaudit".equals(TaxRefundApplyUnAuditOp.this.operateMeta.get("key"))) {
                    return;
                }
                List deleteNums = Arrays.asList(this.dataEntities).stream().map(o -> o.getDataEntity().getString("billno")).collect(Collectors.toList());
                TaxResult refunds = TaxRefundServiceHelper.getTaxRefundByBillId(deleteNums, (String)"tcvat_taxrefund", (Long)1L);
                if (CollectionUtils.isNotEmpty(deleteNums) && !((Boolean)(deleResult = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)"TaxRefundInfoService", (String)"deleteTaxRefundInfo", (Object[])new Object[]{deleteNums})).get("success")).booleanValue()) {
                    HashMap result = new HashMap();
                    List errors = (List)deleResult.get("data");
                    errors.forEach(one -> {
                        String failnum = (String)one.get("failnum");
                        String errormsg = (String)one.get("errormsg");
                        result.put(failnum, errormsg);
                    });
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        String billNo = dataEntity.getBillNo();
                        DynamicObject refund = TaxRefundApplyUnAuditOp.this.taxRefundApplyService.getRefundByApplyNo(billNo, (TaxResult<List<DynamicObject>>)refunds);
                        if (Objects.nonNull(refund) && ("1".equals(refund.getString("taxrefundstatus")) || "1".equals(refund.getString("isvoucher")))) {
                            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u7533\u62a5\u8868\u7f16\u53f7\uff1a%s \u7684\u4e0b\u6e38\u9000\u7a0e\u4fe1\u606f\u4e3a\u672a\u9000\u7a0e\u6216\u672a\u751f\u6210\u51ed\u8bc1\u65f6\u624d\u80fd\u64cd\u4f5c\u3002", (String)"TaxRefundProcessOp_1", (String)"taxc-tcvat", (Object[])new Object[0]), billNo));
                            continue;
                        }
                        if (!Objects.nonNull(result.get(billNo))) continue;
                        this.addFatalErrorMessage(dataEntity, (String)result.get(billNo));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operateKey = e.getOperationKey();
        if ("unaudit".equals(operateKey)) {
            DynamicObject[] objects = e.getDataEntities();
            Arrays.stream(objects).forEach(o -> {
                ((DynamicObject)o.getDynamicObjectCollection("entryentity").get(0)).set("bljd", (Object)"wsq");
                ((DynamicObject)o.getDynamicObjectCollection("entryentity").get(0)).set("zytssj", null);
            });
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String operateKey = args.getOperationKey();
        if ("unaudit".equals(operateKey)) {
            List pkValues = this.operationResult.getSuccessPkIds();
            ArrayList<DynamicObject> declareReportList = new ArrayList<DynamicObject>(pkValues.size());
            ArrayList<DynamicObject> taxRefundAccountList = new ArrayList<DynamicObject>(pkValues.size());
            if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)pkValues)) {
                for (Object pkValue : pkValues) {
                    DynamicObject[] dyos;
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle(pkValue, (String)this.billEntityType.getName());
                    Long orgId = declare.getDynamicObject("org").getLong("id");
                    Date skssqq = declare.getDate("skssqq");
                    Date skssqz = declare.getDate("skssqz");
                    for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((String)"tcvat_tax_refund_manage_a", (String)"billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,snmzcze,sshydl,skssqq,skssqz,nsxydj,clldse,ktsbl,bqrzxfdzpse,zzszyfpse,amount,bqsqthclldtse,startqmldse,bqksqthldtse,bqsqthzlldtse,sqthxm,ldtssqbbm,tsbljd,zytssj,tsqylx,zzssbbbh,bqdkhgzyjksse,bqjjskwspzse,bqsbdkjxsehj,bqmdtytse,sqmdsedjqs,sqldsets,dqxzkyytcdldtse,ldtsbqkce,sqjckyykcdldtse,jzxqkyykcdldtse,hgzyjksse,ljdkjjkwspzse,ljdkjxse,inputrate,bndzzsysxsehj,sndzzsysxsehj,qygm,summonth,bqksqthzlldse,bqksqthclldse,zlldtserq,id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", "=", (Object)skssqq), new QFilter("skssqz", "=", (Object)skssqz)})) {
                        WriteBackToAccountService.deleteData(dyo);
                        taxRefundAccountList.add(dyo);
                    }
                    this.taxRefundApplyService.updateDeclareReport("wsq", declareReportList, orgId, skssqq, skssqz);
                    TaxRefundMQSender.sendMQ(Stream.of(dyos).collect(Collectors.toList()), (String)TaxRefundMQType.TAX_REFUND.name(), (String)TaxRefundMQEvent.UPDATE.name());
                }
                SaveServiceHelper.save((DynamicObject[])taxRefundAccountList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])declareReportList.toArray(new DynamicObject[0]));
            }
        }
    }
}

