/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.ncp;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.ArrayUtils;

public class NcpDeclareNameOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(final AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                Object[] dataEntities;
                String operateKey = this.getOperateKey();
                if ("save".equals(operateKey) && ArrayUtils.isNotEmpty((Object[])(dataEntities = e.getDataEntities()))) {
                    TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), (Long)1L);
                    Set<Object> orgNumberSet = new HashSet(8);
                    if (listTaxResult != null && listTaxResult.getData() != null && !((List)listTaxResult.getData()).isEmpty()) {
                        orgNumberSet = ((List)listTaxResult.getData()).stream().filter(l -> null != l.getDynamicObject("org")).map(l -> l.getDynamicObject("org").getString("number")).collect(Collectors.toSet());
                    }
                    HashSet<Long> orgIdSet = new HashSet<Long>(dataEntities.length);
                    for (int i = 0; i < dataEntities.length; ++i) {
                        Object dyo = dataEntities[i];
                        String orgNumber = dyo.getDynamicObject("orgid").getString("number");
                        if (!orgNumberSet.contains(orgNumber)) {
                            this.addErrorMessage(this.getDataEntities()[i], ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NcpDeclareNameOp_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                            continue;
                        }
                        orgIdSet.add(dyo.getDynamicObject("orgid").getLong("id"));
                    }
                    DynamicObjectCollection result = QueryServiceHelper.query((String)"tcvat_ncp_declare_name", (String)"id,number,name,startdate,enddate", (QFilter[])new QFilter[]{new QFilter("orgid", "in", orgIdSet)});
                    if (result.size() > 0) {
                        block1: for (int i = 0; i < dataEntities.length; ++i) {
                            Object dyo = dataEntities[i];
                            Date startdate = dyo.getDate("startdate");
                            Date enddate = dyo.getDate("enddate");
                            String name = dyo.getString("name");
                            String number = dyo.getString("number");
                            if (null == enddate) {
                                enddate = DateUtils.stringToDate2((String)"9999-12-31");
                            }
                            for (DynamicObject dynamicObject : result) {
                                if (dynamicObject.getString("id").equals(dyo.getString("id")) || enddate.before(dynamicObject.getDate("startdate")) || startdate.after(null == dynamicObject.getDate("enddate") ? new Date(9999, 12, 31) : dynamicObject.getDate("enddate"))) continue;
                                if (number.equals(dynamicObject.getString("number"))) {
                                    this.addErrorMessage(this.getDataEntities()[i], ResManager.loadKDString((String)"\u5f53\u524d\u6709\u6548\u671f\u5185\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u53ef\u7528\u6570\u636e\uff08\u7a0e\u52a1\u7ec4\u7ec7\u3001\u7f16\u7801\u90fd\u76f8\u540c\uff09\u3002", (String)"NcpDeclareNameOp_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                                    continue block1;
                                }
                                if (!name.equals(dynamicObject.getString("name"))) continue;
                                this.addErrorMessage(this.getDataEntities()[i], ResManager.loadKDString((String)"\u5f53\u524d\u6709\u6548\u671f\u5185\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u53ef\u7528\u6570\u636e\uff08\u7a0e\u52a1\u7ec4\u7ec7\u3001\u540d\u79f0\u90fd\u76f8\u540c\uff09\u3002", (String)"NcpDeclareNameOp_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                                continue block1;
                            }
                        }
                    }
                }
            }
        });
    }
}

