/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.ncp;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.tcvat.business.service.ncp.NcpkcStandardService;
import kd.taxc.tcvat.common.dto.ncp.NcpkcStandardDto;
import org.apache.commons.lang3.ArrayUtils;

public class NcpkcStandardOp
extends AbstractOperationServicePlugIn {
    private NcpkcStandardService ncpkcStandardService = new NcpkcStandardService();

    public void onAddValidators(final AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                Object[] dataEntities;
                String operateKey = this.getOperateKey();
                if ("save".equals(operateKey) && ArrayUtils.isNotEmpty((Object[])(dataEntities = e.getDataEntities()))) {
                    for (int i = 0; i < dataEntities.length; ++i) {
                        Object dyo = dataEntities[i];
                        NcpkcStandardDto dto = new NcpkcStandardDto();
                        dto.setOrgId(dyo.getLong("useorg.id"));
                        dto.setTaxoffice(dyo.getLong("taxoffice.id"));
                        dto.setUnit(dyo.getLong("unit.id"));
                        dto.setCpmc(dyo.getLong("cpmc.id"));
                        dto.setNcphdkcff(dyo.getString("ncphdkcff"));
                        dto.setHyncpmc(dyo.getLong("hyncpmc.id"));
                        dto.setStartDate(dyo.getDate("startdate"));
                        dto.setEndDate(dyo.getDate("enddate"));
                        dto.setPkValue((Long)dyo.getPkValue());
                        String errMsg = NcpkcStandardOp.this.ncpkcStandardService.checkSave(dto);
                        if (!StringUtils.isNotBlank((CharSequence)errMsg)) continue;
                        this.addErrorMessage(this.getDataEntities()[i], errMsg);
                    }
                }
            }
        });
    }
}

