/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.prepay;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.threadpools.PartitionUpdateTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.prepay.application.PrepayApplicationService;

public class PrepayApplicationSaveOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PrepayApplicationSaveOp.class);
    private DynamicObjectCollection SALESENTRY = new DynamicObjectCollection();
    private DynamicObjectCollection DEDUCTENTRY = new DynamicObjectCollection();
    private Long prepayproject = 0L;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObjectType dot = dataEntity.getDataEntity().getDynamicObjectType();
                    if (!dot.getProperties().containsKey((Object)"taxorg") || !dot.getProperties().containsKey((Object)"startdate") || !dot.getProperties().containsKey((Object)"enddate") || !dot.getProperties().containsKey((Object)"salesamount") || !dot.getProperties().containsKey((Object)"salesentry") || !dot.getProperties().containsKey((Object)"deductionamount") || !dot.getProperties().containsKey((Object)"deductentry")) continue;
                    DynamicObject taxorg = dataEntity.getDataEntity().getDynamicObject("taxorg");
                    if (taxorg != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)taxorg.getLong("id")).getData()).booleanValue()) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"PrepayApplicationSaveOp_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                    }
                    Date startDate = dataEntity.getDataEntity().getDate("startdate");
                    Date endDate = dataEntity.getDataEntity().getDate("enddate");
                    if (startDate != null && endDate != null && !DateUtils.validDateRange((String)"month", (Date)startDate, (Date)endDate)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u8d77/\u6b62\u5fc5\u987b\u4e3a\u6574\u6708", (String)"PrepayApplicationSaveOp_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                    }
                    BigDecimal salesamount = dataEntity.getDataEntity().getBigDecimal("salesamount");
                    DynamicObjectCollection salesentry = dataEntity.getDataEntity().getDynamicObjectCollection("salesentry");
                    if (salesentry.size() > 0) {
                        BigDecimal stotalamount = PrepayApplicationService.getTotalAmount(salesentry, "stotalamount");
                        String salesVaildMessage = PrepayApplicationService.validMessage("sales", salesamount, stotalamount);
                        if (salesVaildMessage != null) {
                            this.addFatalErrorMessage(dataEntity, salesVaildMessage);
                        }
                        salesentry.parallelStream().forEach(s -> s.set("sadvancepaymentstatus", (Object)"30"));
                    }
                    if (salesamount.compareTo(BigDecimal.ZERO) == 0) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u6b21\u5e94\u7a0e\u9500\u552e\u989d\u4e3a0\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4", (String)"PrepayApplicationSaveOp_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                    }
                    BigDecimal deductionamount = dataEntity.getDataEntity().getBigDecimal("deductionamount");
                    String deductVaildMessage = PrepayApplicationService.validMessage("deduct", dataEntity.getDataEntity().getBigDecimal("taxbase"), BigDecimal.ZERO);
                    if (deductionamount.compareTo(BigDecimal.ZERO) < 0) {
                        deductVaildMessage = ResManager.loadKDString((String)"\u672c\u6b21\u5206\u5305\u6263\u9664\u989d\uff08\u542b\u7a0e\uff09\u5fc5\u987b\u5927\u4e8e0", (String)"PrepayApplicationSaveOp_7", (String)"taxc-tcvat", (Object[])new Object[0]);
                    }
                    DynamicObjectCollection deductentry = dataEntity.getDataEntity().getDynamicObjectCollection("deductentry");
                    for (DynamicObject object : deductentry) {
                        if (object.getBigDecimal("davaildeduct").subtract(object.getBigDecimal("dcurrentdeduct")).compareTo(BigDecimal.ZERO) < 0) {
                            deductVaildMessage = String.format(ResManager.loadKDString((String)"\u5206\u5305\u6263\u9664\u660e\u7ec6\u7b2c\u3010%s\u3011\u884c,\u5269\u4f59\u6263\u9664\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570, \u8bf7\u91cd\u65b0\u4fee\u6539", (String)"PrepayApplicationSaveOp_1", (String)"taxc-tcvat", (Object[])new Object[0]), object.getString("seq"));
                            break;
                        }
                        long dinvoiceid = object.getLong("dinvoiceid");
                        if (!QueryServiceHelper.exists((String)"rim_inv_special", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)dinvoiceid).and(new QFilter("invoice_status", "=", (Object)"2"))}) && !QueryServiceHelper.exists((String)"rim_inv_ordinary", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)dinvoiceid).and(new QFilter("invoice_status", "=", (Object)"2"))}) && !QueryServiceHelper.exists((String)"rim_inv_electric", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)dinvoiceid).and(new QFilter("invoice_status", "=", (Object)"2"))})) continue;
                        deductVaildMessage = String.format(ResManager.loadKDString((String)"\u5206\u5305\u6263\u9664\u53d1\u7968\u72b6\u6001\u53d1\u7968\u53f7\u7801%1$s\u3001\u53d1\u7968\u4ee3\u7801%2$s\u53d8\u66f4\u4e3a\u201c\u4f5c\u5e9f\u201d\uff0c\u4e0d\u518d\u652f\u6301\u5206\u5305\uff0c\u8bf7\u5220\u9664\u540e\u4fdd\u5b58\u6216\u63d0\u4ea4\u3002", (String)"PrepayApplicationSaveOp_4", (String)"taxc-tcvat", (Object[])new Object[0]), object.getString("dinvoiceno"), object.getString("dinvoicecode"));
                        break;
                    }
                    String orgId = dataEntity.getDataEntity().getString("taxorg.id");
                    Date startdate = dataEntity.getDataEntity().getDate("startdate");
                    Date enddate = dataEntity.getDataEntity().getDate("enddate");
                    if (startdate != null && enddate != null) {
                        QFilter billstatusFilter;
                        QFilter endDataFilter;
                        QFilter startDataFilter;
                        QFilter stypeFilter;
                        List typeList = Arrays.stream(TaxTypeEnum.TCVAT.getTemplates()).collect(Collectors.toList());
                        QFilter orgidFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
                        boolean exists = QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{orgidFilter, stypeFilter = new QFilter("type", "in", typeList), startDataFilter = new QFilter("skssqq", "=", (Object)DateUtils.getDayFirst((Date)startdate)), endDataFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)enddate)), billstatusFilter = new QFilter("billstatus", "!=", (Object)"A")});
                        if (exists) {
                            deductVaildMessage = String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7%1$s\u5728%2$s\u671f\u95f4\u7684\u589e\u503c\u7a0e\u7533\u62a5\u8868\u5df2\u5904\u4e8e\u63d0\u4ea4\u5ba1\u6838\u53ca\u5176\u4e4b\u540e\u7684\u8282\u70b9\uff0c\u4e0d\u652f\u6301\u4fdd\u5b58\u9884\u7f34\u7533\u8bf7\u5355\u3002", (String)"PrepayApplicationSaveOp_2", (String)"taxc-tcvat", (Object[])new Object[0]), OrgUtils.getOrgNameById((String)orgId), DateUtils.format((Date)startdate, (String)DateUtils.YYYYMMDD_CHINESE) + "-" + DateUtils.format((Date)enddate, (String)DateUtils.YYYYMMDD_CHINESE));
                        }
                    }
                    if (deductVaildMessage == null) continue;
                    this.addFatalErrorMessage(dataEntity, deductVaildMessage);
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject dataEntity = e.getDataEntities()[0];
        DynamicObjectType dot = dataEntity.getDynamicObjectType();
        if (!(dot.getProperties().containsKey((Object)"taxorg") && dot.getProperties().containsKey((Object)"startdate") && dot.getProperties().containsKey((Object)"enddate") && dot.getProperties().containsKey((Object)"salesamount") && dot.getProperties().containsKey((Object)"salesentry") && dot.getProperties().containsKey((Object)"deductionamount") && dot.getProperties().containsKey((Object)"deductentry"))) {
            return;
        }
        String id = dataEntity.getString("id");
        DynamicObject prepayproject = dataEntity.getDynamicObject("prepayproject");
        this.prepayproject = prepayproject == null ? 0L : prepayproject.getLong("id");
        boolean exist = QueryServiceHelper.exists((String)"tcvat_prepay_application", (Object)id);
        if (exist) {
            DynamicObject perpayApplication = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tcvat_prepay_application");
            this.SALESENTRY = perpayApplication.getDynamicObjectCollection("salesentry");
            this.DEDUCTENTRY = perpayApplication.getDynamicObjectCollection("deductentry");
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject dataEntities = e.getDataEntities()[0];
        DynamicObjectType dot = dataEntities.getDynamicObjectType();
        if (!(dot.getProperties().containsKey((Object)"taxorg") && dot.getProperties().containsKey((Object)"startdate") && dot.getProperties().containsKey((Object)"enddate") && dot.getProperties().containsKey((Object)"salesamount") && dot.getProperties().containsKey((Object)"salesentry") && dot.getProperties().containsKey((Object)"deductionamount") && dot.getProperties().containsKey((Object)"deductentry"))) {
            return;
        }
        DynamicObjectCollection salesentrys = dataEntities.getDynamicObjectCollection("salesentry");
        this.changedStatus(salesentrys);
        DynamicObjectCollection deductentry = dataEntities.getDynamicObjectCollection("deductentry");
        this.balanceHandler(deductentry);
    }

    private void balanceHandler(DynamicObjectCollection deductentry) {
        ArrayList<DynamicObject> deleteDeductentry = new ArrayList<DynamicObject>();
        DynamicObjectCollection collection = (DynamicObjectCollection)deductentry.clone();
        this.filtrateDeleteData(collection, this.DEDUCTENTRY, deleteDeductentry, "dinvoiceid", "rim");
        try (DLock lock = DLock.create((String)("prepayap_" + this.prepayproject));){
            lock.lock();
            this.splitInvoice(deleteDeductentry, true);
            this.splitInvoice((List<DynamicObject>)collection, false);
            this.checkNegativeNumber(collection);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    private void splitInvoice(List<DynamicObject> deductentry, boolean isRollback) {
        this.splitInvoice(deductentry, "rim_inv_special", Arrays.asList("2", "4"), isRollback);
        this.splitInvoice(deductentry, "rim_inv_ordinary", Arrays.asList("1", "3"), isRollback);
        this.splitInvoice(deductentry, "rim_inv_electric", Arrays.asList("26", "27"), isRollback);
    }

    private void splitInvoice(List<DynamicObject> deductentry, String entryName, List<String> invoiceTypeList, boolean isRollback) {
        CopyOnWriteArrayList invoiceIdList = new CopyOnWriteArrayList();
        ConcurrentHashMap<String, DynamicObject> invoiceIdToObjMap = new ConcurrentHashMap<String, DynamicObject>(32);
        deductentry.parallelStream().forEach(object -> {
            if (invoiceTypeList.contains(object.getDynamicObject("dinvoicetype").getString("number"))) {
                invoiceIdList.add(object.getLong("dinvoiceid"));
                invoiceIdToObjMap.put(object.getString("dinvoiceid"), (DynamicObject)object);
            }
        });
        MainEntityType rimInvEntity = EntityMetadataCache.getDataEntityType((String)entryName);
        DynamicObject[] invoiceArray = BusinessDataServiceHelper.load((Object[])invoiceIdList.toArray(new Long[0]), (DynamicObjectType)rimInvEntity);
        StringBuilder sb = new StringBuilder();
        Arrays.stream(invoiceArray).limit(100L).forEach(e -> {
            DynamicObject dynamicObject = (DynamicObject)invoiceIdToObjMap.get(e.getString("id"));
            sb.append(String.format("\n invoicetype:%1$s, dinvoicecode:%2$s, dinvoiceno:%3$s, dtotalamount:%4$s, dcurrentdeduct:%5$s, availdeduct:%6$s, remaindeduct:%7$s, totaldeduct:%8$s", entryName, dynamicObject.get("dinvoicecode"), dynamicObject.get("dinvoiceno"), dynamicObject.get("dtotalamount"), dynamicObject.get("dcurrentdeduct"), e.get("avail_deduct"), e.get("remain_deduct"), e.get("total_deduct")));
        });
        logger.info("===PrepayApplicationSaveOp===billno:{},isRollback:{},deductentry:{}", new Object[]{this.getOperationResult().getBillNos().toString(), isRollback, sb});
        if (isRollback) {
            for (DynamicObject object2 : invoiceArray) {
                this.rollbackAmount(invoiceIdToObjMap, object2);
            }
        } else {
            for (DynamicObject object3 : invoiceArray) {
                PrepayApplicationSaveOp.setAmount(invoiceIdToObjMap, object3);
            }
        }
        SaveServiceHelper.save((DynamicObject[])invoiceArray);
    }

    private void changedStatus(DynamicObjectCollection salesentrys) {
        ArrayList<DynamicObject> deleteSalesentry = new ArrayList<DynamicObject>();
        this.filtrateDeleteData(salesentrys, this.SALESENTRY, deleteSalesentry, "sinvoiceid", "sim");
        ArrayList<DynamicObject> vatinvoiceList = new ArrayList<DynamicObject>(deleteSalesentry.size() + salesentrys.size());
        for (DynamicObject salesentry : deleteSalesentry) {
            vatinvoiceList.add(PrepayApplicationSaveOp.setPrepayStatus(salesentry, "20"));
        }
        for (DynamicObject salesentry : salesentrys) {
            vatinvoiceList.add(PrepayApplicationSaveOp.setPrepayStatus(salesentry, "30"));
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionUpdateTask(vatinvoiceList));
    }

    private void filtrateDeleteData(DynamicObjectCollection objects, DynamicObjectCollection oldObjects, List<DynamicObject> deleteData, String filedId, String entryName) {
        for (DynamicObject dynamicObject : oldObjects) {
            boolean needRollback = true;
            long oldId = dynamicObject.getLong(filedId);
            for (DynamicObject object : objects) {
                long id = object.getLong(filedId);
                if (oldId != id) continue;
                if ("rim".equals(entryName)) {
                    BigDecimal oldDeduct;
                    BigDecimal newDeduct = Optional.ofNullable(object.getBigDecimal("dcurrentdeduct")).orElse(BigDecimal.ZERO);
                    if (newDeduct.compareTo(oldDeduct = Optional.ofNullable(dynamicObject.getBigDecimal("dcurrentdeduct")).orElse(BigDecimal.ZERO)) != 0) continue;
                    needRollback = false;
                    break;
                }
                needRollback = false;
                break;
            }
            if (needRollback) {
                deleteData.add(dynamicObject);
                continue;
            }
            if (!"rim".equals(entryName)) continue;
            objects.removeIf(e -> Objects.equals(oldId, e.getLong("dinvoiceid")));
        }
    }

    private void rollbackAmount(Map<String, DynamicObject> specialMap, DynamicObject dinvoice) {
        DynamicObject oldInvoice = specialMap.get(dinvoice.getString("id"));
        dinvoice.set("total_deduct", (Object)dinvoice.getBigDecimal("total_deduct").subtract(oldInvoice.getBigDecimal("dcurrentdeduct")));
        dinvoice.set("remain_deduct", (Object)dinvoice.getBigDecimal("remain_deduct").add(oldInvoice.getBigDecimal("dcurrentdeduct")));
        dinvoice.set("avail_deduct", (Object)dinvoice.getBigDecimal("avail_deduct").add(oldInvoice.getBigDecimal("dcurrentdeduct")));
    }

    private static void setAmount(Map<String, DynamicObject> invoiceMap, DynamicObject object) {
        DynamicObject deductObject = invoiceMap.get(object.getString("id"));
        object.set("total_deduct", (Object)object.getBigDecimal("total_deduct").add(deductObject.getBigDecimal("dcurrentdeduct")));
        object.set("avail_deduct", (Object)object.getBigDecimal("avail_deduct").subtract(deductObject.getBigDecimal("dcurrentdeduct")));
        object.set("remain_deduct", (Object)object.getBigDecimal("remain_deduct").subtract(deductObject.getBigDecimal("dcurrentdeduct")));
    }

    private static DynamicObject setPrepayStatus(DynamicObject salesentry, String status) {
        DynamicObject resultObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        resultObject.set("id", (Object)salesentry.getLong("sinvoiceid"));
        resultObject.set("advancepaymentstatus", (Object)status);
        return resultObject;
    }

    private void checkNegativeNumber(DynamicObjectCollection deductentry) {
        List dinvoiceid = deductentry.stream().map(e -> e.getLong("dinvoiceid")).collect(Collectors.toList());
        if (QueryServiceHelper.exists((String)"rim_inv_special", (QFilter[])new QFilter[]{new QFilter("id", "in", dinvoiceid).and("remain_deduct", "<", (Object)BigDecimal.ZERO)}) || QueryServiceHelper.exists((String)"rim_inv_ordinary", (QFilter[])new QFilter[]{new QFilter("id", "in", dinvoiceid).and("remain_deduct", "<", (Object)BigDecimal.ZERO)}) || QueryServiceHelper.exists((String)"rim_inv_electric", (QFilter[])new QFilter[]{new QFilter("id", "in", dinvoiceid).and("remain_deduct", "<", (Object)BigDecimal.ZERO)})) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5305\u53d1\u7968\u5269\u4f59\u6263\u9664\u989d\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u540e\u786e\u8ba4\u6263\u9664\u989d\u662f\u5426\u6b63\u786e\u3002", (String)"PrepayApplicationSaveOp_3", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }
}

