/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.rule;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.tcvat.business.service.rule.DiffDeductionOpService;

public class DiffDeductionSaveOp
extends AbstractOperationServicePlugIn {
    private static final String VAT_CEKCLX_007 = "VAT_CEKCLX_007";
    private static final String VAT_CEKCLX_008 = "VAT_CEKCLX_008";
    private static final List<String> zero_taxamounts = new ArrayList<String>();
    private static final String jsflqs = "jsflqs";
    private static final String cysldsqs = "cysldsqs";
    private static final String sehshsj = "sehshsj";
    private static final String bhsjhshsj = "bhsjhshsj";
    private static final List<String> special_datatype = new ArrayList<String>();

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String ruleExistsMessage;
                    DynamicObject rule = dataEntity.getDataEntity();
                    String diffType = rule.getDynamicObject("difftype").getString("number");
                    if (zero_taxamounts.contains(diffType)) {
                        DynamicObjectCollection entitys = rule.getDynamicObjectCollection("entryentity");
                        entitys.forEach(entity -> {
                            if (special_datatype.contains(entity.getString("datatype"))) {
                                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5dee\u989d\u6263\u9664\u7c7b\u578b\u662f\u514d\u62b5\u9000\u7a0e\u7684\u9879\u76ee/\u514d\u7a0e\u7684\u9879\u76ee\uff0c\u53d6\u6570\u65b9\u5f0f\u4e0d\u80fd\u9009\u62e9\u542b\u7a0e\u4ef7\u6362\u7b97\u4e0d\u542b\u7a0e\u4ef7\uff1b\u7a0e\u989d\u6362\u7b97\u4e0d\u542b\u7a0e\u4ef7\uff1b\u7a0e\u989d\u6362\u7b97\u542b\u7a0e\u4ef7\uff1b\u4e0d\u542b\u7a0e\u4ef7\u6362\u7b97\u542b\u7a0e\u4ef7\u3002", (String)"DiffDeductionSaveOp_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                                return;
                            }
                        });
                    }
                    if (!StringUtil.isNotEmpty((CharSequence)(ruleExistsMessage = DiffDeductionOpService.isRuleRepeatOrShared(rule)))) continue;
                    this.addFatalErrorMessage(dataEntity, ruleExistsMessage);
                }
            }
        });
    }

    static {
        zero_taxamounts.add(VAT_CEKCLX_007);
        zero_taxamounts.add(VAT_CEKCLX_008);
        special_datatype.add(jsflqs);
        special_datatype.add(cysldsqs);
        special_datatype.add(sehshsj);
        special_datatype.add(bhsjhshsj);
    }
}

