/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.rule.DiffDeductionOpService;
import kd.taxc.tcvat.common.enums.RuleTypeStrategyEnum;

public class SbxRuleDisableOrEnableSynOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("group");
        e.getFieldKeys().add("rulename");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject diffRule;
                    String ruleExistsMessage;
                    DynamicObject rule = dataEntity.getDataEntity();
                    String string = rule.getDynamicObject("group").getString("id");
                    RuleTypeStrategyEnum ruleTypeEnum = RuleTypeStrategyEnum.getStrategyByGroupId(string);
                    if ("tcvat_rule_wkpsr".equals(ruleTypeEnum.getFormId())) {
                        Long incomeRuleId = rule.getDynamicObject("rulename").getLong("id");
                        if (incomeRuleId == 0L) continue;
                        DynamicObject incomeRule = QueryServiceHelper.queryOne((String)"tcvat_rule_income", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)incomeRuleId), new QFilter("enable", "=", (Object)"0")});
                        if (null != incomeRule) {
                            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7531\u4e8e\u5f15\u7528\u7684\u6536\u5165\u9879\u76ee\u89c4\u5219\u5c1a\u672a\u542f\u7528\uff0c\u8bf7\u5148\u524d\u5f80\u3010\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e\u3011\u542f\u7528\u3010\u7f16\u7801\uff1a%1$s,\u540d\u79f0\uff1a%2$s\u3011\u6536\u5165\u89c4\u5219\uff0c\u518d\u5bf9\u672c\u89c4\u5219\u8fdb\u884c\u542f\u7528\u3002", (String)"SbxRuleDisableOrEnableSynOp_0", (String)"taxc-tcvat", (Object[])new Object[0]), incomeRule.getString("number"), incomeRule.getString("name")));
                        }
                    }
                    if (ruleTypeEnum != RuleTypeStrategyEnum.DIFF || !"enable".equals(this.getOperateType()) || !StringUtil.isNotEmpty((CharSequence)(ruleExistsMessage = DiffDeductionOpService.isRuleRepeatOrShared(diffRule = BusinessDataServiceHelper.loadSingle((Object)rule.getLong("id"), (String)ruleTypeEnum.getFormId()))))) continue;
                    this.addFatalErrorMessage(dataEntity, ruleExistsMessage);
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("disable".equals(operationKey) || "enable".equals(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            Map<String, List<DynamicObject>> groupIdToRuleMap = Stream.of(dataEntities).collect(Collectors.groupingBy(d -> d.getDynamicObject("group").getString("id")));
            for (Map.Entry<String, List<DynamicObject>> entry : groupIdToRuleMap.entrySet()) {
                String formId = RuleTypeStrategyEnum.getStrategyByGroupId(entry.getKey()).getFormId();
                List ruleIds = entry.getValue().stream().map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
                DynamicObject[] sbxRuleArray = BusinessDataServiceHelper.load((Object[])ruleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
                ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
                for (DynamicObject rule : sbxRuleArray) {
                    rule.set("enable", (Object)e.getDataEntities()[0].getString("enable"));
                    updateList.add(rule);
                }
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
        }
    }
}

