/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.tcvat.common.util.ValidateUtils;

public class SharingPlanAssignOp
extends AbstractOperationServicePlugIn {
    private String MSG = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u548c\u89c4\u5219\u201c%2$s\u201d\u5728\u201c%3$s\u201d\u65b9\u6848\u548c\u201c%4$s\u201d\u65b9\u6848\u4e2d\u90fd\u5b58\u5728\u914d\u7f6e", (String)"SharingPlanAssignOp_0", (String)"taxc-tcvat", (Object[])new Object[0]);
    private static List<RuleTypeEnum> ruleTypeEnums = Arrays.asList(RuleTypeEnum.INCOME, RuleTypeEnum.ROLL_OUT, RuleTypeEnum.DIFF, RuleTypeEnum.DEDUCT);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    ArrayList errorList = new ArrayList();
                    DynamicObject entity = dataEntity.getDataEntity();
                    DynamicObjectCollection planentity = entity.getDynamicObjectCollection("planentity");
                    this.checkRepeatAssign(dataEntity, planentity);
                    planentity = planentity.stream().filter(p -> "0".equals(p.getString("id"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
                    for (RuleTypeEnum ruleTypeEnum : ruleTypeEnums) {
                        SharingPlanAssignOp.this.validateRuleType(ruleTypeEnum, errorList, planentity);
                    }
                    boolean hasError = SharingPlanAssignOp.this.checkError(errorList);
                    for (Map map : errorList) {
                        if (!hasError) {
                            this.addWarningMessage(dataEntity, (String)map.get("msg"));
                            continue;
                        }
                        if (!"error".equals(map.get("type"))) continue;
                        this.addFatalErrorMessage(dataEntity, (String)map.get("msg"));
                    }
                }
            }

            private void checkRepeatAssign(ExtendedDataEntity dataEntity, DynamicObjectCollection planentity) {
                HashMap<String, DynamicObject> orgIdRuleMap = new HashMap<String, DynamicObject>();
                for (DynamicObject plan : planentity) {
                    DynamicObjectCollection orgentity = plan.getDynamicObjectCollection("orgentity");
                    DynamicObjectCollection ruleentity = plan.getDynamicObjectCollection("ruleentity");
                    for (DynamicObject org : orgentity) {
                        for (DynamicObject rule : ruleentity) {
                            if (null == org.getDynamicObject("org") || null == rule.getDynamicObject("rule")) continue;
                            String key = org.getDynamicObject("org").getString("id") + "-" + rule.getLong("rule.id");
                            if (orgIdRuleMap.get(key) != null) {
                                DynamicObject orgPlan = (DynamicObject)orgIdRuleMap.get(key);
                                String groupId = rule.getDynamicObject("rule").getString("group.id");
                                String entry = RuleTypeEnum.valueOfGroupId((String)groupId).getEntry();
                                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)rule.getLong("rule.id"), (String)entry);
                                String ruleName = object.getString("name");
                                if ("tcvat_rule_wkpsr".equals(entry)) {
                                    ruleName = object.getString("rulename.name");
                                }
                                this.addWarningMessage(dataEntity, String.format(SharingPlanAssignOp.this.MSG, org.getDynamicObject("org").getString("name"), ruleName, plan.getString("carname"), orgPlan.getString("carname")));
                                continue;
                            }
                            orgIdRuleMap.put(key, plan);
                        }
                    }
                }
            }
        });
    }

    private void validateRuleType(RuleTypeEnum ruleTypeEnum, List<Map<String, Object>> errorList, DynamicObjectCollection planentity) {
        ArrayList<Long> ruleIds = new ArrayList<Long>();
        for (DynamicObject plan : planentity) {
            DynamicObjectCollection ruleentity = plan.getDynamicObjectCollection("ruleentity");
            for (DynamicObject rule : ruleentity) {
                if (null == rule.getDynamicObject("rule")) continue;
                String groupId = rule.getDynamicObject("rule").getString("group.id");
                if (!ruleTypeEnum.getGroupId().equals(groupId)) continue;
                ruleIds.add(rule.getLong("rule.id"));
            }
        }
        DynamicObject[] rules = BusinessDataServiceHelper.load((Object[])ruleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ruleTypeEnum.getEntry()));
        errorList.addAll(ValidateUtils.validate(Arrays.asList(rules)));
    }

    private boolean checkError(List<Map<String, Object>> errorList) {
        for (Map<String, Object> map : errorList) {
            if (!"error".equals(map.get("type"))) continue;
            return true;
        }
        return false;
    }
}

