/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.tcvat.common.util.ValidateUtils;
import org.apache.commons.collections.CollectionUtils;

public class TaxPrePayRuleSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject rule = dataEntity.getDataEntity();
                    if (!rule.getBoolean("enable")) {
                        return;
                    }
                    ArrayList<DynamicObject> rules = new ArrayList<DynamicObject>();
                    this.queryAllRules(rule, rules);
                    this.validate(dataEntity, rules, rule);
                    if (!CollectionUtils.isEmpty((Collection)rule.getDynamicObjectCollection("entryentity"))) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u914d\u7f6e\u4e00\u6761\u9500\u552e\u989d\u53d6\u6570\u89c4\u5219\u3002", (String)"TaxPrePayRuleSaveOp_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            }

            private void queryAllRules(DynamicObject rule, List<DynamicObject> rules) {
                Long orgid = rule.getDynamicObject("org").getLong("id");
                HashMap rulePublicIdMap = new HashMap();
                ArrayList<QFilter> filterList = new ArrayList<QFilter>();
                filterList.add(new QFilter("org", "=", (Object)orgid));
                HashMap result = new HashMap();
                RuleUtils.queryRulesByType((RuleTypeEnum)RuleTypeEnum.PREPAY, (Boolean)Boolean.TRUE, rulePublicIdMap, filterList, result, (String)"");
                rules.addAll((Collection)result.get(RuleTypeEnum.PREPAY));
            }

            private void validate(ExtendedDataEntity dataEntity, List<DynamicObject> rules, DynamicObject rule) {
                ArrayList<Map<String, Object>> errorList = new ArrayList<Map<String, Object>>(8);
                rules.stream().filter(r -> !r.getString("number").equals(rule.getString("number"))).filter(r -> r.getDynamicObject("prepayproject").getString("id").equals(rule.getDynamicObject("prepayproject").getString("id"))).findAny().ifPresent(r -> {
                    HashMap<String, String> errorMap = new HashMap<String, String>(1);
                    errorMap.put("msg", String.format(ResManager.loadKDString((String)"%s\u5df2\u914d\u7f6e\u53d6\u6570\u89c4\u5219\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e", (String)"TaxPrePayRuleSaveOp_0", (String)"taxc-tcvat", (Object[])new Object[0]), r.getDynamicObject("prepayproject").getString("name")));
                    errorList.add(errorMap);
                });
                errorList.addAll(ValidateUtils.validate(rule));
                for (Map map : errorList) {
                    this.addFatalErrorMessage(dataEntity, (String)map.get("msg"));
                }
            }
        });
    }
}

