/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.rule.shareplan;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class SbxSharePlanFormSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject sharePlan = dataEntity.getDataEntity();
                    DynamicObject createorgObject = sharePlan.getDynamicObject("createorg");
                    if (createorgObject != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)createorgObject.getLong("id")).getData()).booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"SbxSharePlanFormSaveOp_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObjectCollection orgentity = sharePlan.getDynamicObjectCollection("orgentity");
                    String selectType = sharePlan.getString("taxpayertype");
                    List orgIds = orgentity.stream().filter(e -> null != e.getDynamicObject("org")).map(entity -> entity.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
                    TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(orgIds);
                    List unMatchObject = ((List)result.getData()).stream().filter(d -> EmptyCheckUtils.isNotEmpty((Object)d.getDynamicObjectCollection("categoryentryentity"))).filter(d -> !selectType.equals(((DynamicObject)d.getDynamicObjectCollection("categoryentryentity").get(0)).getString("taxpayertype"))).limit(4L).collect(Collectors.toList());
                    if (unMatchObject.size() <= 0) continue;
                    String orgName = unMatchObject.stream().map(u -> TaxOrgUtil.getTaxpayer((DynamicObject)u.getDynamicObject("taxorg"))).collect(Collectors.joining("\u3001"));
                    if (unMatchObject.size() >= 4) {
                        orgName = orgName + "...";
                    }
                    String errMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0e\u5171\u4eab\u65b9\u6848\u4e2d\u7684\u7eb3\u7a0e\u4eba\u7c7b\u578b\u4e0d\u4e00\u81f4, \u8bf7\u4fee\u6539\u5171\u4eab\u8303\u56f4\u3002", (String)"SbxSharePlanFormSaveOp_0", (String)"taxc-tcvat", (Object[])new Object[0]), orgName);
                    this.addErrorMessage(dataEntity, errMsg);
                    return;
                }
            }
        });
    }
}

