/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.mservice.accrual;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.AccrualRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.mservice.api.AccrualService;

public class AccrualServiceImpl
implements AccrualService {
    private static Log LOGGER = LogFactory.getLog(AccrualServiceImpl.class);
    private TcvatDraftService draftService = new TcvatDraftService();
    public static final String BAD_REQUEST = "400";
    public static final String SERVICE_ERROR = "500";

    @Override
    public String generate(String request) {
        EngineResponse response;
        try {
            response = (EngineResponse)SerializationUtils.fromJsonString((String)this.doGenerate(request), EngineResponse.class);
        }
        catch (KDBizException e) {
            LOGGER.error((Throwable)e);
            response = EngineResponse.failByMsgCode((String)e.getMessage(), (String)BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            response = EngineResponse.failByMsgCode((String)e.getMessage(), (String)SERVICE_ERROR);
        }
        return SerializationUtils.toJsonString((Object)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGenerate(String request) {
        AccrualRequest requestVo = (AccrualRequest)SerializationUtils.fromJsonString((String)request, AccrualRequest.class);
        EngineResponse engineResponse = new EngineResponse(Boolean.FALSE, new HashMap(), null, null);
        List engineResponses = TaxDeclareHelper.doDraftVerify((Long)Long.parseLong(requestVo.getOrgId()), (Date)requestVo.getAccrualDate(), null, null, (Boolean)false, (Boolean)false, (String)"sjjt");
        Optional<EngineResponse> first = engineResponses.stream().filter(EngineResponse::getSuccess).findFirst();
        if (!first.isPresent()) {
            return SerializationUtils.toJsonString(engineResponses.get(0));
        }
        Map data = (Map)first.get().getData();
        engineResponse.setData((Object)data);
        Date startDate = (Date)data.get("skssqq");
        Date endDate = (Date)data.get("skssqz");
        String taxpayertype = (String)data.get("taxpayertype");
        DLock reentrant = this.createReentrantLock(requestVo, startDate, endDate, taxpayertype, "sjjt");
        boolean zzsdraftcreatelock = reentrant.tryLock(1000L);
        if (!zzsdraftcreatelock) {
            engineResponse.setMessage(ResManager.loadKDString((String)"\u5df2\u6709\u4efb\u52a1\u5728\u6267\u884c\u751f\u6210\u6b64\u5e95\u7a3f", (String)"DraftEngineServiceImpl_3", (String)"taxc-tcvat-mservice", (Object[])new Object[0]));
            return kd.bos.login.actions.SerializationUtils.toJsonString((Object)engineResponse);
        }
        try {
            String errMsg = this.draftService.checkAlreadyExistsDraft("sjjt", requestVo.getOrgId(), startDate, endDate);
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                engineResponse.setMessage(errMsg);
                LOGGER.info("sjjtdraftEngineResponse" + SerializationUtils.toJsonString((Object)engineResponse));
                String string = SerializationUtils.toJsonString((Object)engineResponse);
                return string;
            }
            EngineHandler handler = EngineHandlerFactory.createHandler((String)taxpayertype);
            TcvatEngineModel engineModel = TaxDeclareHelper.buildEngineModel((String)requestVo.getOrgId(), (String)DateUtils.format((Date)startDate), (String)DateUtils.format((Date)endDate), (String)taxpayertype, null, (String)"sjjt");
            LOGGER.info("sjjtdraftEngineModel" + SerializationUtils.toJsonString((Object)engineModel));
            handler.validate((EngineModel)engineModel);
            handler.execute((EngineModel)engineModel);
            engineResponse.setSuccess(Boolean.TRUE);
            engineResponse.setMessage(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u5e95\u7a3f\u4efb\u52a1\u751f\u6210\u6210\u529f", (String)"AccrualServiceImpl_0", (String)"taxc-tcvat-mservice", (Object[])new Object[0]));
        }
        catch (KDBizException exception) {
            engineResponse.setSuccess(Boolean.FALSE);
            engineResponse.setMessage(exception.getMessage());
        }
        finally {
            reentrant.unlock();
        }
        return SerializationUtils.toJsonString((Object)engineResponse);
    }

    public DLock createReentrantLock(AccrualRequest requestVo, Date startDate, Date endDate, String taxpayertype, String draftPurpose) {
        String lockKey = String.format("zzsdraftcreatelock-%s-%s-%s-%s-%s", requestVo.getOrgId(), DateUtils.format((Date)startDate), DateUtils.format((Date)endDate), taxpayertype, draftPurpose);
        DLock reentrant = DLock.createReentrant((String)lockKey, (String)"kd.taxc.tcvat.mservice.accrual.AccrualServiceImpl.doGenerate");
        reentrant.fastMode();
        return reentrant;
    }
}

