/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.mservice.engine;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.zlb.ZlbService;
import org.apache.commons.lang3.ObjectUtils;

public class MdtsEngineServiceImpl {
    private static Log logger = LogFactory.getLog(MdtsEngineServiceImpl.class);

    public Map<String, BigDecimal> fetchMdtsYtse(String draftPurpose, String orgId, String startdate, String enddate, String[] mdType) throws Exception {
        long time = System.currentTimeMillis();
        Map<String, BigDecimal> result = new HashMap<String, BigDecimal>(16);
        if (mdType == null || mdType.length == 0) {
            return result;
        }
        for (String str : mdType) {
            if (!ObjectUtils.anyNull((Object[])new Object[]{orgId, startdate, enddate, str})) continue;
            result.put(str, BigDecimal.ZERO);
        }
        Map taxPayerType = TaxDeclareHelper.getTaxPayerType((String)orgId, (Date)DateUtils.stringToDate2((String)startdate), (Date)DateUtils.stringToDate2((String)enddate));
        String taxpayertype = (String)taxPayerType.get("taxpayertype");
        TcvatEngineModel model = TaxDeclareHelper.buildEngineModel((String)orgId, (String)startdate, (String)enddate, (String)taxpayertype, null, (String)draftPurpose);
        result = ZlbService.fetchMdtsYtse((String[])mdType, (EngineModel)model);
        logger.info("MdtsEngineServiceImpl.fetchMdtsYtse\u8017\u65f6\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return result;
    }
}

