/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bdim.business.opservice.costshare;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ShareTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CostShareUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("entryentity");
        selector.add("periodstartdate");
        selector.add("periodenddate");
        selector.add("accrualinterest");
        selector.add("payinterest");
        selector.add("shareamount");
        selector.add("adjustmentamount");
        selector.add("actualamount");
        selector.add("day");
        selector.add("freesharetype");
        selector.add("e_period");
        selector.add("e_startdate");
        selector.add("e_enddate");
        selector.add("e_accrualinterest");
        selector.add("e_payinterest");
        selector.add("e_shareamount");
        selector.add("e_adjustmentamount");
        selector.add("e_actualamount");
        selector.add("e_day");
        selector.add("bondirr");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, BigDecimal> billIdMaps = new HashMap<Long, BigDecimal>(dataEntities.length);
        HashSet<Long> bondIds = new HashSet<Long>();
        Set sourceBillIds = Arrays.stream(dataEntities).map(o -> o.getLong("sourcebillid")).collect(Collectors.toSet());
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"bdim_costshare", (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", sourceBillIds).and("isvoucher", "=", (Object)"1")});
        sourceBillIds = bills.stream().map(o -> o.getLong("sourcebillid")).collect(Collectors.toSet());
        for (DynamicObject bill : dataEntities) {
            long sourceBillId = bill.getLong("sourcebillid");
            if (sourceBillIds.contains(sourceBillId) || billIdMaps.containsKey(sourceBillId)) continue;
            if (ShareTypeEnum.isInterest((String)bill.getString("freesharetype"))) {
                bondIds.add(sourceBillId);
            }
            billIdMaps.put(sourceBillId, bill.getBigDecimal("bondirr"));
            DynamicObject[] costBills = TmcDataServiceHelper.load((String)"bdim_costshare", (String)"id,periodstartdate,periodenddate,accrualinterest,payinterest,shareamount,adjustmentamount,actualamount,day", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)sourceBillId)});
            List<DynamicObject> costList = Arrays.stream(costBills).sorted(Comparator.comparing(o -> o.getDate("periodstartdate"))).collect(Collectors.toList());
            this.setEntryToBill(costList, bill);
        }
        if (bondIds.size() > 0) {
            DynamicObject[] bonds;
            for (DynamicObject bond : bonds = TmcDataServiceHelper.load((String)"cfm_loanbill_bond", (String)"id,irr", (QFilter[])new QFilter[]{new QFilter("id", "in", bondIds)})) {
                bond.set("irr", billIdMaps.get(bond.getLong("id")));
            }
            SaveServiceHelper.save((DynamicObject[])bonds);
        }
    }

    private void setEntryToBill(List<DynamicObject> costList, DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
        bill.set("periodstartdate", null);
        bill.set("periodenddate", null);
        bill.set("accrualinterest", (Object)BigDecimal.ZERO);
        bill.set("payinterest", (Object)BigDecimal.ZERO);
        bill.set("shareamount", (Object)BigDecimal.ZERO);
        bill.set("adjustmentamount", (Object)BigDecimal.ZERO);
        bill.set("actualamount", (Object)BigDecimal.ZERO);
        bill.set("day", (Object)0);
        entrys.clear();
        for (DynamicObject cost : costList) {
            DynamicObject entry = entrys.addNew();
            Date startDate = cost.getDate("periodstartdate");
            Date endDate = cost.getDate("periodenddate");
            entry.set("e_period", (Object)(DateUtils.formatString((Date)startDate, (String)"yyyy-MM-dd") + "-" + DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd")));
            entry.set("e_startdate", (Object)startDate);
            entry.set("e_enddate", (Object)endDate);
            entry.set("e_accrualinterest", (Object)cost.getBigDecimal("accrualinterest"));
            entry.set("e_payinterest", (Object)cost.getBigDecimal("payinterest"));
            entry.set("e_shareamount", (Object)cost.getBigDecimal("shareamount"));
            entry.set("e_adjustmentamount", (Object)cost.getBigDecimal("adjustmentamount"));
            entry.set("e_actualamount", (Object)cost.getBigDecimal("actualamount"));
            entry.set("e_day", (Object)cost.getInt("day"));
        }
        Object[] costIdArr = costList.stream().filter(o -> o.getLong("id") != bill.getLong("id")).map(DataEntityBase::getPkValue).toArray();
        if (EmptyUtil.isNoEmpty((Object[])costIdArr)) {
            TmcOperateServiceHelper.execOperate((String)"deletedetail", (String)"bdim_costshare", (Object[])costIdArr, (OperateOption)OperateOption.create());
        }
    }
}

