/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bdim.business.validate.costshare;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class CostShareCalculateValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("irr");
        selector.add("sourcebillid");
        selector.add("sharefrequency");
        selector.add("bizdate");
        selector.add("expiredate");
        selector.add("currency");
        selector.add("loanrate");
        selector.add("day");
        selector.add("freesharetype");
        selector.add("entryentity");
        selector.add("e_period");
        selector.add("e_startdate");
        selector.add("e_enddate");
        selector.add("e_day");
        selector.add("e_accrualinterest");
        selector.add("e_payinterest");
        selector.add("e_shareamount");
        selector.add("e_actualamount");
        selector.add("amount");
        selector.add("basis");
        selector.add("feeamount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject bill = dataEntity.getDataEntity();
            String billStatus = bill.getString("billstatus");
            if (!BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u6682\u5b58\u65f6\u624d\u80fd\u8ba1\u7b97\u6210\u672c\u644a\u9500\u3002", (String)"CostShareCalculateValidator_0", (String)"tmc-bdim-business", (Object[])new Object[0]));
            }
            if (bill.getInt("day") <= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c\u5355[%s]\uff0c\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u6210\u672c\u644a\u9500\u5355\u636e\uff0c\u4e0d\u652f\u6301\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"CostShareCalculateValidator_1", (String)"tmc-bdim-business", (Object[])new Object[]{bill.getString("billno")}));
        }
    }
}

