/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bdim.business.validate.costshare;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.CostShareServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBondCostShareValidator
extends AbstractTmcBizOppValidator {
    public Set<String> preparePropertys() {
        Set sel = super.preparePropertys();
        sel.add("publishprice");
        sel.add("ticketamt");
        sel.add("drawamount");
        sel.add("org");
        sel.add("currency");
        sel.add("startintdate");
        sel.add("expiredate");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject bill = dataEntity.getDataEntity();
            BigDecimal pubAmt = bill.getBigDecimal("publishprice");
            BigDecimal tickAmt = bill.getBigDecimal("ticketamt");
            BigDecimal amount = bill.getBigDecimal("drawamount");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pubAmt, tickAmt})) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c\u7684\u53d1\u884c\u4ef7\u683c\u6216\u7968\u9762\u91d1\u989d\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u6210\u672c\u644a\u9500\u3002", (String)"LoanBondCostShareValidator_2", (String)"tmc-bdim-business", (Object[])new Object[0]));
            }
            BigDecimal feeTotalAmt = CostShareServiceHelper.getFeeAmount((Long)bill.getLong("id"), (Long)bill.getDynamicObject("org").getLong("id"), (Long)bill.getDynamicObject("currency").getLong("id"), (String)"bond");
            if (pubAmt.compareTo(Constants.ONE_HUNDRED) == 0 && feeTotalAmt.compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u503a\u5238\u53d1\u884c\u6ca1\u6709\u9700\u8981\u644a\u9500\u7684\u8d39\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"LoanBondCostShareValidator_0", (String)"tmc-bdim-business", (Object[])new Object[0]));
            } else {
                BigDecimal actFeeTotalAmt = CostShareServiceHelper.getActFeeTotalAmt((BigDecimal)feeTotalAmt, (BigDecimal)pubAmt, (BigDecimal)tickAmt, (BigDecimal)amount);
                if (EmptyUtil.isEmpty((BigDecimal)actFeeTotalAmt)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u503a\u5238\u53d1\u884c\u7684\u644a\u9500\u603b\u989d\u4e3a0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"LoanBondCostShareValidator_3", (String)"tmc-bdim-business", (Object[])new Object[0]));
                }
            }
            boolean isHasCost = TmcDataServiceHelper.exists((String)"bdim_costshare", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", bill.getPkValue())});
            if (isHasCost) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u503a\u5238\u53d1\u884c\u5df2\u5b58\u5728\u503a\u5238\u6210\u672c\u644a\u9500\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"LoanBondCostShareValidator_1", (String)"tmc-bdim-business", (Object[])new Object[0]));
            }
            Date startDate = bill.getDate("startintdate");
            Date expireDate = bill.getDate("expiredate");
            if (!EmptyUtil.isEmpty((Object)startDate) && !EmptyUtil.isEmpty((Object)expireDate) && startDate.compareTo(expireDate) < 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8d77\u606f\u65e5\u671f\u624d\u652f\u6301\u644a\u9500\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"LoanBondCostShareValidator_5", (String)"tmc-bdim-business", (Object[])new Object[0]));
        }
    }
}

