/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bdim.formplugin.bondlimit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bdim.common.helper.CountryHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import org.apache.commons.lang.time.DateUtils;

public class BondLimitEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit control = (BasedataEdit)this.getControl("country");
        if (control != null) {
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "country": {
                String regions = (String)this.getModel().getValue("regions");
                QFilter qFilter = "mainland".equals(regions) ? CountryHelper.getChinaFilter() : ("hmt".equals(regions) ? CountryHelper.getHMTFilter() : CountryHelper.getOverSeasFilter());
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String regions = (String)this.getModel().getValue("regions");
        if ("mainland".equals(regions)) {
            DynamicObject china = QueryServiceHelper.queryOne((String)"bd_country", (String)"id", (QFilter[])new QFilter[]{CountryHelper.getChinaFilter()});
            this.getModel().setValue("country", china != null ? china.get("id") : null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.checkIsFromChange();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property;
        super.propertyChanged(e);
        switch (property = e.getProperty().getName()) {
            case "totalamt": 
            case "usedamt": 
            case "advanceamt": {
                BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("totalamt");
                BigDecimal usedAmt = (BigDecimal)this.getModel().getValue("usedamt");
                BigDecimal advanceAmt = (BigDecimal)this.getModel().getValue("advanceamt");
                this.getModel().setValue("availamt", (Object)totalAmt.subtract(usedAmt).subtract(advanceAmt));
                break;
            }
            case "effectdate": {
                Date effectDate = (Date)this.getModel().getValue("effectdate");
                if (effectDate == null) break;
                this.getModel().setValue("expirydate", (Object)DateUtils.addYears((Date)effectDate, (int)2));
                DateEdit expiryDate = (DateEdit)this.getControl("expirydate");
                expiryDate.setMinDate(DateUtils.addDays((Date)effectDate, (int)1));
                break;
            }
            case "regions": {
                String newValue = (String)e.getChangeSet()[0].getNewValue();
                if ("mainland".equals(newValue)) {
                    DynamicObject china = QueryServiceHelper.queryOne((String)"bd_country", (String)"id", (QFilter[])new QFilter[]{CountryHelper.getChinaFilter()});
                    this.getModel().setValue("country", china != null ? china.get("id") : null);
                    break;
                }
                this.getModel().setValue("country", null);
                break;
            }
        }
    }

    public void afterCopyData(EventObject e) {
        this.getModel().deleteEntryData("entry");
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        String billentity = (String)this.getModel().getValue("limitbilltype", rowIndex);
        BillShowParameter param = new BillShowParameter();
        param.setFormId(billentity);
        param.setPkId(this.getModel().getValue("limitbillid", rowIndex));
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    public void beforeBindData(EventObject e) {
        Map paraMap;
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        if (OperationStatus.EDIT == status && (paraMap = showParameter.getCustomParams()).containsKey("fromchange")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_update"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_closelimit", "bar_print", "bar_refresh"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "update": {
                if (this.isDataChanged() && !this.updateValidate()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult res = args.getOperationResult();
        if (res != null && res.isSuccess()) {
            this.checkIsFromChange();
        }
    }

    private boolean updateValidate() {
        BigDecimal advanceAmt;
        BigDecimal usedAmt;
        Date effectDate = (Date)this.getModel().getValue("effectdate");
        Date expiryDate = (Date)this.getModel().getValue("expirydate");
        if (expiryDate.compareTo(effectDate) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"BondLimitEdit_1", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
            return true;
        }
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("totalamt");
        if (totalAmt.compareTo((usedAmt = (BigDecimal)this.getModel().getValue("usedamt")).add(advanceAmt = (BigDecimal)this.getModel().getValue("advanceamt"))) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u603b\u989d\u5ea6\u5fc5\u987b\u5927\u4e8e\u5df2\u7528\u989d\u5ea6\u52a0\u4e0a\u9884\u5360\u989d\u5ea6\u3002", (String)"BondLimitEdit_2", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isDataChanged() {
        if (!this.getModel().getDataChanged()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6ca1\u6709\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u9700\u8981\u4fdd\u5b58\u3002", (String)"BondLimitEdit_3", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void checkIsFromChange() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!customParams.containsKey("fromchange")) {
            String status = (String)this.getModel().getValue("status");
            this.getView().setEnable(Boolean.valueOf(BillStatusEnum.SAVE.getValue().equals(status)), new String[]{"fs_baseinfo"});
        }
    }
}

