/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bdim.formplugin.bondlimit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.billversion.AbstractBillVersionTabEdit;

public class BondLimitHistoryVersionEdit
extends AbstractBillVersionTabEdit {
    public static final String BAR_NEW = "bar_new";
    public static final String BAR_DELETE = "bar_delete";
    public static final String BAR_SAVE = "bar_save";
    public static final String BAR_SAVEANDNEW = "bar_saveandnew";
    public static final String BAR_MODIFY = "bar_modify";
    public static final String BAR_SUBMIT = "bar_submit";
    public static final String BAR_AUDIT = "bar_audit";
    public static final String BAR_CLOSELIMIT = "bar_closelimit";
    public static final String BAR_PRINT = "bar_print";
    public static final String NUMBER = "number";
    public static final String TABPAGE_HISTORY = "tabpage_history";
    public static final String ENTRYENTITY = "entryentity";
    private final List<String> hisHeadFields = Arrays.asList("h_id", "h_reason", "h_version", "h_applyid", "h_applycreate", "h_applybillno", "h_creator", "h_createtime");

    protected String getApplyBillEntity() {
        return "bdim_bond_limit";
    }

    protected Map<String, String> getEntryNameAndEntryKey() {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        return entryMap;
    }

    protected String getModifyTabName() {
        return TABPAGE_HISTORY;
    }

    protected String getModifyEntryName() {
        return ENTRYENTITY;
    }

    protected List<String> getShowFieldProp() {
        String prefix = "a_";
        String suffix = ".id";
        ArrayList<String> show = new ArrayList<String>(16);
        show.add("h_version");
        show.add("h_id");
        show.add("h_applyid");
        show.add(prefix + NUMBER);
        show.add(prefix + "name");
        show.add(prefix + "org" + suffix);
        show.add(prefix + "institution");
        show.add(prefix + "finproducts");
        show.add(prefix + "currency" + suffix);
        show.add(prefix + "totalamt");
        show.add(prefix + "effectdate");
        show.add(prefix + "expirydate");
        show.add(prefix + "creator" + suffix);
        show.add(prefix + "modifier" + suffix);
        show.add(prefix + "modifytime");
        return show;
    }

    protected String getClickVersion() {
        return "h_version";
    }

    protected String getClickApplyNo() {
        return "h_applybillno";
    }

    protected List<String> getHiddenButton() {
        return Arrays.asList(BAR_NEW, BAR_DELETE, BAR_SAVE, BAR_SAVEANDNEW, BAR_MODIFY, BAR_SUBMIT, BAR_AUDIT, BAR_CLOSELIMIT, BAR_PRINT);
    }

    protected LocaleString getFormTitle() {
        return new LocaleString(ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c\u989d\u5ea6\u3002", (String)"BondLimitHistoryVersionEdit_1", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
    }

    protected String getBizBillInfo() {
        DynamicObject innerAcct = TmcDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"bdim_bond_limit");
        return SerializationUtils.serializeToBase64((Object)innerAcct);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (Objects.equals(evt.getOperateKey(), "update") && evt.getOperationResult().isSuccess()) {
            this.initModifyInfo();
        }
    }

    protected void dealVsEntryInfo(DynamicObject[] historys, TableValueSetter vs, LinkedHashMap<String, String> maps) {
        for (DynamicObject history : historys) {
            ArrayList<Object> addRow = new ArrayList<Object>(16);
            DynamicObject applyBill = BillChangeHistoryHelper.deserializeBillInfo((DynamicObject)history);
            for (Map.Entry<String, String> map : maps.entrySet()) {
                String key = map.getKey();
                String value = map.getValue();
                if (this.hisHeadFields.contains(value)) {
                    addRow.add(history.get(key));
                    continue;
                }
                addRow.add(this.getRowVal(applyBill, key));
            }
            vs.addRow(addRow.toArray());
        }
    }

    private Object getRowVal(DynamicObject applyBill, String key) {
        DataEntityPropertyCollection properties = applyBill.getDataEntityType().getProperties();
        if ("finproducts".equals(key) && !properties.containsKey((Object)key)) {
            DynamicObject finProduct = applyBill.getDynamicObject("finproduct");
            DynamicObjectCollection products = null;
            if (EmptyUtil.isNoEmpty((DynamicObject)finProduct)) {
                DynamicObjectCollection entryentity = TmcDataServiceHelper.newDynamicObject((String)"bdim_bond_limit").getDynamicObjectCollection(ENTRYENTITY);
                DynamicObject entry = entryentity.addNew();
                products = BondLimitHistoryVersionEdit.generateMultiPropValue(entry, "a_finproducts", finProduct);
            }
            return products;
        }
        return applyBill.get(key);
    }

    public static DynamicObjectCollection generateMultiPropValue(DynamicObject entity, String propName, DynamicObject ... objs) {
        DynamicCollectionProperty currencyProp = (DynamicCollectionProperty)entity.getDynamicObjectType().getProperty(propName);
        DynamicObjectCollection collection = new DynamicObjectCollection(currencyProp.getDynamicCollectionItemPropertyType(), (Object)entity);
        for (DynamicObject obj : objs) {
            DynamicObject newObj = new DynamicObject(currencyProp.getDynamicCollectionItemPropertyType());
            newObj.set("fbasedataid", (Object)obj);
            newObj.set("fbasedataid_id", obj.getPkValue());
            collection.add((Object)newObj);
        }
        return collection;
    }
}

