/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bdim.formplugin.home;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Series;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bdim.common.helper.BondHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.chart.AbstractLineChartEdit;

public class AppHomeBondTypePlugin
extends AbstractLineChartEdit {
    private static final String BOND_BILL_SET = "billno,finproduct.name,drawamount,currency";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_refresh", "histogramchartap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshData();
        super.drawChart();
    }

    public void click(EventObject evt) {
        ChartClickEvent chartClickEvent;
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btn_refresh".equals(key)) {
            this.refreshData();
            super.drawChart();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"AppHomeBondLimitPlugin_1", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
        } else if ("histogramchartap".equals(key) && StringUtils.isNotBlank((CharSequence)(chartClickEvent = (ChartClickEvent)evt).getName())) {
            QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("loantype", "=", (Object)"bond").and("settlestatus", "!=", (Object)"addnew").and("finproduct.name", "=", (Object)chartClickEvent.getName());
            ListShowParameter fsp = new ListShowParameter();
            fsp.setBillFormId("cfm_loanbill_bond");
            fsp.getListFilterParameter().getQFilters().add(qFilter);
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    protected String getXTitleName() {
        return "";
    }

    protected String getYTitleName() {
        return "";
    }

    protected String getChartCtlName() {
        return "histogramchartap";
    }

    protected String[] getXValue() {
        String resultDataStr = this.getPageCache().get("bondtypestatistics");
        List entryList = (List)JSON.parseObject((String)resultDataStr, (TypeReference)new TypeReference<List<Map.Entry<String, BigDecimal>>>(){}, (Feature[])new Feature[0]);
        String[] xValues = entryList.stream().map(Map.Entry::getKey).collect(Collectors.toList()).toArray(new String[entryList.size()]);
        return xValues;
    }

    protected List<Object> getSeriesValue() {
        String resultDataStr = this.getPageCache().get("bondtypestatistics");
        List entryList = (List)JSON.parseObject((String)resultDataStr, (TypeReference)new TypeReference<List<Map.Entry<String, BigDecimal>>>(){}, (Feature[])new Feature[0]);
        List yValue = entryList.stream().map(Map.Entry::getValue).collect(Collectors.toList());
        ArrayList<Object> turnover = new ArrayList<Object>(1);
        turnover.add(yValue);
        return turnover;
    }

    protected void initSeriesStyle(int index, Chart chart, Series series, String color) {
        super.initSeriesStyle(index, chart, series, color);
        BarSeries barSeries = (BarSeries)series;
        Label label = barSeries.getLabel();
        label.setShow(Boolean.TRUE.booleanValue());
        barSeries.setLabel(label);
        barSeries.setItemColor("#40A9FF");
    }

    private void refreshData() {
        List<Map.Entry<String, BigDecimal>> resultData = this.queryBizData();
        String resultDataStr = JSON.toJSONString(resultData);
        this.getPageCache().put("bondtypestatistics", resultDataStr);
    }

    private List<Map.Entry<String, BigDecimal>> queryBizData() {
        HashMap<String, BigDecimal> finProductMap = new HashMap<String, BigDecimal>();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authorizedBankOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cfm_loanbill_bond", (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("org", "in", (Object)authorizedBankOrgId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("loantype", "=", (Object)"bond").and("settlestatus", "!=", (Object)"addnew");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"bondtypestatistics", (String)"cfm_loanbill_bond", (String)BOND_BILL_SET, (QFilter[])qFilter.toArray(), null);
        Iterator iterator = dataSet.iterator();
        DynamicObject currentOrg = TmcOrgDataHelper.getCurrentOrg();
        DynamicObject standardCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)currentOrg.getLong("id"));
        if (EmptyUtil.isEmpty((DynamicObject)standardCurrency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"AppHomeBondLimitPlugin_0", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
        }
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Long currencyId = row.getLong("currency");
            String number = row.getString("billno");
            BigDecimal rate = BondHelper.getRate((Long)currencyId, (DynamicObject)standardCurrency, (DynamicObject)currentOrg, (String)number);
            String finProductName = row.getString("finproduct.name");
            if (EmptyUtil.isEmpty((String)finProductName)) continue;
            if (!finProductMap.containsKey(finProductName)) {
                finProductMap.put(finProductName, BigDecimal.ZERO);
            }
            BigDecimal sumDrawAmount = (BigDecimal)finProductMap.get(finProductName);
            BigDecimal drawAmount = row.getBigDecimal("drawamount");
            if (EmptyUtil.isNoEmpty((BigDecimal)drawAmount)) {
                sumDrawAmount = sumDrawAmount.add(drawAmount.multiply(rate)).setScale(2, 1);
            }
            finProductMap.put(finProductName, sumDrawAmount);
        }
        ArrayList<Map.Entry<String, BigDecimal>> entryList = new ArrayList<Map.Entry<String, BigDecimal>>(finProductMap.entrySet());
        if (entryList.size() <= 10) {
            Collections.sort(entryList, Comparator.comparing(Map.Entry::getValue));
            return entryList;
        }
        for (int i = 0; i < 10; ++i) {
            for (int j = entryList.size() - 1 - i; j >= 1; --j) {
                if (((BigDecimal)((Map.Entry)entryList.get(j)).getValue()).compareTo((BigDecimal)((Map.Entry)entryList.get(j - 1)).getValue()) <= 0) continue;
                Map.Entry temp = (Map.Entry)entryList.get(j - 1);
                entryList.set(j - 1, (Map.Entry<String, BigDecimal>)entryList.get(j));
                entryList.set(j, temp);
            }
        }
        List<Map.Entry<String, BigDecimal>> collect = entryList.stream().limit(10L).collect(Collectors.toList());
        Collections.reverse(collect);
        return collect;
    }
}

