/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bdim.formplugin.intermediaryorgan;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.bdim.common.enums.MidOrgType;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntermediarySelectEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit finProduct = (BasedataEdit)this.getControl("finproduct");
        finProduct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit control = (BasedataEdit)this.getControl("e_midorgname");
        if (control != null) {
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter qFilter = null;
        if ("finproduct".equals(name)) {
            qFilter = new QFilter("finsource", "=", (Object)"bond");
        } else if ("e_midorgname".equals(name)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            int index = beforeF7SelectEvent.getRow();
            DynamicObjectCollection entities = dataEntity.getDynamicObjectCollection("winningbidderentry");
            DynamicObject entry = (DynamicObject)entities.get(index);
            String eMidOrgTypeWin = entry.getString("e_midorgtypewin");
            qFilter = new QFilter("orgtype", "=", (Object)eMidOrgTypeWin);
        }
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            DynamicObject currency = TmcBusinessBaseHelper.getCasBaseCurrency((long)((Long)org.getPkValue()));
            this.getModel().setValue("currency", (Object)currency);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection selectEntry = this.getModel().getEntryEntity("selectentry");
        for (int i = 0; i < selectEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)selectEntry.get(i);
            String eMidOrgType = entry.getString("e_midorgtype");
            this.midOrgTypeChange(eMidOrgType, i, "e_underwritertype");
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("winningbidderentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String eMidOrgType = entry.getString("e_midorgtypewin");
            this.midOrgTypeChange(eMidOrgType, i, "e_underwritertypewin");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int iRow = changeData[0].getRowIndex();
        if (newValue == oldValue) {
            return;
        }
        switch (key) {
            case "e_midorgtype": {
                this.midOrgTypeChange((String)newValue, iRow, "e_underwritertype");
                this.getModel().setValue("e_underwritertype", null);
                break;
            }
            case "e_midorgtypewin": {
                this.midOrgTypeChange((String)newValue, iRow, "e_underwritertypewin");
                this.getModel().setValue("e_underwritertypewin", null, iRow);
                this.getModel().setValue("e_midorgname", null, iRow);
                break;
            }
        }
    }

    private void midOrgTypeChange(String newValue, int index, String underWriterType) {
        Boolean isUnderWriter = "underwriter".equals(newValue);
        ((ComboEdit)this.getControl(underWriterType)).setMustInput(isUnderWriter.booleanValue());
        this.getView().setEnable(isUnderWriter, index, new String[]{underWriterType});
    }

    private void setMidOrgTypeWinCombo(Set<String> midOrgTypeList) {
        ComboEdit midOrgTypeWin = (ComboEdit)this.getView().getControl("e_midorgtypewin");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(5);
        for (String mot : midOrgTypeList) {
            comboItems.add(new ComboItem(new LocaleString(MidOrgType.getName((String)mot)), mot));
        }
        midOrgTypeWin.setComboItems(comboItems);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object newValue = e.getValue();
        if (EmptyUtil.isNoEmpty((Object)newValue)) {
            switch (key) {
                case "e_announcedate": {
                    int announceDateIndex = this.getModel().getEntryCurrentRowIndex("selectentry");
                    String announceDateFmtStr = ((DateEdit)this.getControl("e_announcedate")).getFormatString();
                    Date eAnnounceDate = DateUtils.stringToDate((String)newValue.toString(), (String)announceDateFmtStr);
                    DynamicObject announceDateRow = this.getModel().getEntryRowEntity("selectentry", announceDateIndex);
                    Date eDeadLine = announceDateRow.getDate("e_deadline");
                    if (eDeadLine == null || eDeadLine.compareTo(eAnnounceDate) >= 0) break;
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6295\u6807\u6587\u4ef6\u9012\u4ea4\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u62db\u6807\u6587\u4ef6\u516c\u544a\u65e5\u671f\u3002", (String)"IntermediarySelectEdit_0", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
                    this.getView().updateView(((Control)e.getSource()).getKey(), e.getRowIndex());
                    break;
                }
                case "e_deadline": {
                    Date openingDate;
                    int rowIndex = this.getModel().getEntryCurrentRowIndex("selectentry");
                    String fmtStr = ((DateEdit)this.getControl("e_deadline")).getFormatString();
                    Date deadLine = DateUtils.stringToDate((String)newValue.toString(), (String)fmtStr);
                    DynamicObject entryRow = this.getModel().getEntryRowEntity("selectentry", rowIndex);
                    Date announceDate = entryRow.getDate("e_announcedate");
                    if (announceDate != null && deadLine.compareTo(announceDate) < 0) {
                        e.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6295\u6807\u6587\u4ef6\u9012\u4ea4\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u62db\u6807\u6587\u4ef6\u516c\u544a\u65e5\u671f\u3002", (String)"IntermediarySelectEdit_0", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
                        this.getView().updateView(((Control)e.getSource()).getKey(), e.getRowIndex());
                    }
                    if ((openingDate = entryRow.getDate("e_openingdate")) == null || openingDate.compareTo(deadLine) >= 0) break;
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u6807\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6295\u6807\u6587\u4ef6\u9012\u4ea4\u622a\u6b62\u65e5\u671f\u3002", (String)"IntermediarySelectEdit_1", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
                    this.getView().updateView(((Control)e.getSource()).getKey(), e.getRowIndex());
                    break;
                }
                case "e_openingdate": {
                    int index = this.getModel().getEntryCurrentRowIndex("selectentry");
                    String str = ((DateEdit)this.getControl("e_openingdate")).getFormatString();
                    Date eOpeningDate = DateUtils.stringToDate((String)newValue.toString(), (String)str);
                    DynamicObject row = this.getModel().getEntryRowEntity("selectentry", index);
                    Date eDeadline = row.getDate("e_deadline");
                    if (eDeadline == null || eOpeningDate.compareTo(eDeadline) >= 0) break;
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u6807\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6295\u6807\u6587\u4ef6\u9012\u4ea4\u622a\u6b62\u65e5\u671f\u3002", (String)"IntermediarySelectEdit_1", (String)"tmc-bdim-formplugin", (Object[])new Object[0]));
                    this.getView().updateView(((Control)e.getSource()).getKey(), e.getRowIndex());
                    break;
                }
            }
        }
        if ("e_fee".equals(key) && newValue == null) {
            int eRowIndex = e.getRowIndex();
            this.getModel().setValue("e_fee", (Object)BigDecimal.ZERO, eRowIndex);
            this.getView().updateView("e_fee", eRowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String key = op.getOperateKey();
        if (Arrays.asList("save", "unsubmit", "unaudit").contains(key) && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }
}

