/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.report.plugin;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.tmc.bei.report.helper.BankDailyBalanceQueryHelper;
import kd.tmc.bei.report.helper.BankDailyBalanceTreeQueryHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;

public class BankDailyBalanceListDataPlugin
extends AbstractTmcListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        List<Long> orgIdList = BankDailyBalanceQueryHelper.getQueryOrgIds(reportQueryParam, "filter_org", "filter_orgview");
        if (EmptyUtil.isEmpty(orgIdList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8d44\u91d1\u7ec4\u7ec7\u6743\u9650\u3002", (String)"BankDailyBalanceListDataPlugin_0", (String)"tmc-bei-report", (Object[])new Object[0]));
        }
        paramMap.put("orgIdList", orgIdList);
        DataSet bizDs = BankDailyBalanceQueryHelper.query(paramMap, false);
        List<String> stat = Arrays.asList("reportamount", "reportvalibalance", "reportlstbalance");
        HashMap<String, String> vTreeBaseMap = new HashMap<String, String>(4){
            private static final long serialVersionUID = 1L;
            {
                this.put("companyname", "orgname");
                this.put("orgname", "orgname");
                this.put("company", "rowid");
            }
        };
        DynamicObject reportcurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        Date bizdate = (Date)paramMap.get("filter_bizdate");
        Map<String, String> vbizBaseMap = BankDailyBalanceTreeQueryHelper.getBizBaseMap(bizDs, stat, (Map<String, String>)vTreeBaseMap);
        if (bizdate != null) {
            vbizBaseMap.put("searchdate", "'" + DateUtils.formatString((Date)bizdate, (String)"yyyy-MM-dd") + "'");
        }
        if (reportcurrency != null) {
            vbizBaseMap.put("statcurrency", reportcurrency.getString("id"));
        }
        vbizBaseMap.put("originalamount", "null");
        vbizBaseMap.put("originalvalibalance", "null");
        vbizBaseMap.put("originallstbalance", "null");
        vbizBaseMap.put("currency", "0");
        Long statCurrency = (Long)((DynamicObject)paramMap.get("filter_statcurrency")).getPkValue();
        bizDs = bizDs.addFields(new String[]{statCurrency + "L", "0"}, new String[]{"statcurrency", "sumlevel"});
        bizDs = BankDailyBalanceTreeQueryHelper.getBizDsWithOrgTree(bizDs, "rowid", "company", stat, (Map<String, String>)vTreeBaseMap, vbizBaseMap, orgIdList);
        if (bizDs == null || bizDs.isEmpty()) {
            return this.createEmptyDs();
        }
        bizDs = BankDailyBalanceTreeQueryHelper.getSumDataSet(bizDs, stat, false, this);
        bizDs = bizDs.updateField("reportamount", "reportamount+0.00").updateField("reportvalibalance", "reportvalibalance+0.00").updateField("reportlstbalance", "reportlstbalance+0.00").updateField("originalamount", "case when currency!=0 then originalamount+0.00 end").updateField("originalvalibalance", "case when currency!=0 then originalvalibalance+0.00 end").updateField("originallstbalance", "case when currency!=0 then originallstbalance+0.00 end").orderBy(new String[]{"longnumber"});
        return bizDs;
    }

    private DataSet createEmptyDs() {
        RowMeta rowMeta = new RowMeta(new String[]{"companyname"}, new DataType[]{DataType.StringType});
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
    }
}

