/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.report.print;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.print.dataprovider.ReportDataProvider;
import kd.tmc.bei.report.helper.BankDailyBalanceQueryHelper;
import kd.tmc.fbp.common.enums.AmountUnitEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankDailyBalancePrintPlugin
extends AbstractPrintServicePlugin {
    private static Map<String, Map<String, Class>> COLUMN_CONFIG_MAP = Collections.unmodifiableMap(new HashMap<String, Map<String, Class>>(4){
        {
            this.put(BankDailyBalancePrintPlugin.TABLE_FIELD, new HashMap<String, Class>(32){
                {
                    super(x0);
                    this.put(BankDailyBalancePrintPlugin.COMPANY_NAME, String.class);
                    this.put(BankDailyBalancePrintPlugin.NUMBER, String.class);
                    this.put(BankDailyBalancePrintPlugin.ACCT_NAME, String.class);
                    this.put(BankDailyBalancePrintPlugin.NAME, String.class);
                    this.put(BankDailyBalancePrintPlugin.ACCT_PROPERTY_NAME, String.class);
                    this.put(BankDailyBalancePrintPlugin.ACCT_TYPE, String.class);
                    this.put(BankDailyBalancePrintPlugin.ACCT_STYLE, String.class);
                    this.put(BankDailyBalancePrintPlugin.CURRENCY_NAME, String.class);
                    this.put(BankDailyBalancePrintPlugin.OPEN_ORG_NAME, String.class);
                    this.put(BankDailyBalancePrintPlugin.REPORT_AMOUNT, String.class);
                    this.put(BankDailyBalancePrintPlugin.ORIGINAL_AMOUNT, String.class);
                    this.put(BankDailyBalancePrintPlugin.REPORT_VALIBALANCE, String.class);
                    this.put(BankDailyBalancePrintPlugin.ORIGINAL_VALIBALANCE, String.class);
                    this.put(BankDailyBalancePrintPlugin.REPORT_LSTBALANCE, String.class);
                    this.put(BankDailyBalancePrintPlugin.ORIGINAL_LSTBALANCE, String.class);
                    this.put(BankDailyBalancePrintPlugin.SEARCH_DATE, String.class);
                    this.put(BankDailyBalancePrintPlugin.MODIFY_TIME, Date.class);
                    this.put(BankDailyBalancePrintPlugin.DATA_SOURCE, String.class);
                }
            });
            this.put(BankDailyBalancePrintPlugin.TABLE_HEAD, new HashMap<String, Class>(2){
                {
                    super(x0);
                    this.put(BankDailyBalancePrintPlugin.CURRENCY_UNIT, String.class);
                    this.put(BankDailyBalancePrintPlugin.REPORT_CURRENCY, String.class);
                }
            });
        }
    });
    private static final String TABLE_FIELD = "table_field";
    private static final String TABLE_HEAD = "table_head";
    private static final String COMPANY_NAME = "companyname";
    private static final String NUMBER = "number";
    private static final String ACCT_NAME = "acctname";
    private static final String NAME = "name";
    private static final String ACCT_PROPERTY_NAME = "acctpropertyname";
    private static final String ACCT_TYPE = "accttype";
    private static final String ACCT_STYLE = "acctstyle";
    private static final String CURRENCY_NAME = "currencyname";
    private static final String OPEN_ORG_NAME = "openorgname";
    private static final String REPORT_AMOUNT = "reportamount";
    private static final String ORIGINAL_AMOUNT = "originalamount";
    private static final String REPORT_VALIBALANCE = "reportvalibalance";
    private static final String ORIGINAL_VALIBALANCE = "originalvalibalance";
    private static final String REPORT_LSTBALANCE = "reportlstbalance";
    private static final String ORIGINAL_LSTBALANCE = "originallstbalance";
    private static final String SEARCH_DATE = "searchdate";
    private static final String MODIFY_TIME = "modifytime";
    private static final String DATA_SOURCE = "datasource";
    private static final String CURRENCY_UNIT = "currencyunit";
    private static final String REPORT_CURRENCY = "reportcurrency";

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        DynamicObject reportCurrency;
        super.customPrintDataEntities(e);
        List dyns = e.getDataEntities();
        ReportDataProvider o = (ReportDataProvider)e.getSource();
        ReportQueryParam queryParam = o.getQueryParam();
        String dataSourceName = e.getDataSourceName();
        DynamicObjectType customDT = this.rigisterType(dataSourceName);
        FilterInfo filter = queryParam.getFilter();
        FilterItemInfo filterItem = filter.getFilterItem("filter_statcurrency");
        if (Objects.isNull(filterItem) || Objects.isNull(reportCurrency = (DynamicObject)filterItem.getValue())) {
            return;
        }
        reportCurrency = BusinessDataServiceHelper.loadSingle((Object)reportCurrency.getPkValue(), (DynamicObjectType)reportCurrency.getDynamicObjectType());
        if (StringUtils.equals((CharSequence)dataSourceName, (CharSequence)TABLE_HEAD)) {
            StringBuilder bdcurrency = new StringBuilder();
            String str = ResManager.loadKDString((String)"\u62a5\u544a\u5e01", (String)"BankDailyBalancePrintPlugin_1", (String)"tmc-bei-report", (Object[])new Object[0]);
            bdcurrency.append(str);
            bdcurrency.append(":");
            bdcurrency.append(reportCurrency.getString(NAME));
            StringBuilder currencyUnit = new StringBuilder();
            currencyUnit.append(ResManager.loadKDString((String)"\u7edf\u8ba1\u5355\u4f4d\uff1a", (String)"BankDailyBalancePrintPlugin_2", (String)"tmc-bei-report", (Object[])new Object[0]));
            String statisticunit = filter.getString("filter_currencyunit");
            currencyUnit.append(AmountUnitEnum.getName((String)statisticunit));
            DynamicObject capitalsumhead = new DynamicObject(customDT);
            capitalsumhead.set(CURRENCY_UNIT, (Object)currencyUnit.toString());
            capitalsumhead.set(REPORT_CURRENCY, (Object)bdcurrency);
            dyns.add(capitalsumhead);
        } else if (StringUtils.equals((CharSequence)dataSourceName, (CharSequence)TABLE_FIELD)) {
            DataSet dataSet = BankDailyBalanceQueryHelper.query(queryParam);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                DynamicObject capitalsumbody = this.fillData(row, customDT, reportCurrency);
                dyns.add(capitalsumbody);
            }
            if (EmptyUtil.isNoEmpty((Object)dataSet)) {
                dataSet.close();
            }
        }
    }

    private DynamicObject fillData(Row row, DynamicObjectType customDT, DynamicObject reportCurrency) {
        DataEntityPropertyCollection properties = customDT.getProperties();
        DynamicObject capitalsumbody = new DynamicObject(customDT);
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            capitalsumbody.set(name, this.getValueFormatIfNeed(name, row, reportCurrency));
        }
        return capitalsumbody;
    }

    private Object getValueFormatIfNeed(String name, Row row, DynamicObject reportCurrency) {
        Object obj = row.get(name);
        if (Objects.isNull(obj)) {
            return "";
        }
        switch (name) {
            case "accttype": {
                return this.getAcctType(obj);
            }
            case "acctstyle": {
                return this.getAcctStyle(obj);
            }
            case "reportamount": 
            case "reportvalibalance": 
            case "reportlstbalance": {
                String reportCurrencySign = reportCurrency.getString("sign");
                Integer reportCurrencyAmtPrecision = reportCurrency.getInt("amtprecision");
                return this.getAmountValue(obj, reportCurrencySign, reportCurrencyAmtPrecision);
            }
            case "originalamount": 
            case "originalvalibalance": 
            case "originallstbalance": {
                String currencySign = row.getString("currencysign");
                Integer currencyAmtPrecision = row.getInteger("currencyamtprecision");
                return this.getAmountValue(obj, currencySign, currencyAmtPrecision);
            }
            case "datasource": {
                return this.getDataSource(obj);
            }
            case "modifytime": {
                return obj;
            }
        }
        return obj.toString();
    }

    private String getDataSource(Object obj) {
        String value;
        switch (value = (String)obj) {
            case "frombank": {
                return ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3", (String)"AbstractBeiQingAnlsDataPlugin_9", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "import": {
                return ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u5165", (String)"AbstractBeiQingAnlsDataPlugin_10", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "modify": {
                return ResManager.loadKDString((String)"\u7cfb\u7edf\u4fee\u590d", (String)"AbstractBeiQingAnlsDataPlugin_11", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String getAmountValue(Object obj, String currencySign, Integer currencyAmtPrecision) {
        String value = "";
        if (obj instanceof Integer) {
            value = obj.toString();
        } else {
            if (obj instanceof BigDecimal) {
                BigDecimal amount = (BigDecimal)obj;
                if (amount.compareTo(BigDecimal.ZERO) == 0) {
                    return BigDecimal.ZERO.toString();
                }
                return currencySign + BankDailyBalancePrintPlugin.formatDecimal(amount, currencyAmtPrecision);
            }
            if (obj instanceof Double) {
                Double doubleValue = (Double)obj;
                BigDecimal decimal = BigDecimal.valueOf(doubleValue);
                return currencySign + BankDailyBalancePrintPlugin.formatDecimal(decimal, currencyAmtPrecision);
            }
            value = obj.toString();
        }
        return value;
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(BankDailyBalancePrintPlugin.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String toPattern(int scale) {
        StringBuilder s = new StringBuilder(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append('0');
        }
        return s.toString();
    }

    private String getAcctStyle(Object obj) {
        String value;
        switch (value = (String)obj) {
            case "basic": {
                return ResManager.loadKDString((String)"\u57fa\u672c\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_0", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "normal": {
                return ResManager.loadKDString((String)"\u4e00\u822c\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_1", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "temp": {
                return ResManager.loadKDString((String)"\u4e34\u65f6\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_2", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "spcl": {
                return ResManager.loadKDString((String)"\u4e13\u7528\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_3", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "fgn_curr": {
                return ResManager.loadKDString((String)"\u7ecf\u5e38\u9879\u76ee\u5916\u6c47\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_4", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "fng_fin": {
                return ResManager.loadKDString((String)"\u8d44\u672c\u9879\u76ee\u5916\u6c47\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_5", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String getAcctType(Object obj) {
        String value;
        switch (value = (String)obj) {
            case "in_out": {
                return ResManager.loadKDString((String)"\u6536\u652f\u6237", (String)"AbstractBeiQingAnlsDataPlugin_6", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "in": {
                return ResManager.loadKDString((String)"\u6536\u5165\u6237", (String)"AbstractBeiQingAnlsDataPlugin_7", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
            case "out": {
                return ResManager.loadKDString((String)"\u652f\u51fa\u6237", (String)"AbstractBeiQingAnlsDataPlugin_8", (String)"tmc-bei-report", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private DynamicObjectType rigisterType(String dataSourceName) {
        DynamicObjectType customDT = new DynamicObjectType();
        Map<String, Class> classMap = COLUMN_CONFIG_MAP.get(dataSourceName);
        if (Objects.isNull(classMap)) {
            return customDT;
        }
        for (Map.Entry<String, Class> entry : classMap.entrySet()) {
            Class clazz = entry.getValue();
            customDT.registerProperty(entry.getKey(), entry.getValue(), this.getDefaultValue(clazz), false);
        }
        return customDT;
    }

    private Object getDefaultValue(Class clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return "";
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return BigDecimal.ZERO;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return 0;
        }
        return null;
    }
}

