/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.report.print;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ObjectField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.tmc.bei.report.helper.BankDailyBalanceQueryHelper;
import kd.tmc.fbp.common.enums.AmountUnitEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankDailyBalancePrintPluginNew
extends AbstractPrintPlugin {
    private static final String TABLE_FIELD = "table_field";
    private static final String TABLE_HEAD = "table_head";
    private static final String ACCT_TYPE = "accttype";
    private static final String ACCT_STYLE = "acctstyle";
    private static final String REPORT_AMOUNT = "reportamount";
    private static final String ORIGINAL_AMOUNT = "originalamount";
    private static final String REPORT_VALIBALANCE = "reportvalibalance";
    private static final String ORIGINAL_VALIBALANCE = "originalvalibalance";
    private static final String REPORT_LSTBALANCE = "reportlstbalance";
    private static final String ORIGINAL_LSTBALANCE = "originallstbalance";
    private static final String MODIFY_TIME = "modifytime";
    private static final String DATA_SOURCE = "datasource";
    private static final String CURRENCY_UNIT = "currencyunit";
    private static final String REPORT_CURRENCY = "reportcurrency";
    private static final String SYSTEM_TYPE = "tmc-bei-report";

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        String dataSourceName = dataSource.getDsName();
        IFormView rptFormView = SessionManager.getCurrent().getView(dataSource.getPageId());
        DynamicObject reportCurrency = null;
        Map<String, Object> filterValueMap = null;
        String statisticunit = "";
        if (rptFormView instanceof ReportView) {
            ReportListModel listModel = (ReportListModel)((ReportView)rptFormView).getReportList().getReportModel();
            filterValueMap = listModel.getReportQueryParam().getFilter().getFilterItems().stream().filter(f -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)f.getPropName()) && f.getValue() != null).collect(Collectors.toMap(FilterItemInfo::getPropName, FilterItemInfo::getValue));
            reportCurrency = (DynamicObject)filterValueMap.get("filter_statcurrency");
        }
        if (StringUtils.equals((CharSequence)dataSourceName, (CharSequence)TABLE_HEAD)) {
            StringBuilder bdcurrency = new StringBuilder();
            List customDataRows = evt.getCustomDataRows();
            String str = ResManager.loadKDString((String)"\u62a5\u544a\u5e01", (String)"BankDailyBalancePrintPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            bdcurrency.append(str);
            bdcurrency.append(":");
            if (reportCurrency != null) {
                bdcurrency.append(reportCurrency.getString("name"));
            }
            StringBuilder currencyUnit = new StringBuilder();
            currencyUnit.append(ResManager.loadKDString((String)"\u7edf\u8ba1\u5355\u4f4d\uff1a", (String)"BankDailyBalancePrintPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            if (filterValueMap != null) {
                statisticunit = (String)filterValueMap.get("filter_currencyunit");
            }
            currencyUnit.append(AmountUnitEnum.getName((String)statisticunit));
            DataRowSet capitalsumhead = new DataRowSet();
            capitalsumhead.put(CURRENCY_UNIT, (Field)new TextField(currencyUnit.toString()));
            capitalsumhead.put(REPORT_CURRENCY, (Field)new TextField(bdcurrency.toString()));
            customDataRows.add(capitalsumhead);
        } else if (TABLE_FIELD.equals(dataSourceName)) {
            List queryField = dataSource.getQueryField();
            List customDataRows = evt.getCustomDataRows();
            if (rptFormView instanceof ReportView) {
                ReportListModel listModel = (ReportListModel)((ReportView)rptFormView).getReportList().getReportModel();
                ReportQueryParam queryParam = listModel.getReportQueryParam();
                DataSet dataSet = BankDailyBalanceQueryHelper.query(queryParam);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    DataRowSet dataRowSet = this.fillData(row, queryField, reportCurrency);
                    customDataRows.add(dataRowSet);
                }
                if (EmptyUtil.isNoEmpty((Object)dataSet)) {
                    dataSet.close();
                }
            }
        }
    }

    private DataRowSet fillData(Row row, List<String> queryField, DynamicObject reportCurrency) {
        DataRowSet dataRowSet = new DataRowSet();
        for (String name : queryField) {
            dataRowSet.put(name, (Field)new ObjectField(this.getValueFormatIfNeed(name, row, reportCurrency)));
        }
        return dataRowSet;
    }

    private Object getValueFormatIfNeed(String name, Row row, DynamicObject reportCurrency) {
        Object obj = row.get(name);
        if (Objects.isNull(obj)) {
            return "";
        }
        switch (name) {
            case "accttype": {
                return this.getAcctType(obj);
            }
            case "acctstyle": {
                return this.getAcctStyle(obj);
            }
            case "reportamount": 
            case "reportvalibalance": 
            case "reportlstbalance": {
                String reportCurrencySign = reportCurrency.getString("sign");
                Integer reportCurrencyAmtPrecision = reportCurrency.getInt("amtprecision");
                return this.getAmountValue(obj, reportCurrencySign, reportCurrencyAmtPrecision);
            }
            case "originalamount": 
            case "originalvalibalance": 
            case "originallstbalance": {
                String currencySign = row.getString("currencysign");
                Integer currencyAmtPrecision = row.getInteger("currencyamtprecision");
                return this.getAmountValue(obj, currencySign, currencyAmtPrecision);
            }
            case "datasource": {
                return this.getDataSource(obj);
            }
            case "modifytime": {
                return obj;
            }
        }
        return obj.toString();
    }

    private String getAcctType(Object obj) {
        String value;
        switch (value = (String)obj) {
            case "in_out": {
                return ResManager.loadKDString((String)"\u6536\u652f\u6237", (String)"AbstractBeiQingAnlsDataPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            case "in": {
                return ResManager.loadKDString((String)"\u6536\u5165\u6237", (String)"AbstractBeiQingAnlsDataPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            case "out": {
                return ResManager.loadKDString((String)"\u652f\u51fa\u6237", (String)"AbstractBeiQingAnlsDataPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String getAcctStyle(Object obj) {
        String value;
        switch (value = (String)obj) {
            case "basic": {
                return ResManager.loadKDString((String)"\u57fa\u672c\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            case "normal": {
                return ResManager.loadKDString((String)"\u4e00\u822c\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            case "temp": {
                return ResManager.loadKDString((String)"\u4e34\u65f6\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            case "spcl": {
                return ResManager.loadKDString((String)"\u4e13\u7528\u5b58\u6b3e\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            case "fgn_curr": {
                return ResManager.loadKDString((String)"\u7ecf\u5e38\u9879\u76ee\u5916\u6c47\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            case "fng_fin": {
                return ResManager.loadKDString((String)"\u8d44\u672c\u9879\u76ee\u5916\u6c47\u8d26\u6237", (String)"AbstractBeiQingAnlsDataPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String getAmountValue(Object obj, String currencySign, Integer currencyAmtPrecision) {
        String value;
        if (obj instanceof Integer) {
            value = obj.toString();
        } else {
            if (obj instanceof BigDecimal) {
                BigDecimal amount = (BigDecimal)obj;
                if (amount.compareTo(BigDecimal.ZERO) == 0) {
                    return BigDecimal.ZERO.toString();
                }
                return currencySign + BankDailyBalancePrintPluginNew.formatDecimal(amount, currencyAmtPrecision);
            }
            if (obj instanceof Double) {
                Double doubleValue = (Double)obj;
                BigDecimal decimal = BigDecimal.valueOf(doubleValue);
                return currencySign + BankDailyBalancePrintPluginNew.formatDecimal(decimal, currencyAmtPrecision);
            }
            value = obj.toString();
        }
        return value;
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(BankDailyBalancePrintPluginNew.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String toPattern(int scale) {
        StringBuilder s = new StringBuilder(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append('0');
        }
        return s.toString();
    }

    private String getDataSource(Object obj) {
        String value;
        switch (value = (String)obj) {
            case "frombank": {
                return ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3", (String)"AbstractBeiQingAnlsDataPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            case "import": {
                return ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u5165", (String)"AbstractBeiQingAnlsDataPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            case "modify": {
                return ResManager.loadKDString((String)"\u7cfb\u7edf\u4fee\u590d", (String)"AbstractBeiQingAnlsDataPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
        }
        return "";
    }
}

