/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.agentpay;

import java.math.RoundingMode;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.tmc.bei.common.convert.AbstractBillConverter;
import kd.tmc.bei.common.convert.BankAgentUpdateStatPushConverter;
import kd.tmc.bei.common.helper.PayStateUpdateHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class BankAgentPayList
extends AbstractTmcBillBaseList {
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setStatus(OperationStatus.VIEW);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean isSuccess;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        AbstractOperate source = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String key = source.getOperateKey();
        String successMessage = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"BankAgentPayList_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
        boolean showSuccess = true;
        switch (key) {
            case "bitback": {
                successMessage = ResManager.loadKDString((String)"\u6253\u56de\u6210\u529f\u3002", (String)"BankAgentPayList_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
                ((ListView)this.getView()).refresh();
                break;
            }
            case "syncstatus": {
                successMessage = ResManager.loadKDString((String)"\u540c\u6b65\u5355\u636e\u72b6\u6001\u6210\u529f\u3002", (String)"BankAgentPayList_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
                ((ListView)this.getView()).refresh();
                break;
            }
            case "commitbe": {
                successMessage = ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u6210\u529f\u3002", (String)"BankAgentPayList_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
                ((ListView)this.getView()).refresh();
                break;
            }
            case "repay": {
                showSuccess = false;
                break;
            }
            case "updatestatpush": {
                showSuccess = false;
                List successPkIds = operationResult.getSuccessPkIds();
                if (successPkIds.size() <= 0) break;
                BillList billList = (BillList)this.getControl("billlistap");
                PayStateUpdateHelper.showTemplateEditForm((IFormView)this.getView(), (List)successPkIds, (String)billList.getEntityId(), (AbstractBillConverter)new BankAgentUpdateStatPushConverter());
                break;
            }
            default: {
                showSuccess = false;
            }
        }
        if (operationResult != null && (isSuccess = operationResult.isSuccess()) && showSuccess) {
            this.getView().showSuccessNotification(successMessage, Integer.valueOf(2000));
        }
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        super.beforeQueryOfExport(e);
        String selectFields = e.getSelectFields();
        Set fieldSet = Stream.of(selectFields.split(",")).collect(Collectors.toSet());
        if (!fieldSet.contains("recamount")) {
            selectFields = selectFields + ",recamount";
            e.setSelectFields(selectFields);
        }
        if (!fieldSet.contains("recaccountbank")) {
            selectFields = selectFields + ",recaccountbank";
            e.setSelectFields(selectFields);
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] datas;
        super.afterQueryOfExport(e);
        for (DynamicObject data : datas = e.getQueryValues()) {
            boolean encrypt = data.getBoolean("isencryption");
            int amtPrecision = data.getDynamicObject("currency").getInt("amtprecision");
            String sign = data.getDynamicObject("currency").getString("sign");
            DynamicObjectCollection entryCol = data.getDynamicObjectCollection("entrys");
            for (DynamicObject row : entryCol) {
                String recAmountStr;
                String bankAcctNum = row.getString("recaccountbank");
                if (encrypt) {
                    recAmountStr = "**.**";
                    if (bankAcctNum.length() > 8) {
                        String head = bankAcctNum.substring(0, 4);
                        String tail = bankAcctNum.substring(bankAcctNum.length() - 4);
                        bankAcctNum = head + "****" + tail;
                    }
                } else {
                    recAmountStr = sign + row.getBigDecimal("recamount").setScale(amtPrecision, RoundingMode.UNNECESSARY).toString();
                }
                row.set("enc_recamountfake", (Object)recAmountStr);
                row.set("enc_recaccountbank", (Object)bankAcctNum);
            }
        }
    }
}

