/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.balance;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class BalanceBatchAddBaseInfo
extends AbstractTmcBillEdit {
    private static final String OP_NEXT = "next";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String SYSTEM_TYPE = "tmc-bei-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.bankAcctF7Init();
        this.companyF7Init();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)START_DATE, (Object)DateUtils.truncateDate((Date)new Date()));
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)END_DATE, (Object)DateUtils.truncateDate((Date)new Date()));
        this.getView().updateView("bizdate");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        if (fieldName.equals("company")) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"accountbank", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        Date startDate = (Date)this.getModel().getValue(START_DATE);
        Date endDate = (Date)this.getModel().getValue(END_DATE);
        if (OP_NEXT.equals(operateKey)) {
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("accountbank"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u94f6\u884c\u8d26\u6237\u3002", (String)"BalanceAddByHand_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (startDate.after(endDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u8981\u5927\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"SyncBalance_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (endDate.after(new Date())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7cfb\u7edf\u5f53\u524d\u65e5\u671f\u3002", (String)"SyncBalance_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OP_NEXT.equals(operateKey) && args.getOperationResult().isSuccess()) {
            FormShowParameter showForm = new FormShowParameter();
            showForm.setFormId("bei_balancebatadd_detail");
            showForm.getOpenStyle().setShowType(ShowType.Modal);
            showForm.setCustomParam("company", this.getModel().getValue("company"));
            showForm.setCustomParam("accountbank", this.getModel().getValue("accountbank"));
            showForm.setCustomParam(START_DATE, this.getModel().getValue(START_DATE));
            showForm.setCustomParam(END_DATE, this.getModel().getValue(END_DATE));
            showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bei_balancebatadd_detail"));
            this.getView().showForm(showForm);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map resultMap;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("bei_balancebatadd_detail".equals(actionId) && !EmptyUtil.isEmpty((Object)(resultMap = (Map)closedCallBackEvent.getReturnData()))) {
            this.getView().returnDataToParent((Object)resultMap);
            this.getView().close();
        }
    }

    private void bankAcctF7Init() {
        BasedataEdit bankAcctF7 = (BasedataEdit)this.getControl("accountbank");
        bankAcctF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("finorgtype", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            qFilter.and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
            qFilter.and("isvirtual", "=", (Object)"0");
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("company"))) {
                String appId = this.getView().getFormShowParameter().getAppId();
                List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"bei_bankbalance", (String)"47150e89000000ac");
                qFilter.and(new QFilter("company", "in", (Object)authOrgList));
            } else {
                DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("company");
                Set companyIds = company.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                qFilter.and(new QFilter("company", "in", companyIds));
            }
            DynamicObjectCollection banks = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])new QFilter[]{qFilter.copy().and("entry.e_bankfunction", "=", (Object)BankFuncEnum.QUERY.getValue()).and("entry.e_enable", "=", (Object)"1")});
            QFilter interfaceFilter = banks != null && !banks.isEmpty() ? new QFilter("issetbankinterface", "=", (Object)"0").or(new QFilter("id", "not in", banks.stream().map(b -> b.getLong("id")).collect(Collectors.toSet())).and("entry.e_enable", "=", (Object)"1")) : new QFilter("issetbankinterface", "=", (Object)"0").or(new QFilter("entry.e_enable", "=", (Object)"1"));
            showParameter.getListFilterParameter().setFilter(qFilter.and(interfaceFilter));
        });
    }

    private void companyF7Init() {
        BasedataEdit companyF7 = (BasedataEdit)this.getControl("company");
        companyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"bei_bankbalance", (String)"47150e89000000ac");
            QFilter qFilter = new QFilter("id", "in", (Object)authOrgList);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }
}

