/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.balance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.dync.AbstractTmcDyncListPlugin;

public abstract class BalanceCheckViewList
extends AbstractTmcDyncListPlugin {
    protected List<Long> selectedOrgIdList = new ArrayList<Long>(10);
    protected List<Long> selectFinancialTypeIdList = new ArrayList<Long>(10);
    protected List<Long> selectedBankIdList = new ArrayList<Long>(10);
    protected List<DynamicObject> accountBankList;
    protected boolean isFinOrgInfo;
    protected FilterContainerInitArgs initArgs;
    private static final String OPEN_FLAG = "isPageOpen";
    private static final String FINORGTYPE_NAME_FILTER = "financialtype.name";
    private static final String CACHE_FINORGTYPE = "financialtype";

    public void filterContainerInit(FilterContainerInitEvent event) {
        FilterContainerInitArgs args;
        super.filterContainerInit(event);
        Iterator columnIterator = event.getCommonFilterColumns().iterator();
        while (columnIterator.hasNext()) {
            String fieldName = ((FilterColumn)columnIterator.next()).getFieldName();
            if (!FINORGTYPE_NAME_FILTER.equals(fieldName)) continue;
            columnIterator.remove();
        }
        this.initArgs = args = new FilterContainerInitArgs(event);
        IPageCache pageCache = this.getPageCache();
        if (EmptyUtil.isEmpty((String)pageCache.get(OPEN_FLAG))) {
            super.filterContainerInit(args);
            pageCache.put(OPEN_FLAG, Boolean.TRUE.toString());
            ArrayList<QFilter> qFilterStrList = new ArrayList<QFilter>(10);
            for (FilterColumn filterColumn : event.getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (!"bizdate".equals(fieldName)) continue;
                qFilterStrList.add(new QFilter("bizdate", ">=", (Object)DateUtils.getCurrentDate()));
            }
            Map<String, List<Object>> filterMap = event.getCommonFilterColumns().stream().filter(t -> EmptyUtil.isNoEmpty((Object)t.getFilterColumns())).collect(Collectors.toMap(FilterColumn::getFilterFieldName, FilterColumn::getDefaultValues, (p, q) -> p));
            if (!EmptyUtil.isEmpty((Collection)event.getFastFilterColumns())) {
                event.getFastFilterColumns().remove(0);
            }
            List<Long> orgList = this.filterValueToLongList(filterMap.get("company.id"));
            filterMap.put("bank.finorgtype.id", this.initAccountFinOrg(orgList, this.filterValueToLongList(filterMap.get("bank.finorgtype.id"))));
            qFilterStrList.addAll(this.setCommonFilter(filterMap));
            List stringList = qFilterStrList.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
            pageCache.put("qfilters", SerializationUtils.toJsonString(stringList));
            this.fillPageData();
        }
    }

    public void filterSearchClickEvent(SearchClickEvent event) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        for (QFilter qFilter : event.getFilterParameter().getQFilters()) {
            this.addFilterWithNest("bizdate", qFilter, qFilterList);
        }
        Map filtervalue = event.getFilterValues();
        List customfilterList = (List)filtervalue.get("customfilter");
        List fastfilter = (List)filtervalue.get("fastfilter");
        HashMap<String, List<Object>> customfilterMap = new HashMap<String, List<Object>>(16);
        if (customfilterList != null) {
            for (Object map : customfilterList) {
                if (((List)map.get("Value")).size() == 1 && StringUtils.equals((CharSequence)"", (CharSequence)((List)map.get("Value")).get(0).toString())) continue;
                customfilterMap.put(((List)map.get("FieldName")).get(0).toString(), (List<Object>)map.get("Value"));
            }
        }
        customfilterMap.put("bank.finorgtype.id", this.initAccountFinOrg(this.filterValueToLongList((List)customfilterMap.get("company.id")), this.filterValueToLongList((List)customfilterMap.get("bank.finorgtype.id"))));
        if (event.getCurrentCommonFilter() != null) {
            Object clickFieldName;
            switch (clickFieldName = ((List)event.getCurrentCommonFilter().get("FieldName")).get(0).toString()) {
                case "company.id": 
                case "bank.finorgtype.id": {
                    customfilterMap.put("bank.bank_cate.id", null);
                    customfilterMap.put("accountbank.id", null);
                    break;
                }
                case "bank.bank_cate.id": {
                    customfilterMap.put("accountbank.id", null);
                    break;
                }
            }
        }
        filtervalue.put("customfilter", new ArrayList());
        qFilterList.addAll(this.setCommonFilter(customfilterMap));
        if (!EmptyUtil.isEmpty((Collection)fastfilter)) {
            for (Object map : fastfilter) {
                List values = (List)map.get("Value");
                if (null == values || values.size() <= 0) continue;
                qFilterList.add(new QFilter("accountbank.bankaccountnumber", "in", (Object)values));
            }
        }
        List qFilterStrList = qFilterList.stream().map(QFilter::toSerializedString).collect(Collectors.toList());
        this.getPageCache().put("qfilters", SerializationUtils.toJsonString(qFilterStrList));
        this.fillPageData();
    }

    protected String getEntityName() {
        return "bei_bankbalance_checkview";
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List qfilters = args.getQfilters();
        List cacheFilter = this.getQFilterFromPagCache();
        if (null != cacheFilter) {
            Map filterMap = cacheFilter.stream().collect(Collectors.toMap(QFilter::getProperty, Function.identity(), (p, q) -> p));
            QFilter orgFilter = (QFilter)filterMap.get("company.id");
            QFilter finTypeFilter = (QFilter)filterMap.get("bank.finorgtype.id");
            QFilter bankCateFilter = (QFilter)filterMap.get("bank.bank_cate.id");
            QFilter bankFilter = (QFilter)filterMap.get("bank.id");
            List selectOrgs = Objects.nonNull(orgFilter) ? (List)orgFilter.getValue() : Collections.emptyList();
            List selectFinType = Objects.nonNull(finTypeFilter) ? (List)finTypeFilter.getValue() : Collections.emptyList();
            IPageCache pageCache = this.getPageCache();
            boolean isFinOrg = Boolean.parseBoolean(pageCache.get(CACHE_FINORGTYPE));
            if ("bank.bank_cate.id".equals(fieldName)) {
                String selectField;
                String string = selectField = isFinOrg ? "bank.id" : "bank.bank_cate.id";
                if (isFinOrg) {
                    args.setRefEntityId("bd_finorginfo");
                }
                Set cateIds = this.getAccountBankList(selectOrgs, selectFinType, null).stream().map(t -> t.getLong(selectField)).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
                qfilters.add(new QFilter("id", "in", cateIds));
            } else if ("accountbank.id".equals(fieldName)) {
                if (Objects.nonNull(orgFilter)) {
                    qfilters.add(orgFilter);
                }
                if (Objects.nonNull(bankCateFilter)) {
                    qfilters.add(bankCateFilter);
                }
                if (Objects.nonNull(bankFilter)) {
                    qfilters.add(bankFilter);
                }
            }
        }
    }

    protected List<Long> filterValueToLongList(List<Object> objectList) {
        return Optional.ofNullable(objectList).orElseGet(Collections::emptyList).stream().filter(StringUtils::isNotBlank).map(t -> Long.parseLong(t.toString())).collect(Collectors.toList());
    }

    private List<ComboItem> initFinOrgTypeItemsList() {
        return this.accountBankList.stream().map(t -> new ComboItem(new LocaleString(t.getString("bank.finorgtype.name")), t.getString("bank.finorgtype.id"))).distinct().collect(Collectors.toList());
    }

    private List<ComboItem> initBankItemsList() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        if (EmptyUtil.isNoEmpty(this.selectFinancialTypeIdList)) {
            long finOrgTypeId = this.selectFinancialTypeIdList.get(0);
            List accountBanks = this.accountBankList.stream().filter(t -> t.getLong("bank.finorgtype.id") == finOrgTypeId).collect(Collectors.toList());
            for (DynamicObject cashAcct : accountBanks) {
                ComboItem item = new ComboItem();
                if (!this.isFinOrgInfo) {
                    item.setCaption(new LocaleString(cashAcct.getString("bank.bank_cate.name")));
                    item.setValue(cashAcct.getString("bank.bank_cate.id"));
                } else {
                    item.setCaption(new LocaleString(cashAcct.getString("bank.name")));
                    item.setValue(cashAcct.getString("bank.id"));
                }
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
        } else {
            acctItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"TmcTradeFilterPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0])), ""));
        }
        return acctItems;
    }

    private List<ComboItem> initAcctItemsList() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        if (EmptyUtil.isEmpty(this.selectFinancialTypeIdList)) {
            return acctItems;
        }
        long finOrgTypeId = this.selectFinancialTypeIdList.get(0);
        List accountBanks = this.accountBankList.stream().filter(t -> t.getLong("bank.finorgtype.id") == finOrgTypeId).collect(Collectors.toList());
        if (!this.selectedBankIdList.isEmpty()) {
            String fieldFilter = this.isFinOrgInfo ? "bank.id" : "bank.bank_cate.id";
            accountBanks = accountBanks.stream().filter(t -> this.selectedBankIdList.contains(t.getLong(fieldFilter))).collect(Collectors.toList());
        }
        if (EmptyUtil.isNoEmpty(accountBanks)) {
            for (DynamicObject cashAcct : accountBanks) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("bankaccountnumber")));
                item.setValue(cashAcct.getString("id"));
                acctItems.add(item);
            }
        } else {
            acctItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"TmcTradeFilterPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0])), ""));
        }
        return acctItems;
    }

    private boolean isFinOrgBank(List<Long> finOrgIdList) {
        boolean isBank = true;
        if (EmptyUtil.isNoEmpty(finOrgIdList)) {
            DynamicObject bankObj = QueryServiceHelper.queryOne((String)"bd_finorgtype", (String)"id", (QFilter[])new QFilter("number", "=", (Object)FinOrgTypeEnum.BANK.getNumber()).toArray());
            isBank = bankObj.getLong("id") == finOrgIdList.get(0).longValue();
        }
        return isBank;
    }

    protected List<DynamicObject> getAccountBankList(List<Long> selectedOrgIdList, List<Long> selectFinancialTypeIdList, List<Long> selectedBankIdList) {
        String selectProperties = "id,name,number,defaultcurrency.id,bankaccountnumber,defaultcurrency.name,currency.fbasedataid.*,bank,bank.bank_cate,bank.finorgtype";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (EmptyUtil.isNoEmpty(selectedOrgIdList)) {
            qfilters.add(new QFilter("company.id", "in", selectedOrgIdList));
        }
        if (EmptyUtil.isNoEmpty(selectFinancialTypeIdList)) {
            qfilters.add(new QFilter("bank.finorgtype.id", "in", selectFinancialTypeIdList));
        }
        if (EmptyUtil.isNoEmpty(selectedBankIdList)) {
            if (this.isFinOrgBank(selectFinancialTypeIdList)) {
                qfilters.add(new QFilter("bank.bank_cate.id", "in", selectedBankIdList));
            } else {
                qfilters.add(new QFilter("bank.id", "in", selectedBankIdList));
            }
        }
        qfilters.add(VisibleVirtualAcctHelper.notVirtualAcctQf());
        List<Object> list = new ArrayList(BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0])).values());
        list = list.stream().filter(t -> EmptyUtil.isNoEmpty((Object)t.get("bank.finorgtype"))).collect(Collectors.toList());
        list.sort(Comparator.comparing(t -> t.getString("bank.finorgtype.number")));
        return list;
    }

    protected List<Object> getSelectedFinOrg(List<Long> selectFinTypeList) {
        if (this.accountBankList.isEmpty()) {
            this.isFinOrgInfo = false;
            return Collections.emptyList();
        }
        DynamicObject account = null;
        if (EmptyUtil.isNoEmpty(selectFinTypeList)) {
            long finOrgTypeId = selectFinTypeList.get(0);
            List accountBanks = this.accountBankList.stream().filter(t -> t.getLong("bank.finorgtype.id") == finOrgTypeId).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(accountBanks)) {
                account = (DynamicObject)accountBanks.get(0);
            }
        } else {
            account = this.accountBankList.get(0);
        }
        if (null != account) {
            DynamicObject bankObj = QueryServiceHelper.queryOne((String)"bd_finorgtype", (String)"id", (QFilter[])new QFilter("number", "=", (Object)FinOrgTypeEnum.BANK.getNumber()).toArray());
            this.isFinOrgInfo = bankObj.getLong("id") != account.getLong("bank.finorgtype.id");
            return Collections.singletonList(account.getString("bank.finorgtype.id"));
        }
        this.isFinOrgInfo = false;
        return Collections.emptyList();
    }

    protected List<Object> initAccountFinOrg(List<Long> selectedOrgIdList, List<Long> selectFinTypeList) {
        this.accountBankList = this.getAccountBankList(selectedOrgIdList, null, null);
        List<Object> selectedFinOrg = this.getSelectedFinOrg(selectFinTypeList);
        IPageCache pageCache = this.getPageCache();
        pageCache.put(CACHE_FINORGTYPE, Boolean.valueOf(this.isFinOrgInfo).toString());
        return selectedFinOrg;
    }

    protected List<QFilter> setCommonFilter(Map<String, List<Object>> customfilterMap) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        this.selectedOrgIdList = this.filterValueToLongList(customfilterMap.get("company.id"));
        this.selectFinancialTypeIdList = this.filterValueToLongList(customfilterMap.get("bank.finorgtype.id"));
        this.selectedBankIdList = this.filterValueToLongList(customfilterMap.get("bank.bank_cate.id"));
        List<ComboItem> finOrgTypeItems = this.initFinOrgTypeItemsList();
        List<ComboItem> bankCateItems = this.initBankItemsList();
        List<ComboItem> bankNumberItems = this.initAcctItemsList();
        block14: for (FilterColumn filterColumn : this.initArgs.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List listcomitem = commonFilterColumn.getComboItems();
            switch (fieldName) {
                case "company.name": {
                    if (!EmptyUtil.isEmpty((Collection)customfilterMap.get("company.id"))) {
                        commonFilterColumn.setDefaultValues(customfilterMap.get("company.id"));
                    } else {
                        commonFilterColumn.setDefaultValues(new ArrayList());
                    }
                    if (EmptyUtil.isEmpty((Collection)commonFilterColumn.getDefaultValues())) break;
                    List listObj = commonFilterColumn.getDefaultValues();
                    List listLong = listObj.stream().map(o -> o == null ? 0L : Long.parseLong(o.toString())).collect(Collectors.toList());
                    qFilterList.add(new QFilter("company.id", "in", listLong));
                    break;
                }
                case "bank.finorgtype.name": {
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(finOrgTypeItems);
                    if (!EmptyUtil.isEmpty((Collection)customfilterMap.get("bank.finorgtype.id"))) {
                        commonFilterColumn.setDefaultValues(customfilterMap.get("bank.finorgtype.id"));
                    } else {
                        commonFilterColumn.setDefaultValues(new ArrayList());
                    }
                    if (EmptyUtil.isEmpty((Collection)commonFilterColumn.getDefaultValues())) break;
                    List listObj = commonFilterColumn.getDefaultValues();
                    List listLong = listObj.stream().map(o -> o == null ? 0L : Long.parseLong(o.toString())).collect(Collectors.toList());
                    qFilterList.add(new QFilter("bank.finorgtype.id", "in", listLong));
                    break;
                }
                case "bank.bank_cate.name": {
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(bankCateItems);
                    if (EmptyUtil.isEmpty((Collection)customfilterMap.get("bank.bank_cate.id"))) {
                        if (commonFilterColumn.isMustInput() && bankCateItems.size() > 0) {
                            commonFilterColumn.setDefaultValues(new Object[]{bankCateItems.get(0).getValue()});
                        } else {
                            commonFilterColumn.setDefaultValues(new Object[]{""});
                        }
                    } else {
                        commonFilterColumn.setDefaultValues(customfilterMap.get("bank.bank_cate.id"));
                    }
                    if (EmptyUtil.isEmpty(commonFilterColumn.getDefaultValues().get(0))) break;
                    List listObj = commonFilterColumn.getDefaultValues();
                    List listLong = listObj.stream().filter(EmptyUtil::isNoEmpty).map(o -> Long.parseLong(o.toString())).collect(Collectors.toList());
                    if (!EmptyUtil.isNoEmpty(listLong)) continue block14;
                    String filterBank = this.isFinOrgInfo ? "bank.id" : "bank.bank_cate.id";
                    qFilterList.add(new QFilter(filterBank, "in", listLong));
                    break;
                }
                case "accountbank.bankaccountnumber": {
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(bankNumberItems);
                    if (EmptyUtil.isEmpty((Collection)customfilterMap.get("accountbank.id"))) {
                        if (commonFilterColumn.isMustInput() && bankNumberItems.size() > 0) {
                            commonFilterColumn.setDefaultValues(new Object[]{bankNumberItems.get(0).getValue()});
                        } else {
                            commonFilterColumn.setDefaultValues(new Object[]{""});
                        }
                    } else {
                        commonFilterColumn.setDefaultValues(customfilterMap.get("accountbank.id"));
                    }
                    if (EmptyUtil.isEmpty(commonFilterColumn.getDefaultValues().get(0))) break;
                    List listObj = commonFilterColumn.getDefaultValues();
                    List listLong = listObj.stream().map(o -> o == null ? 0L : Long.parseLong(o.toString())).collect(Collectors.toList());
                    qFilterList.add(new QFilter("accountbank.id", "in", listLong));
                    break;
                }
                case "bizdate": {
                    commonFilterColumn.setDefaultValues(customfilterMap.get("bizdate"));
                    break;
                }
            }
        }
        return qFilterList;
    }

    protected List<Long> getAllMatchAccount(List<QFilter> qFilters) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        for (QFilter qFilter : qFilters) {
            String property;
            switch (property = qFilter.getProperty()) {
                case "company.id": 
                case "bank.bank_cate.id": 
                case "bank.id": 
                case "bank.finorgtype.id": {
                    filters.add(qFilter);
                    break;
                }
                case "accountbank.id": {
                    filters.add(new QFilter("id", "in", qFilter.getValue()));
                    break;
                }
                case "accountbank.bankaccountnumber": {
                    if (!(qFilter.getValue() instanceof List)) break;
                    List valueList = (List)qFilter.getValue();
                    valueList.stream().map(t -> new QFilter("bankaccountnumber", "like", (Object)("%" + t + "%"))).reduce((p, q) -> p.or(q)).ifPresent(filters::add);
                    break;
                }
            }
        }
        ArrayList<Long> acctBankIds = new ArrayList<Long>(16);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"getAllMatchAccount", (String)"bd_accountbanks", (String)"id", (QFilter[])filters.toArray(new QFilter[0]), null);
        while (ds.hasNext()) {
            Row row = ds.next();
            acctBankIds.add(row.getLong("id"));
        }
        ds.close();
        return acctBankIds;
    }

    private void addFilterWithNest(String key, QFilter qFilter, List<QFilter> qFilterList) {
        List nests;
        if (key.equals(qFilter.getProperty())) {
            qFilterList.add(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
        }
        if (!CollectionUtils.isEmpty((Collection)(nests = qFilter.getNests(true)))) {
            for (QFilter.QFilterNest nest : nests) {
                QFilter nestFilter = nest.getFilter();
                if (!key.equals(nestFilter.getProperty())) continue;
                qFilterList.add(new QFilter(nestFilter.getProperty(), nestFilter.getCP(), nestFilter.getValue()));
            }
        }
    }
}

