/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.balance;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class SyncBalance
extends AbstractTmcBillEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
    }

    private void initF7() {
        this.fillAcctBank();
    }

    private void fillAcctBank() {
        BasedataEdit acctbankF7 = (BasedataEdit)this.getControl("accountbank");
        acctbankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("issetbankinterface", "=", (Object)"1");
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"bei_bankbalance", (String)"47150e89000000ac");
            qFilter.and("company", "in", (Object)authOrgList);
            qFilter.and("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue());
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List accountBankIds = (List)customParams.get("accountBankIds");
        if (!EmptyUtil.isEmpty((Collection)accountBankIds)) {
            DynamicObject[] load = TmcDataServiceHelper.load((Object[])accountBankIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
            DynamicObjectCollection accountbankColls = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"accountbank", (DynamicObject[])load);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"accountbank", (Object)accountbankColls);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("sync".equals(key)) {
            Date enddate;
            DynamicObjectCollection accountbanks = (DynamicObjectCollection)this.getModel().getValue("accountbank");
            List accId = accountbanks.stream().map(o -> o.get("fbasedataid_id")).collect(Collectors.toList());
            Date startdate = (Date)this.getModel().getValue("startdate");
            if (startdate.after(enddate = (Date)this.getModel().getValue("enddate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u8981\u5927\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"SyncBalance_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (enddate.after(new Date())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7cfb\u7edf\u5f53\u524d\u65e5\u671f\u3002", (String)"SyncBalance_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("close", "close");
            map.put("startdate", startdate);
            map.put("enddate", enddate);
            map.put("accId", accId);
            this.getView().returnDataToParent(map);
            args.setCancel(true);
            this.getView().close();
        }
    }
}

