/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.bankpay;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.events.BeforeClosedEvent;
import kd.tmc.bei.common.helper.AmountHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAgentPayEdit
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.handleEntryInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBusinessTypeVisible();
    }

    private void setBusinessTypeVisible() {
        String businessType = (String)this.getModel().getValue("businesstype");
        this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty((String)businessType)), new String[]{"businesstype"});
    }

    private void handleEntryInfo() {
        boolean isEncrypt = (Boolean)this.getModel().getValue("isencryption");
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entrys");
        for (DynamicObject row : entryCol) {
            String recAmountStr;
            if (isEncrypt) {
                recAmountStr = "**.**";
            } else {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                BigDecimal recAmount = row.getBigDecimal("recamount");
                int amtPrecision = 2;
                String sign = "";
                if (currency != null) {
                    amtPrecision = currency.getInt("amtprecision");
                    sign = currency.getString("sign");
                }
                String recAmountFormat = AmountHelper.getAmtFormat((BigDecimal)recAmount, (Integer)amtPrecision);
                recAmountStr = sign + recAmountFormat;
            }
            row.set("enc_recamountfake", (Object)recAmountStr);
            String bankAcctNum = row.getString("recaccountbank");
            if (isEncrypt && bankAcctNum.length() > 8) {
                String head = bankAcctNum.substring(0, 4);
                String tail = bankAcctNum.substring(bankAcctNum.length() - 4, bankAcctNum.length());
                bankAcctNum = head + "****" + tail;
            }
            row.set("enc_recaccountbank", (Object)bankAcctNum);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }
}

