/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.banktrans;

import java.util.Arrays;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.tmc.bei.common.convert.AbstractBillConverter;
import kd.tmc.bei.common.convert.BankTransUpdateStatPushConverter;
import kd.tmc.bei.common.helper.PayStateUpdateHelper;
import kd.tmc.bei.common.resource.BankPayResource;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class BankTransBillList
extends AbstractTmcBillBaseList {
    private static Log logger = LogFactory.getLog(BankTransBillList.class);

    public void initialize() {
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isshowtoolbarap = (String)formShowParameter.getCustomParam("isshowtoolbarap");
        if (null != isshowtoolbarap && isshowtoolbarap.equals("no")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"company.")) {
            args.getQFilters().addAll(Arrays.asList(this.getCompanyFilter()));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setStatus(OperationStatus.VIEW);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listcontrol = args.getListColumns();
        for (int i = 0; i < listcontrol.size(); ++i) {
            IListColumn listcolumn = (IListColumn)listcontrol.get(i);
            String key = listcolumn.getListFieldKey();
            if (!"transbillno".equals(key)) continue;
            listcolumn.setHyperlink(true);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HyperLinkClickEvent hyperEvt = args.getHyperLinkClickEvent();
        String fieldName = hyperEvt.getFieldName();
        if ("transbillno".equals(fieldName)) {
            args.setCancel(true);
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String entityName = listShowParameter.getBillFormId();
            Long id = (Long)((BillList)this.getControl("billlistap")).getFocusRowPkId();
            if (null != id && id != 0L) {
                DynamicObject bankTransBill = TmcDataServiceHelper.loadSingle((Object)id, (String)entityName);
                BillShowParameter bsp = new BillShowParameter();
                bsp.setFormId("bei_banktransupbill".equals(entityName) ? "fca_transupbill" : "fca_transdownbill");
                bsp.setPkId((Object)bankTransBill.getLong("sourcebillid"));
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bsp.setBillStatus(BillOperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)bsp);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean isSuccess;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        AbstractOperate source = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String opKey = source.getOperateKey();
        String successMessage = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"BankTransBillList_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
        boolean showSuccess = true;
        switch (opKey) {
            case "bitback": {
                successMessage = new BankPayResource().getBitbackSuccessMsg();
                ((ListView)this.getView()).refresh();
                break;
            }
            case "syncstatus": {
                successMessage = new BankPayResource().getSyncbestatusSuccessMsg();
                ((ListView)this.getView()).refresh();
                break;
            }
            case "commitbe": {
                successMessage = ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u6210\u529f\u3002", (String)"BankPayingBillList_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
                ((ListView)this.getView()).refresh();
                break;
            }
            case "repay": {
                showSuccess = false;
                break;
            }
            case "updatestatpush": {
                showSuccess = false;
                List successPkIds = operationResult.getSuccessPkIds();
                if (successPkIds.size() <= 0) break;
                BillList billList = (BillList)this.getControl("billlistap");
                String entityName = billList.getEntityId();
                PayStateUpdateHelper.showTemplateEditForm((IFormView)this.getView(), (List)successPkIds, (String)entityName, (AbstractBillConverter)new BankTransUpdateStatPushConverter(entityName));
                break;
            }
            default: {
                showSuccess = false;
            }
        }
        if (operationResult != null && (isSuccess = operationResult.isSuccess()) && showSuccess) {
            this.getView().showSuccessNotification(successMessage, Integer.valueOf(2000));
        }
    }

    private QFilter[] getCompanyFilter() {
        String appId = this.getView().getFormShowParameter().getAppId();
        Long userId = RequestContext.get().getCurrUserId();
        String entityId = ((ListView)this.getView()).getBillFormId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)entityId, (String)"47150e89000000ac");
        QFilter companyOrgFilter = new QFilter("id", "in", (Object)authOrgIds);
        return new QFilter[]{companyOrgFilter};
    }
}

