/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.crosstrantype;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.enums.CrossFieldTypeEnum;
import kd.tmc.bei.common.helper.BeiHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CrossTranTypeEdit
extends AbstractBasePlugIn {
    private static final String[] selProps = new String[]{"number", "name", "fieldtype", "issee", "isnotnull", "basedatatype", "comboxvalue", "basedatatype.number"};
    private final Pattern integerPattern = Pattern.compile("^[-\\+]?[\\d]*$");
    private final Pattern decimalPattern = Pattern.compile("^[-\\+]?\\d*[.]\\d+$");

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"defaultvalue", "virtualvalue", "mustfillconditiondesc"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.loadFieldData();
        }
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.loadNewFieldData();
        }
        this.getModel().setDataChanged(false);
    }

    private void loadNewFieldData() {
        QFilter sFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection fields = QueryServiceHelper.query((String)"bei_crosstranfield", (String)String.join((CharSequence)",", selProps), (QFilter[])new QFilter[]{sFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)fields)) {
            return;
        }
        DynamicObjectCollection entry1 = this.getModel().getEntryEntity("entry");
        ArrayList<String> crossFieldNames = new ArrayList<String>(entry1.size());
        for (Object dyObj : entry1) {
            crossFieldNames.add(dyObj.getString("fieldname"));
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("fieldname", new Object[0]).addField("defaultvalue", new Object[0]).addField("issee", new Object[0]).addField("isnotnull", new Object[0]).addField("islimitlength", new Object[0]).addField("maxlength", new Object[0]).addField("islimitvalue", new Object[0]).addField("virtualvalue", new Object[0]).addField("fieldtype", new Object[0]).addField("fieldkey", new Object[0]).addField("basedatatype", new Object[0]).addField("comboxvalue", new Object[0]);
        for (DynamicObject field : fields) {
            Boolean islimitlength = Boolean.FALSE;
            Boolean islimitvalue = Boolean.FALSE;
            String baseDataNumber = field.getString("basedatatype.number") == null ? "" : field.getString("basedatatype.number");
            String fieldName = field.getString("name");
            if (crossFieldNames.contains(fieldName)) continue;
            vs.addRow(new Object[]{field.getString("name"), "", field.getBoolean("issee"), field.getBoolean("isnotnull"), islimitlength, null, islimitvalue, "", field.getString("fieldtype"), field.getString("number"), baseDataNumber, field.getString("comboxvalue")});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entry", vs);
        model.endInit();
        this.getView().updateView("entry");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            return;
        }
        List<String> isCrossCurFields = Arrays.asList("paycurrency,paydate".split(","));
        ArrayList<String> disableProps = null;
        for (DynamicObject row : entry) {
            String fieldType = row.getString("fieldtype");
            disableProps = new ArrayList<String>();
            if (CrossFieldTypeEnum.TEXT.getValue().equals(fieldType) || CrossFieldTypeEnum.DECIMAL.getValue().equals(fieldType)) {
                disableProps.add("islimitvalue");
            } else {
                disableProps.add("islimitlength");
                if (!CrossFieldTypeEnum.COMBOX.getValue().equals(fieldType)) {
                    disableProps.add("islimitvalue");
                }
            }
            this.getView().setEnable(Boolean.FALSE, row.getInt("seq") - 1, disableProps.toArray(new String[disableProps.size()]));
            String fieldKey = row.getString("fieldkey");
            if (!isCrossCurFields.contains(fieldKey)) continue;
            this.getModel().setValue("issee", (Object)Boolean.FALSE, row.getInt("seq") - 1);
            this.getView().setEnable(Boolean.FALSE, row.getInt("seq") - 1, new String[]{"issee"});
        }
    }

    public void click(EventObject evt) {
        String btnKey = ((Control)evt.getSource()).getKey();
        if ("virtualvalue".equals(btnKey)) {
            int row = this.getModel().getEntryCurrentRowIndex("entry");
            String fieldType = (String)this.getModel().getValue("fieldtype", row);
            if (CrossFieldTypeEnum.COMBOX.getValue().equals(fieldType)) {
                FormShowParameter parameter = this.createVirtualValuetFSPara(row);
                this.getView().showForm(parameter);
            }
        } else if ("defaultvalue".equals(btnKey)) {
            int row = this.getModel().getEntryCurrentRowIndex("entry");
            String fieldType = (String)this.getModel().getValue("fieldtype", row);
            if (CrossFieldTypeEnum.COMBOX.getValue().equals(fieldType)) {
                Boolean isLimit = (Boolean)this.getModel().getValue("islimitvalue", row);
                String virtualValue = (String)this.getModel().getValue("virtualvalue", row);
                if (isLimit.booleanValue() && StringUtils.isBlank((CharSequence)virtualValue)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6709\u6548\u503c\u3002", (String)"CrossTranTypeEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter parameter = this.createComBoDefaultValuetFSPara(row, fieldType);
                this.getView().showForm(parameter);
            } else if (CrossFieldTypeEnum.F7.getValue().equals(fieldType)) {
                ListShowParameter parameter = this.createF7DefaultValuetFSPara(row, fieldType);
                this.getView().showForm((FormShowParameter)parameter);
            } else if (CrossFieldTypeEnum.BOOL.getValue().equals(fieldType)) {
                FormShowParameter parameter = this.createComBoDefaultValuetFSPara(row, fieldType);
                this.getView().showForm(parameter);
            }
        } else if ("mustfillconditiondesc".equals(btnKey)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            String json = (String)this.getModel().getValue("mustfillcondition_tag", rowIndex);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "mustfillcondition");
            BeiHelper.showConditionForm((IFormView)this.getView(), (String)"cas_paybill", (String)json, (CloseCallBack)closeCallBack);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "iscrosscurrency": {
                Boolean isCrossCurrency = (Boolean)e.getChangeSet()[0].getNewValue();
                this.isCrossCurChanged(isCrossCurrency);
                break;
            }
            case "defaultvalue": {
                String newValue = (String)e.getChangeSet()[0].getNewValue();
                int rowIdx = e.getChangeSet()[0].getRowIndex();
                String fieldType = (String)this.getModel().getValue("fieldtype", rowIdx);
                if (CrossFieldTypeEnum.F7.getValue().equals(fieldType) && StringUtils.isBlank((CharSequence)newValue)) {
                    this.getModel().setValue("defaultvalueid", null, rowIdx);
                    break;
                }
                if (!CrossFieldTypeEnum.DECIMAL.getValue().equals(fieldType) || this.isBigDecimal(newValue) || !EmptyUtil.isNoEmpty((String)newValue)) break;
                this.getModel().setValue("defaultvalue", null, rowIdx);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u503c\u3002", (String)"CrossTranTypeEdit_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String returnData;
        String actionId = closedCallBackEvent.getActionId();
        if ("virtualvalue".equals(actionId)) {
            String returnData2 = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isNotBlank((CharSequence)returnData2)) {
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
                this.getModel().setValue("virtualvalue", (Object)returnData2, entryCurrentRowIndex);
            }
        } else if ("defaultvalue".equals(actionId)) {
            String returnData3 = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isNotBlank((CharSequence)returnData3)) {
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
                this.getModel().beginInit();
                this.getModel().setValue("defaultvalue", (Object)returnData3, entryCurrentRowIndex);
                this.getModel().endInit();
                this.getView().updateView("defaultvalue", entryCurrentRowIndex);
            }
        } else if ("basedatatype".equals(actionId)) {
            ListSelectedRowCollection returnData4 = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (!EmptyUtil.isEmpty((Collection)returnData4)) {
                this.getModel().beginInit();
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
                this.getModel().setValue("defaultvalue", (Object)returnData4.get(0).getNumber(), entryCurrentRowIndex);
                this.getModel().setValue("defaultvalueid", returnData4.get(0).getPrimaryKeyValue(), entryCurrentRowIndex);
                this.getModel().endInit();
                this.getView().updateView("defaultvalue", entryCurrentRowIndex);
                this.getView().updateView("defaultvalueid", entryCurrentRowIndex);
            }
        } else if ("mustfillcondition".equals(actionId) && StringUtils.isNotBlank((CharSequence)(returnData = (String)closedCallBackEvent.getReturnData()))) {
            CRCondition condition = (CRCondition)JSON.parseObject((String)returnData, CRCondition.class);
            int row = this.getModel().getEntryCurrentRowIndex("entry");
            this.getModel().setValue("mustfillcondition_tag", (Object)returnData, row);
            String desc = condition.getExprDesc();
            if (desc.length() > 50) {
                desc = desc.substring(0, 40) + "......";
            }
            this.getModel().setValue("mustfillconditiondesc", (Object)desc, row);
        }
    }

    private void loadFieldData() {
        QFilter sFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection fields = QueryServiceHelper.query((String)"bei_crosstranfield", (String)String.join((CharSequence)",", selProps), (QFilter[])new QFilter[]{sFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)fields)) {
            return;
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("fieldname", new Object[0]).addField("defaultvalue", new Object[0]).addField("issee", new Object[0]).addField("isnotnull", new Object[0]).addField("islimitlength", new Object[0]).addField("maxlength", new Object[0]).addField("islimitvalue", new Object[0]).addField("virtualvalue", new Object[0]).addField("fieldtype", new Object[0]).addField("fieldkey", new Object[0]).addField("basedatatype", new Object[0]).addField("comboxvalue", new Object[0]);
        for (DynamicObject field : fields) {
            Boolean islimitlength = Boolean.FALSE;
            Boolean islimitvalue = Boolean.FALSE;
            String baseDataNumber = field.getString("basedatatype.number") == null ? "" : field.getString("basedatatype.number");
            vs.addRow(new Object[]{field.getString("name"), "", field.getBoolean("issee"), field.getBoolean("isnotnull"), islimitlength, null, islimitvalue, "", field.getString("fieldtype"), field.getString("number"), baseDataNumber, field.getString("comboxvalue")});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entry", vs);
        model.endInit();
        this.getView().updateView("entry");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            return;
        }
        List<String> isCrossCurFields = Arrays.asList("paycurrency,paydate".split(","));
        ArrayList<String> disableProps = null;
        for (DynamicObject row : entry) {
            String fieldType = row.getString("fieldtype");
            disableProps = new ArrayList<String>();
            if (CrossFieldTypeEnum.TEXT.getValue().equals(fieldType) || CrossFieldTypeEnum.DECIMAL.getValue().equals(fieldType)) {
                disableProps.add("islimitvalue");
            } else {
                disableProps.add("islimitlength");
                if (!CrossFieldTypeEnum.COMBOX.getValue().equals(fieldType)) {
                    disableProps.add("islimitvalue");
                }
            }
            this.getView().setEnable(Boolean.FALSE, row.getInt("seq") - 1, disableProps.toArray(new String[disableProps.size()]));
            String fieldKey = row.getString("fieldkey");
            if (!isCrossCurFields.contains(fieldKey)) continue;
            this.getModel().setValue("issee", (Object)Boolean.FALSE, row.getInt("seq") - 1);
            this.getView().setEnable(Boolean.FALSE, row.getInt("seq") - 1, new String[]{"issee"});
        }
    }

    private FormShowParameter createVirtualValuetFSPara(int row) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bei_crosstrantype_cvv");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("comboxvalue", (Object)((String)this.getModel().getValue("comboxvalue", row)));
        parameter.setCustomParam("virtualvalue", (Object)((String)this.getModel().getValue("virtualvalue", row)));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "virtualvalue"));
        return parameter;
    }

    private FormShowParameter createComBoDefaultValuetFSPara(int row, String fieldType) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bei_crosstrantype_cdv");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        Boolean isLimitValue = Boolean.FALSE;
        String virtualValue = "";
        String comboxValue = "";
        if (CrossFieldTypeEnum.BOOL.getValue().equals(fieldType)) {
            comboxValue = ResManager.loadKDString((String)"true:\u662f,false:\u5426", (String)"CrossTranTypeEdit_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
        } else {
            comboxValue = (String)this.getModel().getValue("comboxvalue", row);
            isLimitValue = (Boolean)this.getModel().getValue("islimitvalue", row);
            virtualValue = (String)this.getModel().getValue("virtualvalue", row);
        }
        parameter.setCustomParam("comboxvalue", (Object)comboxValue);
        parameter.setCustomParam("virtualvalue", (Object)virtualValue);
        parameter.setCustomParam("islimitvalue", (Object)isLimitValue);
        parameter.setCustomParam("defaultvalue", (Object)((String)this.getModel().getValue("defaultvalue", row)));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "defaultvalue"));
        return parameter;
    }

    private ListShowParameter createF7DefaultValuetFSPara(int row, String fieldType) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId((String)this.getModel().getValue("basedatatype", row));
        parameter.setFormId("bos_listf7");
        parameter.setMultiSelect(false);
        parameter.setSelectedRow(this.getModel().getValue("defaultvalueid", row));
        parameter.setLookUp(true);
        StyleCss css = new StyleCss();
        css.setWidth("1068");
        css.setHeight("648");
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "basedatatype"));
        return parameter;
    }

    private void isCrossCurChanged(Boolean isCrossCurrency) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            return;
        }
        List<String> isCrossCurFields = Arrays.asList("paycurrency,paydate".split(","));
        for (DynamicObject row : entry) {
            String fieldKey = row.getString("fieldkey");
            if (!isCrossCurFields.contains(fieldKey)) continue;
            this.getModel().setValue("issee", (Object)isCrossCurrency, row.getInt("seq") - 1);
        }
    }

    private boolean isBigDecimal(String str) {
        return this.isInteger(str) || this.isDouble(str);
    }

    private boolean isInteger(String str) {
        if (null == str || "".equals(str)) {
            return false;
        }
        return this.integerPattern.matcher(str).matches();
    }

    private boolean isDouble(String str) {
        if (null == str || "".equals(str)) {
            return false;
        }
        return this.decimalPattern.matcher(str).matches();
    }
}

