/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.business.helper.BalanceCheckErrorHelper;
import kd.tmc.bei.common.helper.OrgHelper;
import kd.tmc.bei.common.property.BankOnLineUpdateInfo;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.bei.formplugin.balance.BalanceCheckViewList;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CheckDetailCorrectPlugin
extends BalanceCheckViewList
implements ItemClickListener {
    private static final Log logger = LogFactory.getLog(CheckDetailCorrectPlugin.class);

    private Set<BankOnLineUpdateInfo> getSelectedInfos() {
        IDataModel model = this.getModel();
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int[] rows = entry.getSelectRows();
        if (rows == null || rows.length == 0) {
            return null;
        }
        HashSet<Date> dateSet = new HashSet<Date>(10);
        for (int index : rows) {
            Date bizDate = (Date)model.getValue("bizdate", index);
            dateSet.add(bizDate);
        }
        Date startdate = dateSet.stream().min(Comparator.comparing(s -> s)).orElse(null);
        Date enddate = dateSet.stream().max(Comparator.comparing(s -> s)).orElse(null);
        HashSet<BankOnLineUpdateInfo> filters = new HashSet<BankOnLineUpdateInfo>(rows.length);
        for (int index : rows) {
            Long orgId = (Long)model.getValue("org_id", index);
            Long accountbankId = (Long)model.getValue("accountbank_id", index);
            Long bankId = (Long)model.getValue("bank_id", index);
            Long currencyId = (Long)model.getValue("currency_id", index);
            BigDecimal lstbalance = (BigDecimal)model.getValue("lstbalance", index);
            BigDecimal amount = (BigDecimal)model.getValue("amount", index);
            BigDecimal balance = (BigDecimal)model.getValue("balance", index);
            BankOnLineUpdateInfo bankOnLineUpdateInfo = new BankOnLineUpdateInfo(orgId, bankId, accountbankId, currencyId, lstbalance, amount, balance, startdate, enddate);
            bankOnLineUpdateInfo.setAccountbankId(accountbankId);
            filters.add(bankOnLineUpdateInfo);
        }
        return filters;
    }

    private void showTransDetailQueryFrm() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("bei_betransdetail_imp");
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getPageId();
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void modifyDataClick() {
        List<Long> idList = this.getSelectedIdList();
        if (null == idList || idList.size() == 0) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bei_modifydata");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Set<BankOnLineUpdateInfo> selectedInfos = this.getSelectedInfos();
        if (selectedInfos == null) {
            selectedInfos = new HashSet<BankOnLineUpdateInfo>();
        }
        ArrayList<BankOnLineUpdateInfo> selectedInfoList = new ArrayList<BankOnLineUpdateInfo>(selectedInfos);
        showParameter.setCustomParam("selectedInfos", (Object)SerializationUtils.toJsonString(selectedInfoList));
        this.getView().showForm(showParameter);
    }

    private void balanceOnlineQuery(FormOperate operate, BeforeDoOperationEventArgs args) {
        List<Long> idList = this.getSelectedIdList();
        if (null == idList || idList.size() == 0) {
            args.setCancel(true);
            return;
        }
        if (idList.size() > 5) {
            this.getView().showTipNotification(new BeiBizResource().getMaxSelectColInfoMsg());
            args.setCancel(true);
            return;
        }
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int[] rows = entry.getSelectRows();
        StringBuilder noSetBankInterfaceBankNo = new StringBuilder();
        for (int i : rows) {
            DynamicObject accountbank = (DynamicObject)this.getModel().getValue("accountbank", i);
            boolean isSetBankInterface = accountbank.getBoolean("issetbankinterface");
            if (isSetBankInterface) continue;
            String bankaccountnumber = accountbank.getString("bankaccountnumber");
            noSetBankInterfaceBankNo.append(bankaccountnumber).append(',');
        }
        if (noSetBankInterfaceBankNo.length() > 0) {
            String no = noSetBankInterfaceBankNo.substring(0, noSetBankInterfaceBankNo.length() - 1);
            this.getView().showTipNotification(String.format(new BeiBizResource().getNotSetBankintErface(), no));
            args.setCancel(true);
            return;
        }
        ArrayList<Integer> selected = new ArrayList<Integer>(rows.length);
        for (int index : rows) {
            selected.add(index);
            operate.getOption().setVariableValue("selected", SerializationUtils.toJsonString((Object)selected.toArray(new Integer[0])));
            operate.getOption().setVariableValue("query", "amount");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "balanceonlinequery": {
                this.balanceOnlineQuery(operate, args);
                break;
            }
            case "refresh": {
                this.fillPageData();
                break;
            }
            case "modifybalance": {
                this.modifyDataClick();
                break;
            }
            case "importdetail": {
                this.showTransDetailQueryFrm();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"balanceonlinequery") && args.getOperationResult().isSuccess()) {
            this.fillPageData();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f\u3002", (String)"CheckDetailCorrectPlugin_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"transdetail")) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
            ListShowParameter showParameter = new ListShowParameter();
            IDataModel model = this.getModel();
            DynamicObject row = model.getEntryRowEntity("entryentity", model.getEntryCurrentRowIndex("entryentity"));
            Long company = row.getLong("org.id");
            Long accountbank = row.getLong("accountbank.id");
            Long currency = row.getLong("currency.id");
            Date bizdate = row.getDate("bizdate");
            int count = row.getInt("count");
            if (EmptyUtil.isNoEmpty((Long)company)) {
                showParameter.setCustomParam("company.id", (Object)company.toString());
            }
            if (EmptyUtil.isNoEmpty((Long)currency)) {
                qFilters.add(new QFilter("currency.id", "=", (Object)currency));
            }
            if (EmptyUtil.isNoEmpty((Long)accountbank)) {
                showParameter.setCustomParam("accountbank.id", (Object)accountbank.toString());
            }
            if (count == 0) {
                this.getView().showTipNotification(new BeiBizResource().getNoDetails());
            } else {
                if (Objects.nonNull(bizdate)) {
                    showParameter.setCustomParam("bizdate", (Object)DateUtils.formatString((Date)bizdate, (String)"yyyy-MM-dd"));
                }
                this.showTemplateEditForm(showParameter, qFilters);
            }
        }
    }

    private void showTemplateEditForm(ListShowParameter showParameter, List<QFilter> qFilters) {
        showParameter.setBillFormId("bei_transdetail");
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        List qFiltersCol = showParameter.getListFilterParameter().getQFilters();
        qFiltersCol.addAll(qFilters);
        showParameter.getPageId();
        showParameter.setCustomParam("source", (Object)"bei_checkdetailcorrect");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected List<Long> getSelectedIdList() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int[] rows = entry.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CheckDetailCorrectPlugin_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return null;
        }
        ArrayList<Long> idList = new ArrayList<Long>(rows.length);
        for (int index : rows) {
            idList.add((Long)this.getModel().getValue("id", index));
        }
        return idList;
    }

    public void fillPageData() {
        Date startDate;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List<QFilter> qFilters = this.getQFilterFromPagCache();
        this.checkAddOrg(qFilters);
        List<Long> allMatchAccount = this.getAllMatchAccount(qFilters);
        List<QFilter> accountBankFilter = Collections.singletonList(new QFilter("id", "in", allMatchAccount));
        Map acctMap = TmcDataServiceHelper.loadFromCache((String)"am_accountbank", (String)"id,name,company,bankaccountnumber,currency", (QFilter[])new QFilter("id", "in", allMatchAccount).toArray());
        Map acctBank_predictDate = AccountBankHelper.getAcctBankWithPredictDate(acctMap.values(), (String)BankFuncEnum.QUERY.getValue());
        Date endDate = startDate = DateUtils.getDataFormat((Date)new Date(), (boolean)true);
        for (QFilter qFilter : qFilters) {
            logger.info("comm filter: " + qFilter.toString());
            String property = qFilter.getProperty();
            if (!"bizdate".equals(property)) continue;
            Date tmp = (Date)qFilter.getValue();
            if (">=".equals(qFilter.getCP())) {
                startDate = tmp;
                continue;
            }
            if ("<".equals(qFilter.getCP())) {
                endDate = DateUtils.getLastDay((Date)tmp, (int)1);
                continue;
            }
            if (!"<=".equals(qFilter.getCP())) continue;
            endDate = tmp;
        }
        Date today = DateUtils.getDataFormat((Date)new Date(), (boolean)true);
        endDate = endDate.after(today) ? today : endDate;
        ArrayList allBalanceRecord = new ArrayList(16);
        while (startDate.compareTo(endDate) <= 0) {
            ArrayList<QFilter> dateFilter = new ArrayList<QFilter>(10);
            dateFilter.add(new QFilter("accountbank.id", "in", allMatchAccount));
            dateFilter.add(new QFilter("bizdate", "=", (Object)startDate));
            allBalanceRecord.addAll(BalanceCheckErrorHelper.getAllBalanceRecord((Date)startDate, (QFilter)this.andFilter(accountBankFilter), (QFilter)this.andFilter(dateFilter), (Map)acctMap, (Map)acctBank_predictDate));
            startDate = DateUtils.getNextDay((Date)startDate, (int)1);
        }
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        vs.addField("org", new Object[0]);
        vs.addField("bank", new Object[0]);
        vs.addField("accountbank", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("bizdate", new Object[0]);
        vs.addField("count", new Object[0]);
        vs.addField("lstbalance", new Object[0]);
        vs.addField("amount", new Object[0]);
        vs.addField("debittotal", new Object[0]);
        vs.addField("credittotal", new Object[0]);
        vs.addField("balance", new Object[0]);
        vs.addField("result", new Object[0]);
        vs.addField("resulttype", new Object[0]);
        vs.addField("datasource", new Object[0]);
        vs.addField("detailupdatetime", new Object[0]);
        vs.addField("balanceupdatetime", new Object[0]);
        vs.addField("lstbalanceupdatetime", new Object[0]);
        vs.addField("lstdatasource", new Object[0]);
        vs.addField("resultinfo", new Object[0]);
        for (Map data : allBalanceRecord) {
            vs.addRow(new Object[]{null, data.get("company"), data.get("bank"), data.get("accountbank"), data.get("currency"), data.get("bizdate"), data.get("count"), data.get("lstbalance"), data.get("amount"), data.get("debittotal"), data.get("credittotal"), data.get("balance"), data.get("checkresult"), null, data.get("datasource"), data.get("detailtime"), data.get("balancetime"), data.get("lstbalancetime"), data.get("lstdatasource"), data.get("checkresultdesc")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private QFilter andFilter(List<QFilter> filters) {
        QFilter first = filters.get(0).copy();
        for (int i = 1; i < filters.size(); ++i) {
            first.and(filters.get(i).copy());
        }
        return first;
    }

    private void checkAddOrg(List<QFilter> qFilters) {
        QFilter filter;
        boolean hasOrg = qFilters.stream().anyMatch(t -> "company.id".equals(t.getProperty()));
        if (!hasOrg && (filter = OrgHelper.getQFilterAuthorizedOrgId((Long)RequestContext.get().getCurrUserId(), (String)"bei", (String)"bei_bankbalance", (String)"47150e89000000ac", (String)"company.id")) != null) {
            qFilters.add(filter);
        }
    }

    protected List<QFilter> getQFilterFromPagCache() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String qfiltersStr = this.getPageCache().get("qfilters");
        if (EmptyUtil.isEmpty((String)qfiltersStr)) {
            return null;
        }
        List fromJsonStringToList = SerializationUtils.fromJsonStringToList((String)qfiltersStr, String.class);
        for (String qfilterStr : fromJsonStringToList) {
            QFilter qfilter = QFilter.fromSerializedString((String)qfilterStr);
            if (qfilter.getValue() instanceof List) {
                if (((ArrayList)qfilter.getValue()).size() <= 0) continue;
                filters.add(qfilter);
                continue;
            }
            if (qfilter.getValue() instanceof Date) {
                filters.add(qfilter);
                continue;
            }
            if (!(qfilter.getValue() instanceof String) || ((String)qfilter.getValue()).length() <= 1) continue;
            filters.add(qfilter);
        }
        return filters;
    }
}

