/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.enums.DetailCorrectTypeEnum;
import kd.tmc.bei.common.property.BankOnLineUpdateInfo;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;

public class CheckDetailModifyDataPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_first"});
        this.addClickListeners(new String[]{"btn_last"});
        this.addClickListeners(new String[]{"btn_next"});
        this.addClickListeners(new String[]{"btn_end"});
        this.addClickListeners(new String[]{"btn_onlinecheck"});
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener(evt -> {
            if (StringUtils.equals((CharSequence)"operationcolumn", (CharSequence)evt.getFieldName())) {
                int rowIndex = evt.getRowIndex();
                Long id = (Long)this.getModel().getValue("id", rowIndex);
                ArrayList<Long> idList = new ArrayList<Long>();
                idList.add(id);
                this.showOnLineQueryFrm(idList);
            }
        });
    }

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadBankInfoToEntry();
        this.setBankInfoCard(0);
    }

    private void setBankInfoCard(int index) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("bankinfoentryentity");
        if (rowCount < 1) {
            return;
        }
        if (rowCount < 2) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btngroupflex"});
        }
        this.getPageCache().put("cardTotal", rowCount + "");
        this.getPageCache().put("cardNum", index + "");
        model.setValue("org", ((DynamicObject)model.getValue("org2", index)).getPkValue());
        DynamicObject accountBank = (DynamicObject)model.getValue("accountbank2", index);
        model.setValue("cardaccountbank", accountBank.getPkValue());
        model.setValue("bank", accountBank.getDynamicObject("bank").getPkValue());
        model.setValue("imageap", (Object)TmcAttachmentHelper.getRealPath((String)((DynamicObject)model.getValue("bank2", index)).getString("logo")));
        model.setValue("cardcurrency", model.getValue("currency2", index));
        model.setValue("currentbalance", (Object)this.getCurrentBalance());
        model.setValue("lstbalance", model.getValue("lstbalance2", index));
        model.setValue("amount", model.getValue("amount2", index));
        DateRangeEdit dateEdit = (DateRangeEdit)this.getControl("dateranges");
        model.setValue(dateEdit.getStartDateFieldKey(), model.getValue("startdate", index));
        model.setValue(dateEdit.getEndDateFieldKey(), model.getValue("enddate", index));
        this.initEntity();
    }

    private BigDecimal getCurrentBalance() {
        BigDecimal amount = BigDecimal.ZERO;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        Long orgId = (Long)org.getPkValue();
        DynamicObject accountbank = (DynamicObject)model.getValue("cardaccountbank");
        Long accountbankId = (Long)accountbank.getPkValue();
        DynamicObject bank = (DynamicObject)model.getValue("bank");
        Long bankId = (Long)bank.getPkValue();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountbank.bank.id", "=", (Object)bankId));
        filters.add(new QFilter("company.id", "=", (Object)orgId));
        filters.add(new QFilter("accountbank.id", "=", (Object)accountbankId));
        if (null != model.getValue("cardcurrency")) {
            DynamicObject currency = (DynamicObject)model.getValue("cardcurrency");
            Long currencyId = (Long)currency.getPkValue();
            filters.add(new QFilter("currency.id", "=", (Object)currencyId));
            String balanceSelectField = "amount";
            try (DataSet bankbalanceDataSet = QueryServiceHelper.queryDataSet((String)"getCurrentBalance()", (String)"bei_bankbalance", (String)balanceSelectField, (QFilter[])filters.toArray(new QFilter[0]), (String)"bizdate desc");){
                Iterator it = bankbalanceDataSet.iterator();
                if (it.hasNext()) {
                    Row row = (Row)it.next();
                    amount = row.getBigDecimal("amount");
                }
            }
        }
        return amount;
    }

    private void loadBankInfoToEntry() {
        IPageCache pageCache = this.getPageCache();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bankInfoStr = (String)formShowParameter.getCustomParam("selectedInfos");
        List selectedInfoList = SerializationUtils.fromJsonStringToList((String)bankInfoStr, BankOnLineUpdateInfo.class);
        if (selectedInfoList.size() < 1) {
            return;
        }
        if (null == pageCache.get("selectedInfos")) {
            this.getPageCache().put("selectedInfos", bankInfoStr);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("bankinfoentryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("org2", new Object[0]);
        vs.addField("accountbank2", new Object[0]);
        vs.addField("bank2", new Object[0]);
        vs.addField("currency2", new Object[0]);
        vs.addField("lstbalance2", new Object[0]);
        vs.addField("amount2", new Object[0]);
        vs.addField("modifyamount2", new Object[0]);
        vs.addField("startdate", new Object[0]);
        vs.addField("enddate", new Object[0]);
        for (BankOnLineUpdateInfo next : selectedInfoList) {
            vs.addRow(new Object[]{next.getOrgId(), next.getAccountbankId(), next.getBankId(), next.getCurrencyId(), next.getLstbalance(), next.getAmount(), next.getBalance(), next.getStartdate(), next.getEnddate()});
        }
        model.batchCreateNewEntryRow("bankinfoentryentity", vs);
        model.endInit();
        this.getView().updateView("bankinfoentryentity");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (c.getKey().equals("btn_onlinecheck")) {
            this.initEntity();
            this.setDifferBalance();
        } else if (key.equalsIgnoreCase("btn_first") || key.equalsIgnoreCase("btn_last") || key.equalsIgnoreCase("btn_next") || key.equalsIgnoreCase("btn_end")) {
            this.switchCard(c.getKey());
        }
    }

    private void setDifferBalance() {
        IDataModel model = this.getModel();
        BigDecimal modifyamount = (BigDecimal)model.getValue("modifyamount");
        if (modifyamount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u671f\u672b\u6821\u9a8c\u4f59\u989d\u4e3a0\uff0c\u8bf7\u8f93\u5165\u3002", (String)"CheckDetailModifyDataPlugin_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowCount = model.getEntryRowCount("entryentity");
        if (rowCount == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6821\u9a8c\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"CheckDetailModifyDataPlugin_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal lstbalance = (BigDecimal)model.getValue("lstbalance");
        BigDecimal amountTotal = modifyamount;
        BigDecimal debittotalTotal = BigDecimal.ZERO;
        BigDecimal credittotalTotal = BigDecimal.ZERO;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            debittotalTotal = debittotalTotal.add((BigDecimal)model.getValue("debitamount", rowIndex));
            credittotalTotal = credittotalTotal.add((BigDecimal)model.getValue("creditamount", rowIndex));
        }
        if (lstbalance.add(credittotalTotal).subtract(debittotalTotal).subtract(amountTotal).compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal subtractResult = lstbalance.add(credittotalTotal).subtract(debittotalTotal).subtract(amountTotal);
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(ResManager.loadKDString((String)"\u671f\u672b\u6821\u9a8c\u4f59\u989d\u4e0d\u6b63\u786e\uff0c\u8fd8\u5dee%s\u3002", (String)"CheckDetailModifyDataPlugin_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]), subtractResult.setScale(modifyamount.scale(), 4)));
            this.getView().showErrorNotification(sb.toString());
            return;
        }
        String result = new BeiBizResource().getIntact();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            BigDecimal amount;
            model.setValue("lstbalance", (Object)lstbalance, rowIndex);
            BigDecimal debittotal = (BigDecimal)model.getValue("debitamount", rowIndex);
            BigDecimal credittotal = (BigDecimal)model.getValue("creditamount", rowIndex);
            lstbalance = amount = lstbalance.add(credittotal).subtract(debittotal);
            model.setValue("differamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("valibalance", (Object)amount, rowIndex);
            String resulttype = DetailCorrectTypeEnum.INTACT.getValue();
            model.setValue("result", (Object)result, rowIndex);
            model.setValue("resulttype", (Object)resulttype, rowIndex);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_importdetail".equalsIgnoreCase(itemKey)) {
            this.importDetailClick();
        } else if ("bar_onlinequery".equalsIgnoreCase(itemKey)) {
            this.onlineQueryClick();
        } else if ("bar_refresh".equalsIgnoreCase(itemKey)) {
            this.refreshClick();
        }
    }

    private void refreshClick() {
        this.initEntity();
    }

    private void importDetailClick() {
        List<Long> idList = this.getSelectedIdList();
        if (null == idList || idList.size() == 0) {
            this.getView().showTipNotification(new BeiBizResource().getPleaseSelect());
            return;
        }
        this.showTransDetailQueryFrm();
    }

    private void onlineQueryClick() {
        List<Long> idList = this.getSelectedIdList();
        if (null == idList || idList.size() == 0) {
            this.getView().showTipNotification(new BeiBizResource().getPleaseSelect());
            return;
        }
        this.showOnLineQueryFrm(idList);
    }

    private List<Long> getSelectedIdList() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount == 0) {
            this.getView().showTipNotification(new BeiBizResource().getPleaseSelect());
            return null;
        }
        ArrayList<Long> idList = new ArrayList<Long>(entryRowCount);
        for (int i = 0; i < entryRowCount; ++i) {
            idList.add((Long)this.getModel().getValue("id", i));
        }
        return idList;
    }

    private void showOnLineQueryFrm(List<Long> idList) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bei_onlinequery");
        parameter.getCustomParams().put("idList", idList);
        parameter.getCustomParams().put("query", "detail");
        this.getView().showForm(parameter);
    }

    private void showTransDetailQueryFrm() {
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("bei_betransdetail_imp");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getPageId();
        this.getView().showForm((FormShowParameter)para);
    }

    private void initEntity() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        Long orgId = (Long)org.getPkValue();
        DynamicObject accountbank = (DynamicObject)model.getValue("cardaccountbank");
        Long accountbankId = (Long)accountbank.getPkValue();
        DynamicObject bank = (DynamicObject)model.getValue("bank");
        Long bankId = (Long)bank.getPkValue();
        DateRangeEdit dateEdit = (DateRangeEdit)this.getControl("dateranges");
        Date startDate = (Date)model.getValue(dateEdit.getStartDateFieldKey());
        Date endDate = (Date)model.getValue(dateEdit.getEndDateFieldKey());
        String balanceSelectField = "id,company,currency,accountbank,accountbank.bank,bizdate,lstbalance,amount,datasource,modifytime";
        String detailSelectField = "id,company,currency,accountbank,accountbank.bank,bizdate,transbalance,debitamount,creditamount,modifytime";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountbank.bank.id", "=", (Object)bankId));
        filters.add(new QFilter("company.id", "=", (Object)orgId));
        filters.add(new QFilter("accountbank.id", "=", (Object)accountbankId));
        QFilter startDateQFilter = new QFilter("bizdate", ">=", (Object)startDate);
        QFilter endDateQFilter = new QFilter("bizdate", "<=", (Object)endDate);
        QFilter dateQFilter = startDateQFilter.and(endDateQFilter);
        filters.add(dateQFilter);
        if (null != model.getValue("cardcurrency")) {
            DynamicObject currency = (DynamicObject)model.getValue("cardcurrency");
            Long currencyId = (Long)currency.getPkValue();
            filters.add(new QFilter("currency.id", "=", (Object)currencyId));
        }
        try (DataSet bankbalanceDataSet = QueryServiceHelper.queryDataSet((String)"initEntity()", (String)"bei_bankbalance", (String)balanceSelectField, (QFilter[])filters.toArray(new QFilter[0]), (String)"bizdate asc");
             DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)"initEntity()", (String)"bei_transdetail", (String)detailSelectField, (QFilter[])filters.toArray(new QFilter[0]), null);){
            DataSet detaiGroupByDataSet = detailDataSet.copy().groupBy(new String[]{"company", "accountbank", "accountbank.bank", "currency", "bizdate"}).max("modifytime").sum("debitamount").sum("creditamount").sum("transbalance").count().finish();
            DataSet balanceAnddetailDataSet = bankbalanceDataSet.join(detaiGroupByDataSet, JoinType.LEFT).on("accountbank", "accountbank").on("currency", "currency").on("bizdate", "bizdate").select(new String[]{"id", "company", "accountbank", "accountbank.bank", "currency", "lstbalance", "amount", "bizdate", "datasource", "modifytime balancemodifytime"}, new String[]{"count", "debitamount", "creditamount", "modifytime detailmodifytime"}).finish();
            Iterator it = balanceAnddetailDataSet.iterator();
            model.deleteEntryData("entryentity");
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("id", new Object[0]);
            vs.addField("bizdate", new Object[0]);
            vs.addField("detialtotal", new Object[0]);
            vs.addField("debitamount", new Object[0]);
            vs.addField("creditamount", new Object[0]);
            vs.addField("valibalance", new Object[0]);
            vs.addField("differamount", new Object[0]);
            vs.addField("detailupdatetime", new Object[0]);
            vs.addField("balanceupdatetime", new Object[0]);
            vs.addField("lstbalancere", new Object[0]);
            vs.addField("amountre", new Object[0]);
            vs.addField("result", new Object[0]);
            vs.addField("resulttype", new Object[0]);
            vs.addField("currency", new Object[0]);
            vs.addField("accountbank", new Object[0]);
            String result = "";
            String intactResult = new BeiBizResource().getIntact();
            String lostResult = new BeiBizResource().getLost();
            String missingResult = new BeiBizResource().getMissing();
            while (it.hasNext()) {
                Row row = (Row)it.next();
                BigDecimal lstbalance = row.getBigDecimal("lstbalance") == null ? BigDecimal.ZERO : row.getBigDecimal("lstbalance");
                BigDecimal amount = row.getBigDecimal("amount") == null ? BigDecimal.ZERO : row.getBigDecimal("amount");
                BigDecimal debittotal = row.getBigDecimal("debitamount") == null ? BigDecimal.ZERO : row.getBigDecimal("debitamount");
                BigDecimal credittotal = row.getBigDecimal("creditamount") == null ? BigDecimal.ZERO : row.getBigDecimal("creditamount");
                BigDecimal balance = lstbalance.add(credittotal).subtract(debittotal).subtract(amount);
                result = intactResult;
                String resulttype = DetailCorrectTypeEnum.INTACT.getValue();
                if (balance.compareTo(BigDecimal.ZERO) != 0) {
                    result = lostResult;
                    resulttype = DetailCorrectTypeEnum.LOST_LST_BALANCE.getValue();
                } else {
                    result = missingResult;
                }
                vs.addRow(new Object[]{row.get("id"), row.get("bizdate"), row.getInteger("count") == null ? Integer.valueOf(0) : row.getInteger("count"), debittotal, credittotal, amount, balance, row.get("balancemodifytime"), row.get("detailmodifytime"), lstbalance, amount, result, resulttype, row.get("currency"), row.get("accountbank")});
            }
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    private void switchCard(String controlKey) {
        int cardNo = 0;
        if (this.getPageCache().get("cardNum") != null) {
            cardNo = Integer.parseInt(this.getPageCache().get("cardNum"));
        }
        int cardTotal = Integer.parseInt(this.getPageCache().get("cardTotal"));
        if (controlKey.equals("btn_first")) {
            if (cardNo == 0) {
                return;
            }
            cardNo = 0;
        } else if (controlKey.equals("btn_last")) {
            if (cardNo == 0) {
                return;
            }
            --cardNo;
        } else if (controlKey.equals("btn_next")) {
            if (cardNo == cardTotal - 1) {
                return;
            }
            ++cardNo;
        } else if (controlKey.equals("btn_end")) {
            if (cardNo == cardTotal - 1) {
                return;
            }
            cardNo = cardTotal - 1;
        }
        this.writeCard(cardNo);
    }

    private void writeCard(int cardNo) {
        this.setBankInfoCard(cardNo);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"balanceonlinequery")) {
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            int[] rows = entry.getSelectRows();
            ArrayList<Integer> selected = new ArrayList<Integer>(rows.length);
            for (int index : rows) {
                selected.add(index);
                operate.getOption().setVariableValue("selected", SerializationUtils.toJsonString((Object)selected.toArray(new Integer[0])));
                operate.getOption().setVariableValue("query", "amount");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (StringUtils.equals((CharSequence)args.getOperateKey(), (CharSequence)"balanceonlinequery")) {
            this.initEntity();
        }
    }
}

