/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.bei.business.bean.AccountPredictDateResult;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import org.apache.commons.lang3.StringUtils;

public class SyncTransEdit
extends AbstractTmcBillEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
    }

    private void initF7() {
        this.fillAcctBank();
    }

    private void fillAcctBank() {
        BasedataEdit acctbankF7 = (BasedataEdit)this.getControl("accountbank");
        acctbankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("issetbankinterface", "=", (Object)"1");
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"bei_transdetail", (String)"47150e89000000ac");
            qFilter.and("company", "in", (Object)authOrgList);
            qFilter.and("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue());
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("sync".equals(key)) {
            Date startdate = (Date)this.getModel().getValue("startdate");
            Date enddate = (Date)this.getModel().getValue("enddate");
            long diffInMillis = enddate.getTime() - startdate.getTime();
            if (diffInMillis < 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8054\u673a\u67e5\u8be2\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\uff0c\u65f6\u95f4\u95f4\u9694\u4e0d\u80fd\u8d85\u8fc7\u4e09\u4e2a\u6708\u3002", (String)"SyncTransEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            long diff = TimeUnit.DAYS.convert(diffInMillis, TimeUnit.MILLISECONDS);
            if (diff > 90L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8054\u673a\u67e5\u8be2\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\uff0c\u65f6\u95f4\u95f4\u9694\u4e0d\u80fd\u8d85\u8fc7\u4e09\u4e2a\u6708\u3002", (String)"SyncTransEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection accountbanks = (DynamicObjectCollection)this.getModel().getValue("accountbank");
            List<DynamicObject> accountList = accountbanks.stream().map(t -> t.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            if (this.checkAllAccountPermit(startdate, enddate, accountList)) {
                args.setCancel(true);
                return;
            }
            HashMap<String, Object> Param = new HashMap<String, Object>(8);
            Param.put("accountid", accountList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
            Param.put("startdate", DateUtils.formatString((Date)startdate, (String)"yyyy-MM-dd"));
            Param.put("enddate", DateUtils.formatString((Date)enddate, (String)"yyyy-MM-dd"));
            this.startQueryTransDetailTask(Param);
            this.getView().close();
        }
    }

    private void startQueryTransDetailTask(Map<String, Object> params) {
        JobInfo jobInfo = new JobInfo();
        Date queryDate = new Date();
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2%1$s\u3002", (String)"SyncTransEdit_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]), DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd HH:mm:ss")));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setAppId(TmcAppEnum.BEI.getValue());
        jobInfo.setTaskClassname("kd.tmc.bei.business.task.transdetail.QueryTransDetailTask");
        params.put("view", this.getView().getParentView().getPageId());
        params.put("RequestContext", SerializationUtils.toJsonString((Object)RequestContext.get()));
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setTimeout(600);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        CloseCallBack closeCallBack = new CloseCallBack("kd.tmc.bei.business.task.transdetail.QueryTransDetailCallBack", "background_actionid");
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setClickClassName("kd.tmc.bei.business.task.transdetail.QueryTransDetailProgressClick");
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
    }

    private boolean checkAllAccountPermit(Date startDate, Date endDate, List<DynamicObject> accountBanks) {
        List resultList = AccountBankHelper.computerByAcctBanks((String)BankFuncEnum.QUERY.getValue(), accountBanks, (Date)startDate, (Date)endDate);
        List permitList = resultList.stream().filter(AccountPredictDateResult::isPermit).map(t -> t.getAccountBank().getString("bankaccountnumber")).collect(Collectors.toList());
        if (!EmptyUtil.isEmpty(permitList)) {
            if (accountBanks.size() == permitList.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s\u8bbe\u7f6e\u7684\u67e5\u8be2\u9884\u8ba1\u5f00\u901a\u65e5\u671f\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u4e0d\u80fd\u8054\u673a\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u3002", (String)"SyncBalance_2", (String)"tmc-bei-formplugin", (Object[])new Object[]{StringUtils.join(permitList, (String)"\u3001")}), Integer.valueOf(3000));
                return true;
            }
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s\u8bbe\u7f6e\u7684\u67e5\u8be2\u9884\u8ba1\u5f00\u901a\u65e5\u671f\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u4e0d\u80fd\u8054\u673a\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u3002", (String)"SyncBalance_2", (String)"tmc-bei-formplugin", (Object[])new Object[]{StringUtils.join(permitList, (String)"\u3001")}), Integer.valueOf(3000));
        }
        return false;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List accountBankIds = (List)customParams.get("accountBankIds");
        if (!EmptyUtil.isEmpty((Collection)accountBankIds)) {
            DynamicObject[] load = TmcDataServiceHelper.load((Object[])accountBankIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
            DynamicObjectCollection accountbankColls = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"accountbank", (DynamicObject[])load);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"accountbank", (Object)accountbankColls);
        }
    }
}

