/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.tmc.bei.common.enums.ReceredTypeEnum;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class TransDetailClaimEdit
extends AbstractTmcBillEdit {
    private static final String cancelclaim = "bar_cancelclaim";
    private static final String trackdown = "bar_trackdown";
    private static final String submitrec = "bar_submitrec";
    private static final String newentry = "bar_newentry";
    private static final String deleteentry = "bar_deleteentry";
    private static final String modifyOp = "modify";
    private static final String newentryOp = "newentry";
    private static final String deleteentryOp = "deleteentry";
    private static final String submitrecOp = "submitrec";
    private static final String cancelclaimOp = "cancelclaim";
    private static final String cancelclaimCallBackID = "cancelclaimCallBackID";

    public void beforeBindData(EventObject e) {
        String receredtype;
        super.beforeBindData(e);
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("lastmodifier"))) {
            this.getModel().setValue("lastmodifier", (Object)RequestContext.get().getUserId());
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("lastmodifytime"))) {
            this.getModel().setValue("lastmodifytime", (Object)DateUtils.getCurrentTime());
        }
        if (StringUtils.equals((CharSequence)(receredtype = this.getModel().getValue("receredtype").toString()), (CharSequence)ReceredTypeEnum.UNRECERED.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{cancelclaim, trackdown});
        } else if (StringUtils.equals((CharSequence)receredtype, (CharSequence)ReceredTypeEnum.RECERED.getValue())) {
            this.submitrec();
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        String number = CodeRuleServiceHelper.getNumber((String)"bei_transdetail_claim", (DynamicObject)this.getModel().getDataEntity(), (String)company.getPkValue().toString());
        this.getModel().setValue("number", (Object)number);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "modify": {
                this.modify();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "newentry": {
                this.newEntry();
                break;
            }
            case "deleteentry": {
                this.deleteEntry();
                break;
            }
            case "submitrec": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                this.submitrec();
                break;
            }
            case "cancelclaim": {
                this.cancelclaim();
            }
        }
    }

    private void cancelclaim() {
        this.getView().setVisible(Boolean.FALSE, new String[]{cancelclaim, trackdown});
        this.getView().setVisible(Boolean.TRUE, new String[]{submitrec, newentry, deleteentry});
        this.getView().setEnable(Boolean.TRUE, new String[]{"number", "customer", "desc", "detailinfo_entry"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)cancelclaim, (CharSequence)itemKey)) {
            this.getView().showConfirm(new BeiBizResource().getTipsCancelClaim(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(cancelclaimCallBackID, (IFormPlugin)this));
            evt.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)cancelclaimCallBackID, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation(cancelclaimOp);
        }
    }

    private void submitrec() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"number", "customer", "desc", "detailinfo_entry"});
        this.getView().setVisible(Boolean.FALSE, new String[]{submitrec, newentry, deleteentry});
        this.getView().setVisible(Boolean.TRUE, new String[]{cancelclaim});
    }

    private void deleteEntry() {
        DynamicObjectCollection detailinfo_entry = this.getModel().getDataEntity().getDynamicObjectCollection("detailinfo_entry");
        int entrySize = detailinfo_entry.size();
        BigDecimal creditamount = (BigDecimal)this.getModel().getValue("creditamount");
        if (entrySize == 1) {
            this.getModel().setValue("recamount", (Object)creditamount, 0);
        }
    }

    private void newEntry() {
        DynamicObjectCollection detailinfo_entry = this.getModel().getDataEntity().getDynamicObjectCollection("detailinfo_entry");
        int entrySize = detailinfo_entry.size();
        BigDecimal creditamount = (BigDecimal)this.getModel().getValue("creditamount");
        if (entrySize == 1) {
            this.getModel().setValue("recamount", (Object)creditamount, 0);
        } else {
            for (DynamicObject detailinfo : detailinfo_entry) {
                creditamount = creditamount.subtract(detailinfo.getBigDecimal("recamount"));
            }
            if (creditamount.compareTo(BigDecimal.ZERO) > 0) {
                this.getModel().setValue("recamount", (Object)creditamount, entrySize - 1);
            }
        }
    }

    private void modify() {
        String receredtype = (String)this.getModel().getValue("receredtype");
        if (StringUtils.equals((CharSequence)receredtype, (CharSequence)ReceredTypeEnum.RECERED.getValue())) {
            this.getView().showErrorNotification(new BeiBizResource().getTipsClaimCheck());
        }
    }
}

