/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailFileDetailEdit
extends AbstractFormPlugin
implements BeforeBindDataListener {
    private String BILL_LIST_KEY = "billlistap";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(this.BILL_LIST_KEY);
        billList.addBeforeBindDataListener((BeforeBindDataListener)this);
    }

    public void beforeBindData(EventObject e) {
        FormView view;
        String file;
        super.beforeBindData(e);
        Object source = e.getSource();
        if (source instanceof FormView && EmptyUtil.isNoEmpty((String)(file = (String)(view = (FormView)source).getFormShowParameter().getCustomParam("file")))) {
            FilterParameter filterParameter = new FilterParameter();
            QFilter qFilter = new QFilter("requestid", "=", (Object)file);
            filterParameter.setFilter(qFilter);
            BillList grid = (BillList)this.getControl(this.BILL_LIST_KEY);
            grid.setFilterParameter(filterParameter);
        }
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        BillList grid = (BillList)this.getControl(this.BILL_LIST_KEY);
        grid.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                if (EmptyUtil.isEmpty((DynamicObjectCollection)collection)) {
                    return collection;
                }
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(collection.size());
                DynamicObject pre = null;
                BigDecimal creditAmount = BigDecimal.ZERO;
                BigDecimal debitAmount = BigDecimal.ZERO;
                ArrayList<Integer> subList = new ArrayList<Integer>(collection.size());
                for (DynamicObject cur : collection) {
                    if (null == pre || pre.getLong("id") == cur.getLong("id")) {
                        pre = cur;
                        creditAmount = creditAmount.add(pre.getBigDecimal("entryentity.creditamount"));
                        debitAmount = debitAmount.add(pre.getBigDecimal("entryentity.debitamount"));
                    } else {
                        list.add(this.makeSubSumNode(pre, creditAmount, debitAmount));
                        subList.add(list.size() - 1);
                        pre = cur;
                        creditAmount = pre.getBigDecimal("entryentity.creditamount");
                        debitAmount = pre.getBigDecimal("entryentity.debitamount");
                    }
                    cur.set("entryentity.subsum", (Object)cur.getDynamicObject("entryentity.currency").getString("name"));
                    list.add(cur);
                }
                if (null != pre) {
                    list.add(this.makeSubSumNode(pre, creditAmount, debitAmount));
                    subList.add(list.size() - 1);
                }
                TransDetailFileDetailEdit.this.getPageCache().put("ca_f", SerializationUtils.toJsonString(subList));
                return new DynamicObjectCollection(collection.getDynamicObjectType(), collection.getParent(), list);
            }

            private DynamicObject makeSubSumNode(DynamicObject pre, BigDecimal creditAmount, BigDecimal debitAmount) {
                String currency = "entryentity.currency";
                DynamicObject sub = new DynamicObject(pre.getDynamicObjectType(), pre.getPkValue());
                sub.set("accountbank", pre.get("accountbank"));
                sub.set(currency, pre.get(currency));
                sub.set("entryentity.creditamount", (Object)creditAmount);
                sub.set("entryentity.debitamount", (Object)debitAmount);
                sub.set("entryentity.subsum", (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"TransDetailFileDetailEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                return sub;
            }
        }));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = this.getPageCache().get("ca_f");
        if (EmptyUtil.isNotBlank((CharSequence)json)) {
            List arr = SerializationUtils.fromJsonStringToList((String)json, Integer.class);
            BillList grid = (BillList)this.getControl(this.BILL_LIST_KEY);
            grid.setCellStyle(this.cellStyles(arr));
        }
    }

    private List<CellStyle> cellStyles(List<Integer> rows) {
        return Stream.of("subsum", "bizdate", "description", "creditamount", "debitamount", "transbalance").flatMap(t -> rows.stream().map(w -> this.ofStyle((String)t, (int)w))).collect(Collectors.toList());
    }

    private CellStyle ofStyle(String key, int row) {
        CellStyle cs = new CellStyle();
        cs.setBackColor("#ffffaa");
        cs.setFieldKey(key);
        cs.setRow(row);
        return cs;
    }
}

