/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.print.NotePrintService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class TransDetailFileLogList
extends AbstractTmcBillBaseList {
    private static final Log logger = LogFactory.getLog(TransDetailFileLogList.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("viewrecfile".equals(operateKey)) {
            this.showDetailPdfForm();
        }
    }

    private void showDetailPdfForm() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow selectedRow = list.getCurrentSelectedRowInfo();
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bei_transdetail_file_log", (String)"fileurl", (QFilter[])new QFilter("id", "=", selectedRow.getPrimaryKeyValue()).toArray());
        String sourcePdf = obj.getString("fileurl");
        if (EmptyUtil.isBlank((CharSequence)sourcePdf)) {
            logger.info("source pdf is empty");
            return;
        }
        String pdfUrl = this.getPdfUrl(sourcePdf);
        if (EmptyUtil.isBlank((CharSequence)pdfUrl)) {
            logger.info("can`t find pdf content");
            return;
        }
        FormShowParameter parm = new FormShowParameter();
        parm.setFormId("bos_printpreview");
        parm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parm.setCustomParam("src", (Object)pdfUrl);
        parm.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u6587\u4ef6", (String)"TransDetailFileLogList_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        IFormView view = this.getView();
        view.getParentView().showForm(parm);
        view.sendFormAction(view.getParentView());
    }

    private byte[] getPdfPutStream(String sourceUrl) throws IOException {
        FileService fs = FileServiceFactory.getAttachmentFileService();
        InputStream ins = fs.getInputStream(sourceUrl);
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = ins.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        ins.close();
        if (bos.toString().contains("file is not exist")) {
            return new byte[0];
        }
        return bos.toByteArray();
    }

    private String getPdfUrl(String sourcePdf) {
        try {
            byte[] cache = this.getPdfPutStream(sourcePdf);
            NotePrintService notePrintService = new NotePrintService();
            LocaleString localeString = new LocaleString("transdetail");
            return notePrintService.createPdfUrl(localeString, cache);
        }
        catch (IOException e) {
            logger.error("source pdf {} read fail: {}", (Object)sourcePdf, (Object)e.getMessage());
            return null;
        }
    }
}

