/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.tmc.bei.business.ocr.impl.OcrServiceImpl;
import kd.tmc.bei.common.bean.DealResultBean;
import kd.tmc.bei.common.bean.OcrTransDetailBean;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class TransDetailFileTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(TransDetailFileTask.class);
    private String pageId;
    private String dataJson;

    public TransDetailFileTask(String pageId, String dataJson) {
        this.pageId = pageId;
        this.dataJson = dataJson;
    }

    @Override
    public void run() {
        this.doTask();
    }

    private void doTask() {
        PageCache pageCache = new PageCache(this.pageId);
        List attachmentData = (List)JSON.parseObject((String)this.dataJson, List.class);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        FileService fs = FileServiceFactory.getAttachmentFileService();
        StringBuilder sb = new StringBuilder();
        OcrServiceImpl osi = new OcrServiceImpl();
        ArrayList<DealResultBean> results = new ArrayList<DealResultBean>(10);
        int progress = 0;
        int interval = 0;
        if (attachmentData.size() > 0) {
            interval = this.getInterval(attachmentData.size());
        }
        for (int i = 0; i < attachmentData.size(); ++i) {
            Object object = attachmentData.get(i);
            DealResultBean result = new DealResultBean();
            Map map = (Map)object;
            if (sb.length() != 0) {
                sb.delete(0, sb.length() - 1);
            }
            String name = (String)map.get("name");
            result.setFileName(name);
            try {
                InputStream ins = tempFileCache.getInputStream((String)map.get("url"));
                Throwable throwable = null;
                String lastModified = String.valueOf(map.get("lastModified"));
                sb.append("/").append("importfile").append("/").append(lastModified).append("/").append(name);
                String path = sb.toString();
                logger.info("\u6587\u4ef6path" + path);
                result.setFileURL(path);
                FileItem fi = new FileItem(path, path, ins);
                logger.info("\u6587\u4ef6pathfi" + fi);
                String upload = fs.upload(fi);
                logger.info("\u6587\u4ef6upload" + upload);
                try (InputStream insnew = fs.getInputStream(upload);){
                    OcrTransDetailBean transDetailBean = osi.getTransDetailBean(insnew, String.valueOf(i));
                    logger.info("\u6587\u4ef6" + name + "\u8bf7\u6c42id:" + transDetailBean.getRequestId());
                    result.setRequestId(transDetailBean.getRequestId());
                    this.saveReceipt(transDetailBean, result);
                }
                catch (Exception e) {
                    result.setStatus("F");
                    result.addFailureReason(ResManager.loadKDString((String)"\u672a\u6210\u529f\u89e3\u6790\uff1a%s\u3002", (String)"TransDetailFileTask_0", (String)"tmc-bei-formplugin", (Object[])new Object[]{e}));
                    logger.error((Throwable)e);
                    if (ins == null) continue;
                    if (throwable != null) {
                        try {
                            ins.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    ins.close();
                    continue;
                }
                try {
                    if ((progress += interval) >= 100) {
                        progress = 99;
                    }
                    pageCache.put("progress", String.valueOf(progress));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (ins != null) {
                        if (throwable != null) {
                            try {
                                ins.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ins.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                result.setStatus("F");
                result.setFailureReason(ResManager.loadKDString((String)"%s\u4e0a\u4f20\u5931\u8d25", (String)"TransDetailFileTask_1", (String)"tmc-bei-formplugin", (Object[])new Object[]{name}));
                logger.error((Throwable)e);
                continue;
            }
            results.add(result);
        }
        if (results.size() > 0) {
            String resultJson = JSON.toJSONString(results);
            logger.info("\u8fd4\u56dejson:" + resultJson);
            pageCache.put("resultJson", resultJson);
        }
        progress = 100;
        pageCache.put("progress", String.valueOf(progress));
    }

    private int getInterval(int count) {
        BigDecimal interval = BigDecimal.valueOf(100.0).divide(new BigDecimal(count), 2, RoundingMode.HALF_UP);
        return interval.intValue();
    }

    private void saveReceipt(OcrTransDetailBean ocrReceiptBean, DealResultBean result) {
        int errorCode = ocrReceiptBean.getErrorCode();
        if (errorCode == 0) {
            String jsonString = ocrReceiptBean.getData().toString();
            logger.info("\u8bc6\u522b\u7ed3\u679c\u6570\u636e\uff1a" + jsonString);
            Map settings = TmcDataServiceHelper.loadFromCache((String)"bei_ocrbankstate_set", (String)"name,keyword,execlasspath", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
            boolean isNotFound = true;
            for (Map.Entry entry : settings.entrySet()) {
                DynamicObject setting = (DynamicObject)entry.getValue();
                if (!jsonString.contains(setting.getString("keyword"))) continue;
                try {
                    isNotFound = false;
                    Class<?> clazz = Class.forName(setting.getString("execlasspath"));
                    Method method = clazz.getMethod("ToDeal", OcrTransDetailBean.class, DealResultBean.class);
                    Object o = clazz.newInstance();
                    method.invoke(o, ocrReceiptBean, result);
                    break;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    result.setStatus("F");
                    result.addFailureReason(ResManager.loadKDString((String)"\u8c03\u7528%s\u6267\u884c\u7c7b\u5f02\u5e38\u3002", (String)"TransDetailFileTask_2", (String)"tmc-bei-formplugin", (Object[])new Object[]{setting.getString("name")}));
                    logger.error("\u8c03\u7528" + setting.getString("name") + "\u6267\u884c\u7c7b\u5f02\u5e38:" + e);
                }
            }
            if (isNotFound) {
                result.setStatus("F");
                result.addFailureReason(ResManager.loadKDString((String)"\u672a\u786e\u5b9a\u6587\u4ef6\u7684\u94f6\u884c\u7c7b\u522b\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u6216\u4fee\u6539\u6587\u4ef6\u8bc6\u522b\u914d\u7f6e\u3002", (String)"TransDetailFileTask_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            }
        } else {
            result.setStatus("F");
            result.addFailureReason(ocrReceiptBean.getDescription());
            logger.error("json errorcode:" + errorCode);
            logger.error("json descriptinon:" + ocrReceiptBean.getDescription());
        }
        if (!"F".equals(result.getStatus())) {
            result.setStatus("S");
        } else {
            result.setPreValidate(ResManager.loadKDString((String)"\u672a\u68c0\u9a8c", (String)"LeadInCheck_5", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }
}

