/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailHyperlinkList
extends AbstractListPlugin {
    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"tblgenrecbill", "tbltransup", "tbltransdown", "tblbankwithholding", "tblrecered", "bar_thmore"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        Iterator iterator = commonFilterColumns.iterator();
        while (iterator.hasNext()) {
            CommonFilterColumn filterColumn = (CommonFilterColumn)iterator.next();
            String fieldName = filterColumn.getFieldName();
            if (fieldName.startsWith("company.") || fieldName.startsWith("org.")) {
                List defaultCompanies = (List)this.getView().getFormShowParameter().getCustomParam("company.id");
                List<Object> companyIds = this.wapToStringList(defaultCompanies);
                filterColumn.setDefaultValues(companyIds);
                continue;
            }
            if (fieldName.startsWith("accountbank.")) {
                if (!fieldName.equals("accountbank.bankaccountnumber")) continue;
                List defaultAccountBanks = (List)this.getView().getFormShowParameter().getCustomParam("accountbank.id");
                List<Object> accountBankIds = this.wapToStringList(defaultAccountBanks);
                this.setUnExistComboItems(filterColumn, accountBankIds);
                filterColumn.setDefaultValues(accountBankIds);
                continue;
            }
            if (fieldName.startsWith("bizdate")) {
                Object cusBizDate = this.getView().getFormShowParameter().getCustomParam("bizdate");
                if (cusBizDate instanceof List) {
                    filterColumn.getComboItems().clear();
                    filterColumn.setCustom(true);
                    List<Object> dateRange = this.wapToStringList((List)cusBizDate);
                    filterColumn.setDefaultValues(dateRange);
                    continue;
                }
                filterColumn.setCustom(false);
                String dateType = cusBizDate.toString();
                filterColumn.setDefaultValue(dateType);
                continue;
            }
            if (!fieldName.startsWith("bank.")) continue;
            iterator.remove();
        }
    }

    private void setUnExistComboItems(CommonFilterColumn filterColumn, List<Object> accountBankIds) {
        List comboItems = filterColumn.getComboItems();
        Set exist = comboItems.stream().filter(comboItem -> accountBankIds.contains(comboItem.getValue())).map(comboItem -> comboItem.getValue()).collect(Collectors.toSet());
        ArrayList<Object> unExist = new ArrayList<Object>(accountBankIds);
        unExist.removeAll(exist);
        if (EmptyUtil.isNoEmpty(unExist)) {
            List<ComboItem> unComboItems = this.initBankItemsList(unExist);
            comboItems.addAll(unComboItems);
            filterColumn.setComboItems(comboItems);
        }
    }

    private void removeUselessItems(CommonFilterColumn filterColumn, List<Object> accountBankIds) {
        List comboItems = filterColumn.getComboItems();
        Iterator iterator = comboItems.iterator();
        while (iterator.hasNext()) {
            ComboItem next = (ComboItem)iterator.next();
            if (accountBankIds.contains(next.getValue())) continue;
            iterator.remove();
        }
    }

    private List<Object> wapToStringList(List<Object> list) {
        ArrayList<Object> strList = new ArrayList<Object>(list.size());
        for (Object item : list) {
            strList.add(item.toString());
        }
        return strList;
    }

    protected List<ComboItem> initBankItemsList(List<Object> accountBankIds) {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ArrayList<Long> accountBankIdsLong = new ArrayList<Long>(accountBankIds.size());
        for (Object obj : accountBankIds) {
            accountBankIdsLong.add(Long.valueOf(obj.toString()));
        }
        String selectFiled = "name,id";
        QFilter qFilter = new QFilter("id", "in", (Object)accountBankIdsLong.toArray(new Long[0]));
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)selectFiled, (QFilter[])new QFilter[]{qFilter});
        if (accountBanks != null && accountBanks.length > 0) {
            for (int i = 0; i < accountBanks.length; ++i) {
                DynamicObject acct = accountBanks[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(acct.getString("name")));
                item.setValue(acct.getString("id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
        }
        return acctItems;
    }
}

