/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.business.opservice.elec.ViewReceiptService;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class TransDetailImportList
extends AbstractTmcBillBaseList {
    private static final Log logger = LogFactory.getLog(TransDetailImportList.class);
    private FilterContainerInitArgs initArgs;

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List fieldNameList;
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null && ((fieldNameList = (List)currentCommonFilter.get("FieldName")).contains("company.id") || fieldNameList.contains("bank.bank_cate.id"))) {
            this.getPageCache().put("commonFilterChangeFlag", "true");
        }
        this.filterContainerInit(this.initArgs);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.cacheQFilter(e.getQFilters());
        QFilter filter = new QFilter("datasource", "not in", (Object)new String[]{DataSourceEnum.FROMBANK.getValue(), DataSourceEnum.FROMIFM.getValue()});
        e.getQFilters().add(filter);
        QFilter qFilter = VisibleVirtualAcctHelper.notVirtualAcctIdQf();
        e.getQFilters().add(qFilter);
    }

    private void cacheQFilter(List<QFilter> qFilterList) {
        ArrayList<String> qFilterStrList = new ArrayList<String>(qFilterList.size());
        for (QFilter qFilter : qFilterList) {
            qFilterStrList.add(qFilter.toSerializedString());
        }
        this.getPageCache().put("qfilters", SerializationUtils.toJsonString(qFilterStrList));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn listFilter : listFilterColumns) {
            String fieldName;
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            switch (fieldName = commFilter.getFieldName()) {
                case "modifytime": {
                    commFilter.setDefaultValue("13");
                    commFilter.setMustInput(true);
                    break;
                }
                case "company.name": {
                    List comboItems = commFilter.getComboItems();
                    ArrayList<String> companyids = new ArrayList<String>(comboItems.size());
                    for (ComboItem comboItem : comboItems) {
                        companyids.add(comboItem.getValue());
                    }
                    this.getPageCache().put("companyids", SerializationUtils.toJsonString(companyids));
                    break;
                }
                case "accountbank.bankaccountnumber": {
                    QFilter orgUseBankAccountQFilter;
                    if (EmptyUtil.isEmpty((String)this.getPageCache().get("commonFilterChangeFlag"))) {
                        this.getPageCache().put("commonFilterChangeFlag", "true");
                    }
                    String commonFilterChangeFlag = this.getPageCache().get("commonFilterChangeFlag");
                    ArrayList<ComboItem> accountItems = null;
                    String accountItemsStr = this.getPageCache().get("accountItems");
                    if (EmptyUtil.isNoEmpty((String)accountItemsStr)) {
                        accountItems = SerializationUtils.fromJsonStringToList((String)accountItemsStr, ComboItem.class);
                    }
                    if (EmptyUtil.isNoEmpty((String)commonFilterChangeFlag) && Boolean.parseBoolean(commonFilterChangeFlag) && (orgUseBankAccountQFilter = this.getOrgUseBankAccountQFilter()) != null) {
                        String selectProperties = "id,name,number,bankaccountnumber";
                        Map accountBanks = TmcDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)selectProperties, (QFilter[])new QFilter[]{orgUseBankAccountQFilter});
                        accountItems = new ArrayList<ComboItem>(10);
                        if (accountBanks != null && accountBanks.size() > 0) {
                            for (Map.Entry entrySet : accountBanks.entrySet()) {
                                DynamicObject account = (DynamicObject)entrySet.getValue();
                                ComboItem item = new ComboItem();
                                item.setCaption(new LocaleString(account.getString("bankaccountnumber")));
                                item.setValue(account.getString("id"));
                                accountItems.add(item);
                            }
                        } else {
                            accountItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"TmcTradeFilterPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0])), ""));
                        }
                        this.getPageCache().put("accountItems", SerializationUtils.toJsonString(accountItems));
                        this.getPageCache().put("commonFilterChangeFlag", "false");
                    }
                    if (accountItems == null || accountItems.size() <= 0) break;
                    commFilter.setComboItems((List)accountItems);
                    commFilter.setDefValue(((ComboItem)accountItems.get(0)).getValue());
                    break;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("delete".equals(operateKey)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            Set pkSet = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_betransdetail_imp", (String)"id, receiptno, datasource, ismatchereceipt", (QFilter[])new QFilter[]{new QFilter("id", "in", pkSet)});
            ArrayList<String> receiptNoList = new ArrayList<String>(10);
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)details)) {
                for (DynamicObject detail : details) {
                    if (!DataSourceEnum.RECEIPTGEN.getValue().equals(detail.getString("datasource")) || !detail.getBoolean("ismatchereceipt")) continue;
                    receiptNoList.add(detail.getString("receiptno"));
                }
            }
            if (!receiptNoList.isEmpty()) {
                this.getView().getPageCache().put("deleteReceiptNo", ((Object)receiptNoList).toString());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (!EmptyUtil.isEmpty((Object)operationResult) && operationResult.isSuccess()) {
            switch (operateKey) {
                case "receipt": {
                    ArrayList<String> pkList = new ArrayList<String>(10);
                    String receiptID = args.getOperationResult().getMessage();
                    pkList.add(receiptID);
                    ViewReceiptService service = new ViewReceiptService();
                    service.openReceiptById(this.getView(), pkList.toArray());
                    break;
                }
                case "filerec": {
                    this.showRecFileForm();
                    break;
                }
                case "autoupdateamount": {
                    this.showAutoBalance();
                    break;
                }
                case "delete": {
                    Set receiptNos;
                    Object[] receipts;
                    String deleteReceiptNo = this.getView().getPageCache().get("deleteReceiptNo");
                    if (!EmptyUtil.isNoEmpty((String)deleteReceiptNo) || !EmptyUtil.isNoEmpty((Object[])(receipts = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id, receiptno, ismatch, matchtype, detailid", (QFilter[])new QFilter[]{new QFilter("receiptno", "in", receiptNos = Arrays.stream(deleteReceiptNo.substring(1, deleteReceiptNo.length() - 1).split(",")).collect(Collectors.toSet()))})))) break;
                    for (Object receipt : receipts) {
                        receipt.set("ismatch", (Object)Boolean.FALSE);
                        receipt.set("matchtype", null);
                        receipt.set("detailid", null);
                    }
                    SaveServiceHelper.update((DynamicObject[])receipts);
                    this.getView().getPageCache().remove("deleteReceiptNo");
                    break;
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        logger.info("appId = " + appId);
        if (!TmcAppEnum.CAS.getValue().equals(appId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblgenpaybill", "tblgenrecbill", "bar_genpay", "bar_genrec"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tblrecfilelog".equals(itemKey)) {
            this.showRecogFileLog();
        }
    }

    private void showRecFileForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bei_transdetail_file_impl");
        showParameter.setCustomParam("entityName", (Object)"bei_transdetail");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tblfilerec"));
        this.getView().showForm(showParameter);
    }

    private void showRecogFileLog() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (EmptyUtil.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u79bb\u7ebf\u660e\u7ec6\u6570\u636e\u3002", (String)"TransDetailImportList_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u79bb\u7ebf\u660e\u7ec6\u6570\u636e\u3002", (String)"TransDetailImportList_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject detail = QueryServiceHelper.queryOne((String)"bei_betransdetail_imp", (String)"recfile", (QFilter[])new QFilter("id", "=", selectedRows.get(0).getPrimaryKeyValue()).toArray());
        String recFile = detail.getString("recfile");
        if (EmptyUtil.isBlank((CharSequence)recFile)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6587\u4ef6\u8bc6\u522b\u5bfc\u5165\u7684\u79bb\u7ebf\u660e\u7ec6\uff0c\u65e0\u5bfc\u5165\u65e5\u5fd7\u3002", (String)"TransDetailImportList_4", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getListFilterParameter().setFilter(new QFilter("billno", "=", (Object)recFile));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId("bei_transdetail_file_log");
        showParameter.setFormId("bos_list");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showAutoBalance() {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("bei_syncautobalance");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        ControlFilters controlFilters = this.getControlFilters();
        List companyIdList = controlFilters.getFilter("company.id");
        showForm.setCustomParam("companyIdList", (Object)companyIdList);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bei_syncautobalance"));
        this.getView().showForm(showForm);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        super.closedCallBack(event);
        if ("tblfilerec".equals(event.getActionId())) {
            Map returnData2 = (Map)event.getReturnData();
            if (returnData2 != null) {
                this.showImportProcess(returnData2);
            }
        } else if ("file_process".equals(event.getActionId())) {
            if ("success".equals(event.getReturnData())) {
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"TransDetailImportList_5", (String)"tmc-bei-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002", (String)"TransDetailImportList_6", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            }
        } else if ("bei_syncautobalance".equals(event.getActionId()) && (returnData = (Map)event.getReturnData()) != null) {
            String messageStr = (String)returnData.get("message");
            List messageList = (List)SerializationUtils.deSerializeFromBase64((String)messageStr);
            if (EmptyUtil.isNoEmpty((Object)messageList)) {
                this.getView().showTipNotification(String.join((CharSequence)"\n", messageList));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u4f59\u989d\u6210\u529f\u3002", (String)"TransDetailImportList_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showImportProcess(Map<String, String> returnData) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bei_transdetail_file_proc");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("data", (Object)returnData.get("data"));
        showParameter.setCustomParam("entityName", (Object)"bei_transdetail");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "file_process"));
        this.getView().showForm(showParameter);
    }

    private QFilter getOrgUseBankAccountQFilter() {
        List selectedOrgIdList;
        IPageCache cache = this.getPageCache();
        String selectedOrgIdListStr = cache.get("selectedOrgIdList");
        if (EmptyUtil.isNotEmpty((CharSequence)selectedOrgIdListStr) && EmptyUtil.isNoEmpty((Object)(selectedOrgIdList = (List)SerializationUtils.fromJsonString((String)selectedOrgIdListStr, List.class))) && !StringUtils.equals((CharSequence)selectedOrgIdList.get(0).toString(), (CharSequence)"")) {
            List selectedBankIdList;
            QFilter qFilter = AccountBankHelper.getAccountBankFilterByOrg(selectedOrgIdList.stream().filter(EmptyUtil::isNoEmpty).map(o -> Long.parseLong(o.toString())).collect(Collectors.toList()));
            QFilter notVirtualAcctQFilter = VisibleVirtualAcctHelper.notVirtualAcctQf();
            qFilter.and(notVirtualAcctQFilter);
            String selectedBankIdListStr = cache.get("selectedBankIdList");
            if (EmptyUtil.isNoEmpty((String)selectedBankIdListStr) && EmptyUtil.isNoEmpty((Object)(selectedBankIdList = (List)SerializationUtils.fromJsonString((String)selectedBankIdListStr, List.class)))) {
                List bankIdList = selectedBankIdList.stream().filter(EmptyUtil::isNoEmpty).map(o -> Long.parseLong(o.toString())).collect(Collectors.toList());
                boolean exist = TmcDataServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("bank.id", "in", bankIdList), notVirtualAcctQFilter});
                if (exist) {
                    qFilter.and(new QFilter("bank.id", "in", bankIdList));
                } else {
                    qFilter.and(new QFilter("bank.bank_cate.id", "in", bankIdList));
                }
            }
            return qFilter;
        }
        return null;
    }
}

