/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.detail.bank;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.common.bean.DealResultBean;
import kd.tmc.bei.common.bean.OcrTransDetailBean;
import kd.tmc.bei.common.bean.TransDetailCellBean;
import kd.tmc.bei.common.bean.TransDetailDataBean;
import kd.tmc.bei.common.bean.TransDetailPageBean;
import kd.tmc.bei.common.bean.TransDetailTableBean;
import kd.tmc.bei.formplugin.detail.bank.IBankTransDetailDeal;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CITIBankTransDetailDeal
implements IBankTransDetailDeal {
    private static final Log logger = LogFactory.getLog(CITIBankTransDetailDeal.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void ToDeal(OcrTransDetailBean ocrReceiptBean, DealResultBean dealResult) {
        logger.info("\u5339\u914d\u5230\u82b1\u65d7\u94f6\u884c\uff0c\u5f00\u59cb\u89e3\u6790-------------------");
        long startTime = System.nanoTime();
        ArrayList<DynamicObject> needSaveResult = new ArrayList<DynamicObject>(10);
        DynamicObject fileResult = BusinessDataServiceHelper.newDynamicObject((String)"bei_transdetail_file_rec");
        fileResult.set("requestid", (Object)ocrReceiptBean.getRequestId());
        fileResult.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        needSaveResult.add(fileResult);
        DynamicObject transDetail = null;
        block8: for (Object data : ocrReceiptBean.getData()) {
            TransDetailDataBean transDetailBean = (TransDetailDataBean)((JSONObject)data).toJavaObject(TransDetailDataBean.class);
            List pageDatas = transDetailBean.getPageData();
            for (Object pageData : pageDatas) {
                TransDetailPageBean pageDataBean = (TransDetailPageBean)((JSONObject)pageData).toJavaObject(TransDetailPageBean.class);
                List tableDatas = pageDataBean.getTableData();
                for (Object tableData : tableDatas) {
                    TransDetailTableBean tableDataBean = (TransDetailTableBean)((JSONObject)tableData).toJavaObject(TransDetailTableBean.class);
                    List cells = tableDataBean.getCell();
                    JSONObject[][] res = new JSONObject[cells.size()][];
                    for (int i = 0; i < res.length; ++i) {
                        res[i] = ((List)cells.get(i)).toArray(new JSONObject[((List)cells.get(i)).size()]);
                    }
                    TransDetailCellBean cellBeanHead = (TransDetailCellBean)res[9][0].toJavaObject(TransDetailCellBean.class);
                    if ("AccountNumber".equals(cellBeanHead.getText().replaceAll(" ", ""))) {
                        String thisAccount = ((TransDetailCellBean)res[10][0].toJavaObject(TransDetailCellBean.class)).getText().replaceAll(" ", "");
                        DynamicObject lastAccount = fileResult.getDynamicObject("accountbank");
                        if (EmptyUtil.isNoEmpty((DynamicObject)lastAccount)) {
                            if (!thisAccount.equals(lastAccount.getString("bankaccountnumber"))) {
                                fileResult = BusinessDataServiceHelper.newDynamicObject((String)"bei_transdetail_file_rec");
                                fileResult.set("requestid", (Object)ocrReceiptBean.getRequestId());
                                fileResult.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                                this.setAccountBank(thisAccount, dealResult, fileResult);
                                needSaveResult.add(fileResult);
                            }
                        } else {
                            this.setAccountBank(thisAccount, dealResult, fileResult);
                        }
                    }
                    DynamicObject detailCurrency = null;
                    cellBeanHead = (TransDetailCellBean)res[9][2].toJavaObject(TransDetailCellBean.class);
                    if ("Currency".equals(cellBeanHead.getText().replaceAll(" ", ""))) {
                        String currencyNumber = ((TransDetailCellBean)res[10][2].toJavaObject(TransDetailCellBean.class)).getText().replaceAll(" ", "");
                        DynamicObject currency = TmcDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyNumber)});
                        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                            detailCurrency = currency;
                        } else {
                            dealResult.setStatus("F");
                            dealResult.addFailureReason(this.getNotFoundCurrencyMessage(currencyNumber));
                        }
                    }
                    block12: for (int i = 13; i < res.length && !Arrays.toString(res[i]).contains("Report Date"); ++i) {
                        boolean isDateType = false;
                        for (int j = 0; j < res[i].length; ++j) {
                            TransDetailCellBean cellBean = (TransDetailCellBean)res[i][j].toJavaObject(TransDetailCellBean.class);
                            if (!EmptyUtil.isNoEmpty((String)cellBean.getText())) continue;
                            switch (j) {
                                case 0: {
                                    if (cellBean.getText().length() != 10) break block8;
                                    SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
                                    try {
                                        transDetail = fileResult.getDynamicObjectCollection("entryentity").addNew();
                                        Date transDate = sdf.parse(cellBean.getText());
                                        transDetail.set("bizdate", (Object)transDate);
                                        if (EmptyUtil.isNoEmpty((DynamicObject)detailCurrency)) {
                                            transDetail.set("currency", (Object)detailCurrency);
                                        }
                                        isDateType = true;
                                    }
                                    catch (ParseException e) {
                                        isDateType = false;
                                    }
                                    break;
                                }
                                case 1: {
                                    if (cellBean.getText().contains("CLOSING BALANCE")) {
                                        fileResult.getDynamicObjectCollection("entryentity").remove(fileResult.getDynamicObjectCollection("entryentity").size() - 1);
                                        transDetail = (DynamicObject)fileResult.getDynamicObjectCollection("entryentity").get(fileResult.getDynamicObjectCollection("entryentity").size() - 1);
                                        TransDetailCellBean cellBean1 = (TransDetailCellBean)res[i][5].toJavaObject(TransDetailCellBean.class);
                                        if (!EmptyUtil.isNoEmpty((String)cellBean1.getText())) break;
                                        transDetail.set("transbalance", (Object)new BigDecimal(cellBean1.getText().replaceAll(" ", "")));
                                        continue block12;
                                    }
                                    if (transDetail == null) break;
                                    if (isDateType) {
                                        transDetail.set("description", (Object)cellBean.getText());
                                        break;
                                    }
                                    String description = transDetail.getString("description") + " " + cellBean.getText();
                                    if (description.length() > 255) {
                                        description = description.substring(0, 250) + "...";
                                    }
                                    transDetail.set("description", (Object)description);
                                    break;
                                }
                                case 3: {
                                    if (transDetail == null) break;
                                    transDetail.set("debitamount", (Object)new BigDecimal(cellBean.getText().replaceAll(" ", "")));
                                    break;
                                }
                                case 4: {
                                    if (transDetail == null) break;
                                    transDetail.set("creditamount", (Object)new BigDecimal(cellBean.getText().replaceAll(" ", "")));
                                }
                            }
                        }
                    }
                }
            }
        }
        this.LeadInCheck(needSaveResult, dealResult);
        SaveServiceHelper.save((DynamicObject[])needSaveResult.toArray(new DynamicObject[0]));
        long time = (System.nanoTime() - startTime) / 1000L / 1000L;
        logger.info(">>>\u8bc6\u522b\u7ed3\u679c\u89e3\u6790\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + time + "ms");
    }

    private void LeadInCheck(List<DynamicObject> fileResults, DealResultBean dealResult) {
        if ("F".equals(dealResult.getStatus())) {
            dealResult.setPreValidate(ResManager.loadKDString((String)"\u672a\u68c0\u9a8c", (String)"LeadInCheck_5", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean totalCheckPass = true;
        for (DynamicObject fileResult : fileResults) {
            String prevalidate = "";
            DynamicObjectCollection transDetails = fileResult.getDynamicObjectCollection("entryentity");
            QFilter qFilter = new QFilter("accountbank", "=", fileResult.getDynamicObject("accountbank").getPkValue());
            for (DynamicObject transDetail : transDetails) {
                qFilter.and("bizdate", "=", (Object)transDetail.getDate("bizdate"));
                qFilter.and("currency", "=", transDetail.getDynamicObject("currency").getPkValue());
                qFilter.and("transbalance", "=", (Object)transDetail.getBigDecimal("transbalance"));
                qFilter.and("debitamount", "=", (Object)transDetail.getBigDecimal("debitamount"));
                qFilter.and("creditamount", "=", (Object)transDetail.getBigDecimal("creditamount"));
                qFilter.and("description", "=", (Object)transDetail.getString("description"));
                if (!QueryServiceHelper.exists((String)"bei_transdetail", (QFilter[])qFilter.toArray())) continue;
                prevalidate = ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5b58\u5728\u91cd\u590d\u6570\u636e\u3002", (String)"LeadInCheck_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
                totalCheckPass = false;
                break;
            }
            if (EmptyUtil.isEmpty((String)prevalidate)) {
                prevalidate = ResManager.loadKDString((String)"\u6821\u9a8c\u901a\u8fc7", (String)"LeadInCheck_4", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
            }
            fileResult.set("accountvalidate", (Object)prevalidate);
        }
        if (totalCheckPass) {
            dealResult.setPreValidate(ResManager.loadKDString((String)"\u6821\u9a8c\u901a\u8fc7", (String)"LeadInCheck_4", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        } else {
            dealResult.setPreValidate(ResManager.loadKDString((String)"\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5b58\u5728\u91cd\u590d\u6570\u636e\u3002", (String)"LeadInCheck_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }

    private void setAccountBank(String thisAccount, DealResultBean dealResult, DynamicObject fileResult) {
        DynamicObject accountBank = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)thisAccount)});
        if (EmptyUtil.isNoEmpty((DynamicObject)accountBank)) {
            fileResult.set("accountbank", (Object)accountBank);
        } else {
            dealResult.setStatus("F");
            dealResult.addFailureReason(this.getNotFoundAccountMessage(thisAccount));
        }
    }

    private String getNotFoundAccountMessage(String accountNumber) {
        return ResManager.loadKDString((String)"\u82b1\u65d7\u94f6\u884c\u8d26\u53f7\uff1a%s\u5728\u7cfb\u7edf\u4e2d\u672a\u627e\u5230\u3002", (String)"CITIBankTransDetailDeal_0", (String)"tmc-bei-formplugin", (Object[])new Object[]{accountNumber});
    }

    private String getNotFoundCurrencyMessage(String currency) {
        return ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u8d27\u5e01\u4ee3\u7801\u4e3a\u201c%s\u201d\u7684\u5e01\u79cd\u3002", (String)"OCBCBankTransDetailDeal_1", (String)"tmc-bei-formplugin", (Object[])new Object[]{currency});
    }
}

