/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.common.bean.DealResultBean;
import kd.tmc.bei.common.constants.ReceiptRecongnizeDetail;
import kd.tmc.bei.common.enums.LendingDirectionEnum;
import kd.tmc.bei.common.helper.CodeRuleHelper;
import kd.tmc.bei.formplugin.elec.ElecReceiptImportTask;
import kd.tmc.fbp.common.helper.DateFormatUtil;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElecImageUploadEdit
extends AbstractBillPlugIn
implements UploadListener,
ProgresssListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(ElecImageUploadEdit.class);
    private static final String BTN_SCAN = "btn_scan";
    private static final String BTN_IMPORT = "btn_import";
    private static final String BTN_CHECK = "btn_check";
    private static final String BTN_NEXT = "btn_next";
    private static final String BTN_BACK = "btn_back";
    private static final String BTN_EDIT = "editbtn";
    private static final String BTN_BATCH_EDIT = "batcheditap";
    private static final String BTN_LOG_EXPORT = "btn_exportlog";
    public static final String IMPORTSTATUS = "importstatus";
    public static final String IMPORTFAILREASON = "importreason";
    public static final String STEPSTATUS = "stepstatus";
    public static final int STEP_UPLOAD = 1;
    public static final int STEP_RECONGNIZE = 2;
    public static final int STEP_CONFIRM = 3;
    public static final int STEP_IMPORT = 4;
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    public static final String SUCCESSINDEX = "successIndex";
    public static final String ERRORINFO = "errorInfo";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel control = (AttachmentPanel)this.getControl("attachmentpanelap");
        control.addUploadListener((UploadListener)this);
        this.addClickListeners(new String[]{BTN_SCAN, BTN_IMPORT, BTN_CHECK, BTN_NEXT, BTN_BACK});
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int steps = Integer.parseInt(this.getModel().getValue(STEPSTATUS).toString());
        if (1 == steps) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_IMPORT, BTN_CHECK, BTN_NEXT, BTN_BACK, "btncancel", IMPORTSTATUS, IMPORTFAILREASON});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (STEPSTATUS.equals(name)) {
            this.setViewByStep();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("importreceipt".equals(operateKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u56de\u5355\u6570\u636e\u3002", (String)"ElecImageUploadEdit_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u56de\u5355\u6570\u636e\uff0c\u5df2\u9009\u62e9%2$s\u6761\u56de\u5355\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5bfc\u5165\u3002", (String)"ElecImageUploadEdit_9", (String)"tmc-bei-formplugin", (Object[])new Object[0]), entryEntity.size(), Math.min(selectRows.length, entryEntity.size())), MessageBoxOptions.YesNo, new ConfirmCallBackListener(BTN_IMPORT, (IFormPlugin)this));
            }
        } else if ("batchedit".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7f16\u8f91\u7684\u56de\u5355\u6570\u636e\u3002", (String)"ElecImageUploadEdit_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                for (int idx : selectRows) {
                    DynamicObject rowData = (DynamicObject)entryEntity.get(idx);
                    if (!"F".equals(rowData.getString("status"))) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c \u7535\u5b50\u56de\u5355\u8bc6\u522b\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"ElecImageUploadEdit_16", (String)"tmc-bei-formplugin", (Object[])new Object[]{idx + 1}));
                    args.setCancel(true);
                    break;
                }
            }
        } else if ("exportentry".equals(operateKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            entryEntity.removeIf(entry -> "S".equals(entry.getString(IMPORTSTATUS)) || entry.getString(IMPORTSTATUS) == null);
            if (entryEntity.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u9519\u8bef\u65e5\u5fd7\u3002", (String)"ElecImageUploadEdit_8", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("check".equals(operateKey)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isshowmessage", String.valueOf(false));
            op.setOption(operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "ocr": {
                    this.beginTask();
                    break;
                }
                case "check": {
                    this.updateValidateResult();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6821\u9a8c\u6210\u529f\u3002", (String)"ElecImageUploadEdit_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "next": {
                    this.setConfirmView();
                    break;
                }
                case "batchedit": {
                    EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                    int[] selectRows = entryGrid.getSelectRows();
                    FormShowParameter showForm = new FormShowParameter();
                    showForm.setFormId("bei_receiptbatchedit");
                    showForm.getOpenStyle().setShowType(ShowType.Modal);
                    showForm.setCustomParam("rowIdxs", (Object)Arrays.toString(selectRows));
                    showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bei_receiptbatchedit"));
                    this.getView().showForm(showForm);
                    break;
                }
            }
        } else if ("check".equals(operateKey)) {
            List allErrorInfo = ((ValidateResult)args.getOperationResult().getValidateResult().getValidateErrors().get(0)).getAllErrorInfo();
            if (allErrorInfo.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171%s\u6761\u56de\u5355\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u8bf7\u67e5\u770b\u660e\u7ec6\u8868\u4e2d\u7684\u6821\u9a8c\u4fe1\u606f\u63d0\u793a\u3002", (String)"ElecImageUploadEdit_14", (String)"tmc-bei-formplugin", (Object[])new Object[]{allErrorInfo.size()}));
            } else {
                for (OperateErrorInfo errorInfo : allErrorInfo) {
                    this.getView().showTipNotification(errorInfo.getMessage());
                }
            }
            this.updateValidateResult();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_BACK.equals(key)) {
            this.restoreConfirmView();
        }
    }

    public void onProgress(ProgressEvent evt) {
        int progress;
        int n = progress = this.getPageCache().get("progress") == null ? 10 : Integer.parseInt(this.getPageCache().get("progress"));
        if (progress < 100) {
            evt.setProgress(progress);
        } else {
            String resultJson = this.getPageCache().get("resultJson");
            evt.setProgress(100);
            this.setFileValidateEntity(resultJson);
            Tab tabap = (Tab)this.getControl("tabap");
            tabap.activeTab("tabimport");
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SCAN, "billno", "receiptno"});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_NEXT, BTN_CHECK});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (BTN_EDIT.equals(hyperLinkClickEvent.getFieldName())) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObject rowData = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
            if ("F".equals(rowData.getString("status"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7535\u5b50\u56de\u5355\u8bc6\u522b\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"ElecImageUploadEdit_4", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showForm = new FormShowParameter();
            showForm.setFormId("bei_receiptimportedit");
            showForm.getOpenStyle().setShowType(ShowType.Modal);
            showForm.setCustomParam("rowIdx", (Object)rowIndex);
            showForm.setCustomParam("filename", (Object)rowData.getString("filename"));
            showForm.setCustomParam("fileurl", (Object)rowData.getString("fileurl"));
            showForm.setCustomParam("creditdebitflag", (Object)rowData.getString("creditdebitflag"));
            showForm.setCustomParam("bizdate", (Object)rowData.getDate("bizdate"));
            showForm.setCustomParam("amount", (Object)rowData.getString("amount"));
            showForm.setCustomParam("currency", (Object)rowData.getString("currency"));
            showForm.setCustomParam("accno", (Object)rowData.getString("accno"));
            showForm.setCustomParam("accname", (Object)rowData.getString("accname"));
            showForm.setCustomParam("bankname", (Object)rowData.getString("bankname"));
            showForm.setCustomParam("recno", (Object)rowData.getString("recno"));
            showForm.setCustomParam("recname", (Object)rowData.getString("recname"));
            showForm.setCustomParam("recbankname", (Object)rowData.getString("recbankname"));
            showForm.setCustomParam("detailid", (Object)rowData.getString("detailid"));
            showForm.setCustomParam("bizrefno", (Object)rowData.getString("bizrefno"));
            showForm.setCustomParam("use", (Object)rowData.getString("use"));
            showForm.setCustomParam("description", (Object)rowData.getString("description"));
            showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bei_receiptimportedit"));
            this.getView().showForm(showForm);
        } else if ("billno".equals(hyperLinkClickEvent.getFieldName())) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObject rowData = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
            BillShowParameter showForm = new BillShowParameter();
            showForm.setFormId("bei_elecreceipt");
            showForm.getOpenStyle().setShowType(ShowType.Modal);
            DynamicObject receipt = QueryServiceHelper.queryOne((String)"bei_elecreceipt", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)rowData.getString("billno"))});
            if (EmptyUtil.isEmpty((DynamicObject)receipt)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ElecImageUploadEdit_5", (String)"tmc-bei-formplugin", (Object[])new Object[]{rowData.getString("billno")}));
                return;
            }
            showForm.setPkId((Object)receipt.getLong("id"));
            showForm.setStatus(OperationStatus.VIEW);
            showForm.setCustomParam("isOcr", (Object)true);
            this.getView().showForm((FormShowParameter)showForm);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (BTN_IMPORT.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.importData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Map resultMap = (Map)closedCallBackEvent.getReturnData();
        if (resultMap == null || resultMap.isEmpty()) {
            return;
        }
        if ("bei_receiptimportedit".equals(actionId)) {
            if (Boolean.TRUE.equals(resultMap.get("dataChanged"))) {
                Integer rowIndex = (Integer)resultMap.get("rowIdx");
                DynamicObject rowData = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex.intValue());
                rowData.set("creditdebitflag", resultMap.get("creditdebitflag"));
                rowData.set("bizdate", resultMap.get("bizdate"));
                rowData.set("currency", resultMap.get("currency"));
                rowData.set("amount", resultMap.get("amount"));
                rowData.set("accountbank", LendingDirectionEnum.OUT.getValue().equals(resultMap.get("creditdebitflag")) ? resultMap.get("accno") : resultMap.get("recno"));
                rowData.set("accno", resultMap.get("accno"));
                rowData.set("accname", resultMap.get("accname"));
                rowData.set("bankname", resultMap.get("bankname"));
                rowData.set("recno", resultMap.get("recno"));
                rowData.set("recname", resultMap.get("recname"));
                rowData.set("recbankname", resultMap.get("recbankname"));
                rowData.set("detailid", resultMap.get("detailid"));
                rowData.set("bizrefno", resultMap.get("bizrefno"));
                rowData.set("use", resultMap.get("use"));
                rowData.set("description", resultMap.get("description"));
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                entryEntity.set(rowIndex.intValue(), (Object)rowData);
                this.getModel().updateEntryCache(entryEntity);
                this.getView().updateView("entryentity");
            }
        } else if ("bei_receiptbatchedit".equals(actionId) && Boolean.TRUE.equals(resultMap.get("dataChanged"))) {
            String[] split;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            String idxStr = (String)resultMap.get("rowIdxs");
            idxStr = idxStr.substring(1, idxStr.length() - 1);
            for (String str : split = idxStr.split(",")) {
                int idx = Integer.parseInt(str.trim());
                DynamicObject rowData = (DynamicObject)entryEntity.get(idx);
                String fieldKey = (String)resultMap.get("key");
                rowData.set(fieldKey, resultMap.get("value"));
                boolean isPay = LendingDirectionEnum.OUT.getValue().equals(rowData.getString("creditdebitflag"));
                if ("creditdebitflag".equals(fieldKey)) {
                    if (isPay) {
                        rowData.set("accountbank", (Object)rowData.getString("accno"));
                    } else {
                        rowData.set("accountbank", (Object)rowData.getString("recno"));
                    }
                } else if ("accno".equals(fieldKey) && isPay) {
                    rowData.set("accountbank", (Object)rowData.getString("accno"));
                } else if ("recno".equals(fieldKey) && !isPay) {
                    rowData.set("accountbank", (Object)rowData.getString("recno"));
                }
                entryEntity.set(idx, (Object)rowData);
            }
            this.getModel().updateEntryCache(entryEntity);
            this.getView().updateView("entryentity");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u64cd\u4f5c\u6210\u529f\u3002", (String)"ElecImageUploadEdit_17", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Integer> setFileValidateEntity(String resultJson) {
        if (resultJson == null || resultJson.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6210\u529f\u89e3\u6790\uff1a\u65e0\u7535\u5b50\u56de\u5355\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ElecImageUploadEdit_6", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
        logger.info("resultJson: " + resultJson);
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField(BTN_EDIT, new Object[0]);
        tvs.addField("requestid", new Object[0]);
        tvs.addField("filename", new Object[0]);
        tvs.addField("fileurl", new Object[0]);
        tvs.addField("status", new Object[0]);
        tvs.addField("failurereason", new Object[0]);
        tvs.addField("prestatus", new Object[0]);
        tvs.addField("prevalidate", new Object[0]);
        tvs.addField("json", new Object[0]);
        int success = 0;
        int failure = 0;
        ArrayList<Integer> successIndex = new ArrayList<Integer>(10);
        List dealResults = (List)JSON.parseObject((String)resultJson, List.class);
        String opColName = ResManager.loadKDString((String)"\u7f16\u8f91", (String)"TransDetailFileImplEdit_5", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
        for (int i = 0; i < dealResults.size(); ++i) {
            int diffMinute;
            Object dealResult = dealResults.get(i);
            DealResultBean result = (DealResultBean)((JSONObject)dealResult).toJavaObject(DealResultBean.class);
            if ("F".equals(result.getStatus())) {
                ++failure;
                tvs.addRow(new Object[]{result.getRequestId(), result.getFileName(), result.getFileURL(), result.getStatus(), result.getFailureReason(), result.getPreStatus(), result.getPreValidate(), result.getJson()});
                continue;
            }
            if (!"S".equals(result.getStatus())) continue;
            ++success;
            ReceiptRecongnizeDetail resultDetail = (ReceiptRecongnizeDetail)JSON.parseObject((String)result.getJson(), ReceiptRecongnizeDetail.class);
            if (EmptyUtil.isNoEmpty((String)resultDetail.getFtradeType())) {
                resultDetail.setFtradeType(LendingDirectionEnum.OUT.getDirect().equals(resultDetail.getFtradeType()) ? LendingDirectionEnum.OUT.getValue() : LendingDirectionEnum.IN.getValue());
            }
            tvs.addField("accountbank", new Object[0]);
            tvs.addField("bizdate", new Object[0]);
            tvs.addField("creditdebitflag", new Object[0]);
            tvs.addField("amount", new Object[0]);
            tvs.addField("currency", new Object[0]);
            tvs.addField("detailid", new Object[0]);
            tvs.addField("bizrefno", new Object[0]);
            tvs.addField("description", new Object[0]);
            tvs.addField("accno", new Object[0]);
            tvs.addField("accname", new Object[0]);
            tvs.addField("bankname", new Object[0]);
            tvs.addField("recno", new Object[0]);
            tvs.addField("recname", new Object[0]);
            tvs.addField("recbankname", new Object[0]);
            BigDecimal amount = new BigDecimal(EmptyUtil.isEmpty((String)resultDetail.getFamount()) ? "0" : resultDetail.getFamount().replace(",", ""));
            Date tradeDate = null;
            String fTradeDate = resultDetail.getFtradeDate().trim();
            if (!EmptyUtil.isEmpty((String)fTradeDate) && (diffMinute = DateUtils.getDiffMinute((Date)(tradeDate = DateFormatUtil.FormatDate((String)fTradeDate)), (Date)new Date())) < 2) {
                tradeDate = null;
            }
            tvs.addRow(new Object[]{opColName, result.getRequestId(), result.getFileName(), result.getFileURL(), result.getStatus(), result.getFailureReason(), result.getPreStatus(), result.getPreValidate(), result.getJson(), result.getAccno(), tradeDate, resultDetail.getFtradeType(), amount, resultDetail.getFcurrency(), resultDetail.getFtradeId(), resultDetail.getFtradeNumber(), resultDetail.getFabstract(), resultDetail.getFpaymentAccount(), resultDetail.getFpaymentName(), resultDetail.getFpaymentBank(), resultDetail.getFpayeeAccount(), resultDetail.getFpayeeName(), resultDetail.getFpayeeBank()});
            if (!"S".equals(result.getPreStatus())) continue;
            successIndex.add(i);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        model.setValue(SUCCESS, (Object)ResManager.loadKDString((String)"%s\u5f20\u8bc6\u522b\u6210\u529f\u3002", (String)"TransDetailFileImplEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[]{String.valueOf(success)}));
        model.setValue(FAILURE, (Object)ResManager.loadKDString((String)"%s\u5f20\u8bc6\u522b\u5931\u8d25\u3002", (String)"TransDetailFileImplEdit_1", (String)"tmc-bei-formplugin", (Object[])new Object[]{String.valueOf(failure)}));
        model.batchCreateNewEntryRow("entryentity", tvs);
        model.endInit();
        this.getView().updateView("entryentity");
        this.getView().updateView(SUCCESS);
        this.getView().updateView(FAILURE);
        this.getPageCache().put(SUCCESS, String.valueOf(success));
        this.getPageCache().put(FAILURE, String.valueOf(failure));
        return successIndex;
    }

    private void beginTask() {
        AttachmentPanel control = (AttachmentPanel)this.getControl("attachmentpanelap");
        List attachmentData = control.getAttachmentData();
        String dataJson = JSON.toJSONString((Object)attachmentData);
        if (attachmentData.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"ElecImageUploadEdit_7", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        this.start();
        this.getPageCache().put("total", String.valueOf(attachmentData.size()));
        ElecReceiptImportTask task = new ElecReceiptImportTask(this.getView().getPageId(), dataJson);
        logger.info("\u5f00\u59cb\u7535\u5b50\u56de\u5355\u6587\u4ef6\u8bc6\u522b\uff1aattachmentData.size = " + attachmentData.size());
        ThreadPools.executeOnceIncludeRequestContext((String)"receiptImportTask", (Runnable)task);
        this.getModel().setValue(STEPSTATUS, (Object)2);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SCAN});
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.activeTab("tabrecongnize");
    }

    private void importData() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        this.getModel().setValue(STEPSTATUS, (Object)4);
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        logger.info("\u5f00\u59cb\u7535\u5b50\u56de\u5355\u5bfc\u5165\uff1areceiptSize = " + entryEntities.size() + ", selectRows: " + Arrays.toString(selectRows));
        int success = 0;
        for (int idx : selectRows) {
            if (idx >= entryEntities.size()) {
                return;
            }
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(idx);
            if ("F".equals(entryEntity.getString("status"))) continue;
            String bankAccountNumber = entryEntity.getString("accountbank");
            BigDecimal amount = entryEntity.getBigDecimal("amount");
            String currencyCode = entryEntity.getString("currency");
            String payeeAccount = entryEntity.getString("recno");
            String payeeName = entryEntity.getString("recname");
            String payeeBank = entryEntity.getString("recbankname");
            String paymentAccount = entryEntity.getString("accno");
            String paymentName = entryEntity.getString("accname");
            String paymentBank = entryEntity.getString("bankname");
            Date bizDate = entryEntity.getDate("bizdate");
            String detailId = entryEntity.getString("detailid");
            String tradeType = entryEntity.getString("creditdebitflag");
            String use = entryEntity.getString("use");
            String description = entryEntity.getString("description");
            String tradeNumber = entryEntity.getString("bizrefno");
            String fileUrl = entryEntity.getString("fileurl");
            logger.info("ReceiptFileImport. fileName: " + entryEntity.getString("filename") + ",accountBankNumber: " + bankAccountNumber + ",detailId: " + detailId + ",currencyCode: " + currencyCode + ",amount: " + amount + ",bizDate: " + bizDate);
            try {
                boolean isPay;
                DynamicObject receipt = BusinessDataServiceHelper.newDynamicObject((String)"bei_elecreceipt");
                DynamicObject accountBank = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,company,bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)bankAccountNumber)});
                receipt.set("accountbank", (Object)accountBank);
                DynamicObject currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyCode).or(new QFilter("name", "=", (Object)currencyCode).and("issystem", "=", (Object)true))});
                if (!EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5e01\u79cd%s\u5728\u3010\u57fa\u7840\u8d44\u6599\u3011-\u3010\u5e01\u79cd\u3011\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"ElecImageUploadEdit_15", (String)"tmc-bei-formplugin", (Object[])new Object[]{currencyCode}));
                }
                receipt.set("currency", currency.get("id"));
                DynamicObject company = accountBank.getDynamicObject("company");
                Long companyId = (Long)company.getPkValue();
                logger.info("companyId: " + companyId + ",companyName: " + company.getString("name"));
                receipt.set("company", (Object)companyId);
                receipt.set("bank", accountBank.getDynamicObject("bank").getPkValue());
                if (accountBank.getDynamicObject("company") == null) {
                    long userId = RequestContext.get().getCurrUserId();
                    String appId = this.getView().getFormShowParameter().getAppId();
                    List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"bei_elecreceipt", (String)"47150e89000000ac");
                    if (!authOrgIds.isEmpty()) {
                        receipt.set("company", authOrgIds.get(0));
                    }
                }
                receipt.set("oppbanknumber", (Object)((isPay = LendingDirectionEnum.OUT.getValue().equals(tradeType)) ? payeeAccount : paymentAccount));
                receipt.set("oppbankname", (Object)(isPay ? payeeName : paymentName));
                receipt.set("oppbank", (Object)(isPay ? payeeBank : paymentBank));
                receipt.set("oppunit", (Object)(isPay ? payeeName : paymentName));
                receipt.set("recno", (Object)payeeAccount);
                receipt.set("recname", (Object)payeeName);
                receipt.set("recbankname", (Object)payeeBank);
                receipt.set("accno", (Object)paymentAccount);
                receipt.set("accname", (Object)paymentName);
                receipt.set("bankname", (Object)paymentBank);
                receipt.set(isPay ? "debitamount" : "creditamount", (Object)amount);
                receipt.set("amount", (Object)amount);
                receipt.set("detailid", (Object)detailId);
                receipt.set("bizrefno", (Object)tradeNumber);
                receipt.set("bizdate", (Object)bizDate);
                receipt.set("detaildatetime", (Object)bizDate);
                receipt.set("uploadfilename", (Object)fileUrl);
                receipt.set("filepath", (Object)fileUrl);
                receipt.set("fileflag", (Object)"1");
                receipt.set("completeflag", (Object)"1");
                receipt.set("biztype", (Object)"1");
                receipt.set("use", (Object)use);
                receipt.set("description", (Object)description);
                receipt.set("remarks", (Object)description);
                receipt.set("creditdebitflag", (Object)tradeType);
                long id = DBServiceHelper.genGlobalLongId();
                receipt.set("id", (Object)id);
                String receiptNo = "e-ocr-" + id;
                receipt.set("receiptno", (Object)receiptNo);
                receipt.set("datasource", (Object)"image");
                receipt.set("billstatus", (Object)"A");
                receipt.set("modifytime", (Object)DateUtils.getCurrentTime());
                String billNo = CodeRuleHelper.generateNumber((String)"bei_elecreceipt", (DynamicObject)receipt, null, null);
                receipt.set("billno", (Object)billNo);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{receipt});
                entryEntity.set("receiptno", (Object)receiptNo);
                entryEntity.set("billno", (Object)billNo);
                entryEntity.set(IMPORTSTATUS, (Object)"S");
                logger.info("\u5bfc\u5165\u6210\u529f\u3002 idx: " + idx + " receiptBillNo: " + billNo + " receiptNo: " + receiptNo + " detailId: " + detailId);
                ++success;
            }
            catch (Exception e) {
                entryEntity.set(IMPORTSTATUS, (Object)"F");
                entryEntity.set(IMPORTFAILREASON, (Object)e.getMessage());
                logger.error("\u5bfc\u5165\u5931\u8d25\u3002 idx: " + idx + " Exception: " + e.getMessage() + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            entryEntities.set(idx, (Object)entryEntity);
        }
        this.getModel().setValue("entryentity", (Object)entryEntities);
        this.getModel().setValue(SUCCESS, (Object)String.format(ResManager.loadKDString((String)"\u5171\u4e0a\u4f20%1$s\u4e2a\u7535\u5b50\u56de\u5355\u6587\u4ef6\uff0c\u5176\u4e2d\u6210\u529f\u8bc6\u522b%2$s\u6761\u7535\u5b50\u56de\u5355\uff08\u9009\u62e9\u5bfc\u5165%3$s\u6761\uff0c\u6210\u529f\u5bfc\u5165%4$s\u6761\uff09\uff0c\u8bc6\u522b\u5931\u8d25%5$s\u6761\u3002", (String)"ElecImageUploadEdit_10", (String)"tmc-bei-formplugin", (Object[])new Object[0]), this.getPageCache().get("total"), this.getPageCache().get(SUCCESS), selectRows.length, success, this.getPageCache().get(FAILURE)));
        entryGrid.setStopSelectRow(true);
        this.getView().updateView("entryentity");
        this.getView().updateView(SUCCESS);
        if (success > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u56de\u5355\u5bfc\u5165\u6210\u529f\u3002", (String)"ElecImageUploadEdit_11", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }

    private void start() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.start();
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c...", (String)"ElecImageUploadEdit_12", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("progressBar", "true");
    }

    private void setConfirmView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EDIT, "status", "failurereason", "prestatus", "prevalidate"});
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        entryEntity.removeIf(entry -> "F".equals(entry.getString("status")));
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("entryentity");
        this.getModel().setValue(STEPSTATUS, (Object)3);
    }

    private void restoreConfirmView() {
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_EDIT, "status", "failurereason", "prestatus", "prevalidate"});
        this.getModel().setValue(STEPSTATUS, (Object)2);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BACK, BTN_IMPORT});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_NEXT, BTN_CHECK, "deleteentryap", BTN_BATCH_EDIT});
    }

    private void updateValidateResult() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List successIndex = null;
        if (ThreadCache.exists((Object)SUCCESSINDEX)) {
            successIndex = (List)ThreadCache.get((Object)SUCCESSINDEX);
            ThreadCache.remove((Object)SUCCESSINDEX);
        }
        if (successIndex != null && !successIndex.isEmpty()) {
            logger.info("successIndex: " + successIndex);
            for (Integer idx : successIndex) {
                DynamicObject rowData = (DynamicObject)entryEntity.get(idx.intValue());
                rowData.set("prestatus", (Object)"S");
                rowData.set("prevalidate", null);
            }
        }
        List errorInfoList = null;
        if (ThreadCache.exists((Object)ERRORINFO)) {
            errorInfoList = (List)ThreadCache.get((Object)ERRORINFO);
            ThreadCache.remove((Object)ERRORINFO);
        }
        if (errorInfoList != null && !errorInfoList.isEmpty()) {
            for (OperateErrorInfo errorInfo : errorInfoList) {
                ErrorLevel errorLevel = errorInfo.getLevel();
                int idx = Integer.parseInt(errorInfo.getMessage().split("_")[0]);
                DynamicObject rowData = (DynamicObject)entryEntity.get(idx);
                String errorMessage = errorInfo.getMessage().split("_")[1];
                if (ErrorLevel.Warning.equals((Object)errorLevel)) {
                    rowData.set("prestatus", (Object)"S");
                    rowData.set("prevalidate", (Object)errorMessage);
                    continue;
                }
                if (!ErrorLevel.Error.equals((Object)errorLevel)) continue;
                rowData.set("prestatus", (Object)"F");
                rowData.set("prevalidate", (Object)errorMessage);
            }
        }
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("entryentity");
    }

    private void setViewByStep() {
        Wizard wizard = (Wizard)this.getControl("wizardap");
        int steps = Integer.parseInt(this.getModel().getValue(STEPSTATUS).toString());
        Map<String, Integer> currentStepMap = Collections.singletonMap("currentStep", steps - 1);
        wizard.setWizardCurrentStep(currentStepMap);
        if (3 == steps) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEXT, BTN_CHECK, "deleteentryap", BTN_BATCH_EDIT, "imageap4", FAILURE});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_BACK, BTN_IMPORT});
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            this.getModel().setValue(SUCCESS, (Object)ResManager.loadKDString((String)"\u5171%s\u6761\u56de\u5355\u6570\u636e\u53ef\u5bfc\u5165\uff0c\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u56de\u5355\u6570\u636e\u3002", (String)"ElecImageUploadEdit_13", (String)"tmc-bei-formplugin", (Object[])new Object[]{entryEntity.size()}));
            List successIndex = null;
            if (ThreadCache.exists((Object)SUCCESSINDEX)) {
                successIndex = (List)ThreadCache.get((Object)SUCCESSINDEX);
                ThreadCache.remove((Object)SUCCESSINDEX);
            }
            if (successIndex != null && !successIndex.isEmpty()) {
                List finalSuccessIndex = successIndex;
                finalSuccessIndex = successIndex.stream().map(finalSuccessIndex::indexOf).collect(Collectors.toList());
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                entryGrid.selectRows(finalSuccessIndex.stream().mapToInt(i -> i).toArray(), 0);
            }
        } else if (4 == steps) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_IMPORT, BTN_BACK});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btncancel", "billno", "receiptno", IMPORTSTATUS, IMPORTFAILREASON, BTN_LOG_EXPORT});
        }
    }
}

