/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.opservice.elec.ViewReceiptService;
import kd.tmc.bei.common.enums.LendingDirectionEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElecReceiptEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean isOcr = (Boolean)this.getView().getFormShowParameter().getCustomParam("isOcr");
        if (isOcr != null && isOcr.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_viewreceipt"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"company"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long pkValue;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("viewreceipt".equals(key) && (pkValue = (Long)this.getView().getModel().getDataEntity().getPkValue()) != null) {
            args.setCancel(true);
            ViewReceiptService service = new ViewReceiptService();
            service.openReceiptById(this.getView(), (Object[])new Long[]{pkValue});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        String creditdebitflag = (String)this.getModel().getValue("creditdebitflag");
        switch (fieldKey) {
            case "creditdebitflag": {
                if (oldValue.equals(newValue) || newValue == null || newValue.toString().trim().equals("")) break;
                Object OldDebitamount = this.getModel().getValue("debitamount");
                Object OldCreditamount = this.getModel().getValue("creditamount");
                this.getModel().setValue("creditamount", OldDebitamount);
                this.getModel().setValue("debitamount", OldCreditamount);
                this.accountswitch(newValue);
                break;
            }
            case "accno": {
                if (LendingDirectionEnum.OUT.getValue().equals(creditdebitflag)) {
                    this.changeAccount(newValue, creditdebitflag);
                    break;
                }
                if (!LendingDirectionEnum.IN.getValue().equals(creditdebitflag)) break;
                this.changeTextAccount(newValue, creditdebitflag);
                break;
            }
            case "recno": {
                if (LendingDirectionEnum.IN.getValue().equals(creditdebitflag)) {
                    this.changeAccount(newValue, creditdebitflag);
                    break;
                }
                if (!LendingDirectionEnum.OUT.getValue().equals(creditdebitflag)) break;
                this.changeTextAccount(newValue, creditdebitflag);
                break;
            }
            case "debitamount": {
                if (!LendingDirectionEnum.OUT.getValue().equals(creditdebitflag)) break;
                this.getModel().setValue("amount", newValue);
                break;
            }
            case "creditamount": {
                if (!LendingDirectionEnum.IN.getValue().equals(creditdebitflag)) break;
                this.getModel().setValue("amount", newValue);
                break;
            }
        }
    }

    private void accountswitch(Object creditdebitflag) {
        Object accno = this.getModel().getValue("accno");
        Object recno = this.getModel().getValue("recno");
        if (!EmptyUtil.isEmpty((Object)accno)) {
            this.getModel().setValue("recno", null);
            this.getModel().setValue("recno", recno);
        }
        if (!EmptyUtil.isEmpty((Object)accno)) {
            this.getModel().setValue("accno", null);
            this.getModel().setValue("accno", accno);
        }
    }

    private void changeTextAccount(Object newValue, String creditdebitflag) {
        DynamicObjectCollection accountbank = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,name,company.name,bank.name", (QFilter[])new QFilter("bankaccountnumber", "=", newValue).toArray());
        if (!accountbank.isEmpty()) {
            if (LendingDirectionEnum.OUT.getValue().equals(creditdebitflag)) {
                this.getModel().setValue("recname", (Object)((DynamicObject)accountbank.get(0)).getString("company.name"));
                this.getModel().setValue("recbankname", (Object)((DynamicObject)accountbank.get(0)).getString("bank.name"));
                this.getModel().setValue("oppbanknumber", newValue);
                this.getModel().setValue("oppunit", (Object)((DynamicObject)accountbank.get(0)).getString("company.name"));
                this.getModel().setValue("oppbankname", (Object)((DynamicObject)accountbank.get(0)).getString("name"));
                this.getModel().setValue("oppbank", (Object)((DynamicObject)accountbank.get(0)).getString("bank.name"));
            } else if (LendingDirectionEnum.IN.getValue().equals(creditdebitflag)) {
                this.getModel().setValue("accname", (Object)((DynamicObject)accountbank.get(0)).getString("company.name"));
                this.getModel().setValue("bankname", (Object)((DynamicObject)accountbank.get(0)).getString("bank.name"));
                this.getModel().setValue("oppbanknumber", newValue);
                this.getModel().setValue("oppunit", (Object)((DynamicObject)accountbank.get(0)).getString("company.name"));
                this.getModel().setValue("oppbankname", (Object)((DynamicObject)accountbank.get(0)).getString("name"));
                this.getModel().setValue("oppbank", (Object)((DynamicObject)accountbank.get(0)).getString("bank.name"));
            }
        }
    }

    private void changeAccount(Object newValue, String creditdebitflag) {
        DynamicObjectCollection accountbank = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,name,company.name,bank.name,company.id,bank.id", (QFilter[])new QFilter("bankaccountnumber", "=", newValue).toArray());
        if (!accountbank.isEmpty()) {
            this.getModel().setValue("accountbank", ((DynamicObject)accountbank.get(0)).get("id"));
            this.getModel().setValue("company", ((DynamicObject)accountbank.get(0)).get("company.id"));
            this.getModel().setValue("bank", ((DynamicObject)accountbank.get(0)).get("bank.id"));
            if (LendingDirectionEnum.OUT.getValue().equals(creditdebitflag)) {
                this.getModel().setValue("accname", ((DynamicObject)accountbank.get(0)).get("company.name"));
                this.getModel().setValue("bankname", ((DynamicObject)accountbank.get(0)).get("bank.name"));
            } else if (LendingDirectionEnum.IN.getValue().equals(creditdebitflag)) {
                this.getModel().setValue("recname", ((DynamicObject)accountbank.get(0)).get("company.name"));
                this.getModel().setValue("recbankname", ((DynamicObject)accountbank.get(0)).get("bank.name"));
            }
        }
    }
}

