/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.ocr.invoke.ScanSystemFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class ElecReceiptFileList
extends AbstractTmcBillBaseList
implements UploadListener {
    private static final Log logger = LogFactory.getLog(ElecReceiptFileList.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addUploadListener((UploadListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (!EmptyUtil.isEmpty((Object)operationResult) && operationResult.isSuccess()) {
            String operateKey;
            switch (operateKey = args.getOperateKey()) {
                case "cancelmatch": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u4e0e\u4ea4\u6613\u660e\u7ec6\u53d6\u6d88\u5339\u914d\u6210\u529f\u3002", (String)"ElecReceiptFileList_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "importimage": {
                    FormShowParameter showForm = new FormShowParameter();
                    showForm.setFormId("bei_importimage");
                    showForm.getOpenStyle().setShowType(ShowType.Modal);
                    showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importImage"));
                    this.getView().showForm(showForm);
                    break;
                }
                case "match": {
                    this.executeMatch();
                    break;
                }
                case "scan": {
                    this.executeScan();
                    break;
                }
            }
        }
    }

    private void executeMatch() {
        List ids = this.getSelectedIdList();
        if (ids.size() == 0) {
            return;
        }
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id,accountbank.id,ismatch", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        ArrayList<Long> sendIds = new ArrayList<Long>();
        for (DynamicObject obj : objs) {
            if (obj.getBoolean("ismatch")) continue;
            list.add(obj);
            sendIds.add((Long)obj.get("id"));
        }
        if (list.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5168\u90e8\u5df2\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ElecReceiptFileList_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showForm = new FormShowParameter();
        String idsJson = JSON.toJSONString(sendIds);
        showForm.setCustomParam("ids", (Object)idsJson);
        showForm.setFormId("bei_receiptmatch");
        showForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showForm);
    }

    private void executeScan() {
        logger.info("===============\u5feb\u901f\u626b\u63cf\u5f00\u59cb");
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection userObj = QueryServiceHelper.query((String)"bos_user", (String)"id,phone", (QFilter[])new QFilter("id", "=", (Object)userId).toArray());
        DynamicObjectCollection configObj = QueryServiceHelper.query((String)"bas_imageconfig", (String)"imageurl,clientid,clientsecret", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"A")});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)configObj)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f71\u50cf\u7cfb\u7edf\u914d\u7f6e\u57fa\u7840\u8d44\u6599\u4e0d\u53ef\u7528\uff0c\u8bf7\u5148\u7ef4\u62a4\u8be5\u6570\u636e\u3002", (String)"ElecReceiptFileList_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            return;
        }
        String scanUrl = ScanSystemFactory.getScanService().getScanSystem(((DynamicObject)configObj.get(0)).getString("clientid"), ((DynamicObject)configObj.get(0)).getString("clientsecret"), ((DynamicObject)configObj.get(0)).getString("imageurl"), ((DynamicObject)userObj.get(0)).getString("phone"));
        FormShowParameter showForm = new FormShowParameter();
        showForm.setCustomParam("url", (Object)scanUrl);
        showForm.setFormId("bei_fastscan");
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fastscan"));
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showForm);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if ("importImage".equals(event.getActionId())) {
            Map returnData = (Map)event.getReturnData();
            if (returnData != null) {
                String fieldJson = (String)returnData.get("fieldJson");
                HashMap<String, String> fieldMap = (HashMap<String, String>)JSON.parseObject((String)fieldJson, Map.class);
                if (fieldMap == null) {
                    fieldMap = new HashMap<String, String>();
                }
                String total = (String)returnData.get("total");
                this.resultHandler(fieldMap, Integer.parseInt(total));
            }
            BillList billlistap = (BillList)this.getControl("billlistap");
            billlistap.refresh();
        } else if ("fastscan".equals(event.getActionId())) {
            BillList billlistap = (BillList)this.getControl("billlistap");
            logger.info("===============\u5feb\u901f\u626b\u63cf\u7ed3\u675f");
            billlistap.refresh();
        }
    }

    private void resultHandler(Map<String, String> fieldMap, int total) {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("bei_importafter");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> customMap = new HashMap<String, Object>(4);
        customMap.put("result", fieldMap);
        customMap.put("total", total);
        showForm.setCustomParams(customMap);
        this.getView().showForm(showForm);
    }
}

