/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.extplugin.PluginProxy;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.FileNameUtils;
import kd.sdk.tmc.bei.extpoint.receipt.IAfterReceiptRecognition;
import kd.tmc.bei.business.ocr.impl.OcrServiceImpl;
import kd.tmc.bei.common.bean.DealResultBean;
import kd.tmc.bei.common.constants.OcrReceiptBean;
import kd.tmc.bei.common.constants.ReceiptInfoBean;
import kd.tmc.bei.common.constants.ReceiptRecongnizeDetail;
import kd.tmc.bei.common.enums.LendingDirectionEnum;
import kd.tmc.bei.common.helper.OfdFileParseHelper;
import kd.tmc.fbp.common.helper.DateFormatUtil;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElecReceiptImportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(ElecReceiptImportTask.class);
    private final String pageId;
    private final String dataJson;

    public ElecReceiptImportTask(String pageId, String dataJson) {
        this.pageId = pageId;
        this.dataJson = dataJson;
    }

    @Override
    public void run() {
        this.doTask();
    }

    private void doTask() {
        PageCache pageCache = new PageCache(this.pageId);
        List attachmentData = (List)JSON.parseObject((String)this.dataJson, List.class);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        FileService fs = FileServiceFactory.getAttachmentFileService();
        ArrayList<DealResultBean> results = new ArrayList<DealResultBean>(10);
        int progress = 0;
        int interval = 0;
        if (!attachmentData.isEmpty()) {
            interval = this.getInterval(attachmentData.size());
        }
        for (Object object : attachmentData) {
            Map attachmentMap = (Map)object;
            String fileName = (String)attachmentMap.get("name");
            DealResultBean result = new DealResultBean();
            String requestId = RequestContext.get().getRequestId();
            result.setRequestId(requestId);
            result.setFileName(fileName);
            logger.info("ElecReceiptImportTask requestId: " + requestId + ",fileName: " + fileName);
            try {
                InputStream ins = tempFileCache.getInputStream((String)attachmentMap.get("url"));
                Throwable throwable = null;
                String lastModified = String.valueOf(attachmentMap.get("lastModified"));
                String tenantId = RequestContext.get().getTenantId();
                String accountId = RequestContext.get().getAccountId();
                long uploadPkId = DBServiceHelper.genGlobalLongId();
                String uploadPath = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (Object)uploadPkId, (String)("importfile/" + lastModified + "/" + fileName));
                FileItem fileItem = new FileItem(uploadPath, uploadPath, ins);
                logger.info("uploadPath: " + uploadPath + ",uploadFileItem: " + fileItem);
                String uploadUrl = fs.upload(fileItem);
                logger.info("Upload successful. uploadUrl: " + uploadUrl);
                result.setFileURL(uploadUrl);
                try (InputStream insNew = fs.getInputStream(uploadUrl);){
                    OcrReceiptBean ocrReceiptBean;
                    if (fileName.endsWith(".ofd") || fileName.endsWith(".OFD")) {
                        ocrReceiptBean = new OcrReceiptBean();
                        ReceiptInfoBean receiptInfoBean = OfdFileParseHelper.genReceiptOfdParseResult((String)uploadPath, (String)fileName);
                        ocrReceiptBean.setData(Collections.singletonList(JSON.parseObject((String)JSON.toJSONString((Object)receiptInfoBean))));
                        ocrReceiptBean.setErrorCode("0");
                    } else {
                        OcrServiceImpl osi = new OcrServiceImpl();
                        ocrReceiptBean = osi.getReceiptDetail(insNew, uploadPath);
                    }
                    this.dealOcrResult(ocrReceiptBean, result, results);
                    results.add(result);
                }
                catch (Exception e) {
                    result.setStatus("F");
                    result.setFailureReason(String.format(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a%s\u3002", (String)"ElecReceiptImportTask_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]), e));
                    logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    results.add(result);
                    if (ins == null) continue;
                    if (throwable != null) {
                        try {
                            ins.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    ins.close();
                    continue;
                }
                try {
                    if ((progress += interval) >= 100) {
                        progress = 99;
                    }
                    pageCache.put("progress", String.valueOf(progress));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (ins == null) continue;
                    if (throwable != null) {
                        try {
                            ins.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    ins.close();
                }
            }
            catch (Exception e) {
                result.setStatus("F");
                result.setFailureReason(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a%s\u3002", (String)"ElecReceiptImportTask_2", (String)"tmc-bei-formplugin", (Object[])new Object[]{e}));
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                results.add(result);
            }
        }
        if (!results.isEmpty()) {
            String resultJson = JSON.toJSONString(results);
            pageCache.put("resultJson", resultJson);
        }
        progress = 100;
        pageCache.put("progress", String.valueOf(progress));
    }

    private int getInterval(int count) {
        BigDecimal interval = BigDecimal.valueOf(100.0).divide(new BigDecimal(count), 2, RoundingMode.HALF_UP);
        return interval.intValue();
    }

    private void dealOcrResult(OcrReceiptBean ocrReceiptBean, DealResultBean ocrResult, List<DealResultBean> resultDataList) {
        String errorCode = ocrReceiptBean.getErrorCode();
        logger.info("recognizeDescription: " + ocrReceiptBean.getDescription());
        if (EmptyUtil.isEmpty((String)errorCode) || "0".equals(errorCode)) {
            List datas = ocrReceiptBean.getData();
            if (datas == null || datas.isEmpty()) {
                ocrResult.setStatus("F");
                ocrResult.setFailureReason(ResManager.loadKDString((String)"\u672a\u6210\u529f\u89e3\u6790\uff1a\u65e0\u7535\u5b50\u56de\u5355\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ElecReceiptImportTask_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                return;
            }
            for (Object data : datas) {
                DealResultBean result = new DealResultBean();
                result.setRequestId(ocrResult.getRequestId());
                result.setFileName(ocrResult.getFileName());
                result.setFileURL(ocrResult.getFileURL());
                ReceiptInfoBean receiptInfoBean = (ReceiptInfoBean)((JSONObject)data).toJavaObject(ReceiptInfoBean.class);
                logger.info("No." + (datas.indexOf(data) + 1) + " recognizeJsonObject: " + receiptInfoBean.toString() + " recegnizeDetail: " + receiptInfoBean.getRecongnizeDetail().toString());
                if (EmptyUtil.isNoEmpty((String)receiptInfoBean.getErrorInfo()) && !"".equals(receiptInfoBean.getErrorInfo().trim())) {
                    result.setStatus("F");
                    result.setFailureReason(receiptInfoBean.getErrorInfo());
                    logger.error(receiptInfoBean.getErrorInfo());
                    continue;
                }
                ReceiptRecongnizeDetail recognizeDetail = receiptInfoBean.getRecongnizeDetail();
                recognizeDetail = this.dealOcrResultExt(recognizeDetail);
                this.ocrResultCurrencyProcess(recognizeDetail);
                result.setJson(JSON.toJSONString((Object)recognizeDetail));
                result.setStatus("S");
                if (this.receiptValidate(recognizeDetail, result)) {
                    result.setPreStatus("S");
                    logger.info(result.getFileName() + " recognize successful.");
                }
                resultDataList.add(result);
            }
        } else {
            ocrResult.setStatus("F");
            ocrResult.setFailureReason(ocrReceiptBean.getDescription());
            logger.error(ocrReceiptBean.getDescription());
        }
    }

    private boolean receiptValidate(ReceiptRecongnizeDetail recognizeDetail, DealResultBean result) {
        Date tradeDate;
        int diffMinute;
        BigDecimal amount = new BigDecimal(EmptyUtil.isEmpty((String)recognizeDetail.getFamount()) ? "0" : recognizeDetail.getFamount().replace(",", ""));
        String currencyCode = recognizeDetail.getFcurrency();
        String fpayeeAccount = recognizeDetail.getFpayeeAccount();
        String fpaymentAccount = recognizeDetail.getFpaymentAccount();
        String ftradeDate = recognizeDetail.getFtradeDate().trim();
        String ftradeId = recognizeDetail.getFtradeId();
        String ftradeType = recognizeDetail.getFtradeType();
        String bankAccountNumber = LendingDirectionEnum.IN.getDirect().equals(ftradeType) ? fpayeeAccount : fpaymentAccount;
        StringBuilder errorMessage = new StringBuilder();
        if (EmptyUtil.isEmpty((String)bankAccountNumber)) {
            errorMessage.append(LendingDirectionEnum.IN.getDirect().equals(ftradeType) ? ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u6237\u4e3a\u7a7a\u3002", (String)"ElecReceiptImportTask_4", (String)"tmc-bei-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u4e3a\u7a7a\u3002", (String)"ElecReceiptImportTask_13", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        } else {
            result.setAccno(bankAccountNumber);
        }
        if (EmptyUtil.isEmpty((String)currencyCode)) {
            errorMessage.append(ResManager.loadKDString((String)"\u5e01\u79cd\u4e3a\u7a7a\u3002", (String)"ElecReceiptImportTask_5", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((BigDecimal)amount)) {
            errorMessage.append(ResManager.loadKDString((String)"\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"ElecReceiptImportTask_6", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((String)ftradeType)) {
            errorMessage.append(ResManager.loadKDString((String)"\u501f\u8d37\u6807\u8bb0\u4e3a\u7a7a\u3002", (String)"ElecReceiptImportTask_7", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((String)ftradeDate)) {
            errorMessage.append(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ElecReceiptImportTask_8", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
        if (!EmptyUtil.isEmpty((String)ftradeDate) && (diffMinute = DateUtils.getDiffMinute((Date)(tradeDate = DateFormatUtil.FormatDate((String)ftradeDate)), (Date)new Date())) < 2) {
            errorMessage.append(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u683c\u5f0f\u65e0\u6548\u3002", (String)"ElecReceiptImportTask_9", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((String)errorMessage.toString())) {
            result.setPreStatus("F");
            result.setPreValidate(errorMessage.toString());
            return false;
        }
        DynamicObject accountBank = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,company,bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)bankAccountNumber)});
        if (EmptyUtil.isEmpty((DynamicObject)accountBank)) {
            result.setPreStatus("F");
            result.setPreValidate(ResManager.loadKDString((String)"\u8d26\u53f7\u3010%s\u3011\u5728\u94f6\u884c\u8d26\u6237\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u7ef4\u62a4\u94f6\u884c\u8d26\u6237\u3002", (String)"ElecReceiptImportTask_10", (String)"tmc-bei-formplugin", (Object[])new Object[]{bankAccountNumber}));
            return false;
        }
        Object accountBankId = accountBank.getPkValue();
        DynamicObject currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyCode).or(new QFilter("name", "=", (Object)currencyCode).and("issystem", "=", (Object)true))});
        boolean exists = false;
        logger.info("ftradeId: " + ftradeId + ",currency: " + currencyCode + ",accountBankId: " + accountBankId + ",amount: " + amount);
        QFilter filter = new QFilter("id", "!=", null);
        if (accountBankId != null && fpaymentAccount != null) {
            filter.and("currency", "=", EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.get("id") : null);
            filter.and("accountbank", "=", accountBankId);
            filter.and("detailid", "=", (Object)(EmptyUtil.isEmpty((String)ftradeId) ? null : ftradeId));
            filter.and(LendingDirectionEnum.IN.getDirect().equals(ftradeType) ? "creditamount" : "debitamount", "=", (Object)amount);
            filter.and("bizrefno", "=", (Object)recognizeDetail.getFtradeNumber());
            exists = QueryServiceHelper.exists((String)"bei_elecreceipt", (QFilter[])filter.toArray());
        }
        logger.info("receipt exists: " + exists);
        if (exists) {
            DynamicObject receipt = QueryServiceHelper.queryOne((String)"bei_elecreceipt", (String)"id, receiptno", (QFilter[])filter.toArray());
            String receiptNo = receipt.getString("receiptno");
            result.setPreStatus("F");
            result.setPreValidate(ResManager.loadKDString((String)"\u5b58\u5728\u7591\u4f3c\u91cd\u590d\u6570\u636e\uff0c\u7535\u5b50\u56de\u5355\u53f7\u3010%s\u3011\uff0c\u8bf7\u786e\u8ba4\u56de\u5355\u6587\u4ef6\u662f\u5426\u5df2\u7ecf\u5bfc\u5165\u3002", (String)"ElecReceiptImportTask_11", (String)"tmc-bei-formplugin", (Object[])new Object[]{receiptNo}));
        }
        DynamicObject company = accountBank.getDynamicObject("company");
        Long companyId = (Long)company.getPkValue();
        logger.info("companyId: " + companyId);
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPermission = TmcOrgDataHelper.hasPermission(null, (long)userId, (long)companyId, (String)"bei_elecreceipt", (String)"47150e89000000ac");
        if (!hasPermission) {
            result.setPreStatus("F");
            result.setPreValidate(ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u8be5\u56de\u5355\u6587\u4ef6\u6240\u5c5e\u94f6\u884c\u8d26\u6237\u3010%s\u3011\u7684\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u6388\u6743\u540e\u518d\u5bfc\u5165\u3002", (String)"ElecReceiptImportTask_12", (String)"tmc-bei-formplugin", (Object[])new Object[]{bankAccountNumber}));
            return false;
        }
        return true;
    }

    private ReceiptRecongnizeDetail dealOcrResultExt(ReceiptRecongnizeDetail recognizeDetail) {
        String toJsonString;
        PluginProxy pluginProxy = PluginProxy.create(IAfterReceiptRecognition.class, (String)"kd.sdk.tmc.bei.extpoint.receipt.IAfterReceiptRecognition.fillRecognitionResult");
        List resultList = pluginProxy.callReplace(arg_0 -> ElecReceiptImportTask.lambda$dealOcrResultExt$0(toJsonString = SerializationUtils.toJsonString((Object)recognizeDetail), arg_0));
        if (resultList != null && !resultList.isEmpty() && EmptyUtil.isNoEmpty((String)((String)resultList.get(0)))) {
            String resultJson = (String)resultList.get(0);
            logger.info("\u7535\u5b50\u56de\u5355\u8bc6\u522b -- \u4e8c\u5f00\u5904\u7406\u8bc6\u522b\u7ed3\u679c\u5e8f\u5217\u5316\u5bf9\u8c61:" + resultJson);
            try {
                recognizeDetail = (ReceiptRecongnizeDetail)SerializationUtils.fromJsonString((String)resultJson, ReceiptRecongnizeDetail.class);
            }
            catch (Exception e) {
                logger.warn("\u7535\u5b50\u56de\u5355\u8bc6\u522b -- \u4e8c\u5f00\u5904\u7406\u8bc6\u522b\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        return recognizeDetail;
    }

    private void ocrResultCurrencyProcess(ReceiptRecongnizeDetail recognizeDetail) {
        String fcurrency = recognizeDetail.getFcurrency();
        String ftradeType = recognizeDetail.getFtradeType();
        if (EmptyUtil.isEmpty((String)fcurrency) && EmptyUtil.isNoEmpty((String)ftradeType)) {
            String bankAcctNum = LendingDirectionEnum.IN.getDirect().equals(ftradeType) ? recognizeDetail.getFpayeeAccount() : recognizeDetail.getFpaymentAccount();
            DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)bankAcctNum)});
            if (EmptyUtil.isEmpty((DynamicObject)acct)) {
                return;
            }
            DynamicObjectCollection currency = acct.getDynamicObjectCollection("currency");
            if (currency != null && !currency.isEmpty()) {
                if (currency.size() == 1) {
                    String currencyNum = ((DynamicObject)currency.get(0)).getString("fbasedataid.number");
                    recognizeDetail.setFcurrency(currencyNum);
                } else {
                    DynamicObject defaultCurrency = acct.getDynamicObject("defaultcurrency");
                    if (EmptyUtil.isNoEmpty((DynamicObject)defaultCurrency)) {
                        recognizeDetail.setFcurrency(defaultCurrency.getString("number"));
                    }
                }
            }
        }
    }

    private static /* synthetic */ String lambda$dealOcrResultExt$0(String toJsonString, IAfterReceiptRecognition p) {
        return p.fillRecognitionResult(toJsonString);
    }
}

