/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.ocr.impl.ScanServiceImpl;
import kd.tmc.bei.business.ocr.invoke.ScanSystemFactory;
import kd.tmc.bei.common.helper.ReceiptPrintHelper;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.ofd.OfdConvertUtil;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceiptPrintNewPlugin
extends AbstractPrintPlugin {
    private static final Log logger = LogFactory.getLog(ReceiptPrintNewPlugin.class);
    private static final String SOURCE_TAG = "EleReceipt";
    private static final String USERNAME = "username";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        DataRowSet mainDataRow = dataSource.getMainDataRow();
        Long receiptId = (Long)mainDataRow.getField("id").getValue();
        DynamicObject receipt = QueryServiceHelper.queryOne((String)"bei_elecreceipt", (String)"id, billno, company.name, fileflag, username, uploadfilename, fileserverurl", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)receiptId)});
        String receiptUrlError = new BeiBizResource().getGetEreceipturlError();
        if (EmptyUtil.isEmpty((DynamicObject)receipt)) {
            throw new KDBizException(receiptUrlError);
        }
        List customDataRows = evt.getCustomDataRows();
        List queryField = dataSource.getQueryField();
        if (!SOURCE_TAG.equals(dataSource.getDsName())) return;
        if (!queryField.isEmpty()) {
            List<String> uploadPathList;
            String pngField = (String)queryField.get(0);
            Boolean fileFlag = receipt.getBoolean("fileflag");
            if (!Boolean.TRUE.equals(fileFlag)) return;
            String uploadFileName = ReceiptPrintHelper.getRealUploadUrl((DynamicObject)receipt);
            if (StringUtils.isBlank((CharSequence)uploadFileName)) {
                logger.error(receiptUrlError);
                throw new KDBizException(receiptUrlError);
            }
            String fileServerUrl = receipt.getString("fileserverurl");
            String fileUrl = !EmptyUtil.isEmpty((String)fileServerUrl) ? fileServerUrl : uploadFileName;
            if (fileUrl.isEmpty()) throw new KDBizException(receiptUrlError);
            if (!EmptyUtil.isEmpty((String)fileServerUrl)) {
                Long userId = RequestContext.get().getCurrUserId();
                DynamicObjectCollection userObj = QueryServiceHelper.query((String)"bos_user", (String)"id,phone", (QFilter[])new QFilter("id", "=", (Object)userId).toArray());
                DynamicObjectCollection configObj = QueryServiceHelper.query((String)"bas_imageconfig", (String)"imageurl,clientid,clientsecret", (QFilter[])new QFilter("enable", "=", (Object)"A").toArray());
                ScanSystemFactory.getScanService();
                InputStream image = ScanServiceImpl.getImage((String)((DynamicObject)configObj.get(0)).getString("clientid"), (String)((DynamicObject)configObj.get(0)).getString("clientsecret"), (String)((DynamicObject)configObj.get(0)).getString("imageurl"), (String)((DynamicObject)userObj.get(0)).getString("phone"), (String)fileServerUrl);
                fileUrl = this.getCurrentPath("receipt.png", image);
            } else if (fileUrl.endsWith("pdf") || fileUrl.endsWith("PDF")) {
                logger.info("pdfReceipt Url\uff1a" + uploadFileName);
                uploadPathList = this.fillCurrentPath(null, fileUrl, "pdf");
                fileUrl = uploadPathList.stream().findFirst().orElse("");
            } else if (uploadFileName.endsWith("ofd") || uploadFileName.endsWith("OFD")) {
                logger.info("ofdReceipt url\uff1a" + uploadFileName);
                try {
                    byte[] bytes = OfdConvertUtil.convertToPdfNew((byte[])this.getPdfPutStream(uploadFileName));
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                    List<String> uploadPathList2 = this.fillCurrentPath(inputStream, null, "pdf");
                    fileUrl = uploadPathList2.stream().findFirst().orElse("");
                }
                catch (Exception e) {
                    logger.error("ofdConvert2Pdf Fail: " + uploadFileName + " " + e.getMessage());
                }
            } else {
                logger.info("FileReceipt url\uff1a" + uploadFileName);
                uploadPathList = this.fillCurrentPath(null, fileUrl, "image");
                fileUrl = uploadPathList.stream().findFirst().orElse("");
            }
            if (EmptyUtil.isEmpty((String)fileUrl)) {
                logger.warn(receipt.getString("billno") + " fileUrl after convert is empty.");
                return;
            }
            DataRowSet rowSet = new DataRowSet();
            rowSet.put(pngField, (Field)new ImageField(fileUrl));
            customDataRows.add(rowSet);
            return;
        } else {
            logger.error(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6570\u636e\u6e90EleReceipt\u4e2d\u672a\u914d\u7f6e\u5b57\u6bb5\u3002", (String)"ReceiptPrintNewPlugin_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        }
    }

    private List<String> fillCurrentPath(InputStream inputStream, String fileUrl, String fileType) {
        ArrayList<String> uploadPathList = new ArrayList<String>(4);
        try {
            List imagePages = EmptyUtil.isNoEmpty((String)fileUrl) ? ReceiptPrintHelper.pdfToPng(null, (String)fileUrl, (String)fileType) : ReceiptPrintHelper.pdfToPng((InputStream)inputStream, null, (String)fileType);
            for (int i = 0; i < imagePages.size(); ++i) {
                byte[] image = (byte[])imagePages.get(i);
                uploadPathList.add(this.getCurrentPath("receipt" + i + ".png", new ByteArrayInputStream(image)));
            }
        }
        catch (Exception e) {
            logger.error("pdfToPng Exception: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(new BeiBizResource().getReceiptDownloadError());
        }
        return uploadPathList;
    }

    private byte[] getPdfPutStream(String sourceUrl) throws IOException {
        int len;
        FileService fs = FileServiceFactory.getAttachmentFileService();
        InputStream ins = fs.getInputStream(sourceUrl);
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = ins.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        ins.close();
        if (bos.toString().contains("file is not exist")) {
            return new byte[0];
        }
        return bos.toByteArray();
    }

    private String getCurrentPath(String pngSuffixName, InputStream inputStream) {
        String imagePath;
        String pngStoreRoute = ReceiptPrintHelper.generateUploadPath((String)pngSuffixName);
        if (inputStream == null) {
            logger.error("ReceiptPrintNewPlugin uploadPngToServer Fail: fileStream is Empty.");
            imagePath = "";
        } else {
            imagePath = ReceiptPrintHelper.uploadPngToServer((String)pngSuffixName, (String)pngStoreRoute, (InputStream)inputStream);
        }
        if (StringUtils.isBlank((CharSequence)imagePath)) {
            logger.error("ReceiptPrintNewPlugin uploadPngToServer Fail: {}", (Object)pngStoreRoute);
        }
        String currentPath = FileServiceExtFactory.getImageFileServiceExt().getRealPath("/" + imagePath);
        logger.info("ReceiptPrintNewPlugin pngCurrentPath: {}", (Object)currentPath);
        return currentPath;
    }
}

