/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.enums.ReceiptQueryTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceiptQuerySchemeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String CONDITION = "condition";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"queryfilter", "addcard", "addimg", "addlabel", "modifilap", "deletetlap"});
        BasedataEdit bizApp = (BasedataEdit)this.getControl("bizappid");
        bizApp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sourceBill = (BasedataEdit)this.getControl("sourcebill");
        sourceBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property;
        switch (property = e.getProperty().getName()) {
            case "sourcebill": {
                this.getModel().setValue("queryfilter", null);
                this.getModel().deleteEntryData("linkentry");
                break;
            }
            case "bizappid": {
                this.getModel().setValue("sourcebill", null);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String proKey;
        Control source = (Control)evt.getSource();
        switch (proKey = source.getKey()) {
            case "queryfilter": {
                DynamicObject sourceBill = (DynamicObject)this.getModel().getValue("sourcebill");
                if (EmptyUtil.isEmpty((DynamicObject)sourceBill)) {
                    TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"sourcebill");
                    break;
                }
                this.showQueryFilter();
                break;
            }
            case "addcard": 
            case "addimg": 
            case "addlabel": {
                if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"sourcebill")) break;
                this.showQueryLink("addcard");
                break;
            }
            case "modifilap": {
                this.showQueryLink("modifilap");
                break;
            }
            case "deletetlap": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8282\u70b9\u4f1a\u628a\u540e\u7eed\u94fe\u8def\u8282\u70b9\u4e00\u5e76\u5220\u9664\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"ReceiptQuerySchemeEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("deletetlap", (IFormPlugin)this));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (EmptyUtil.isEmpty((Object)returnData)) {
            return;
        }
        switch (actionId) {
            case "addcard": {
                int index = this.getModel().createNewEntryRow("linkentry");
                this.setQueryLink(returnData, index);
                break;
            }
            case "queryfilter": {
                this.getModel().setValue("queryfilter", returnData.get("name"));
                this.getModel().setValue("filtercondition", returnData.get(CONDITION));
                break;
            }
            case "modifilap": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("linkentry");
                this.setQueryLink(returnData, rowIndex);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (key) {
            case "sourcebill": {
                if (TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"bizappid")) {
                    QFilter qFilter = new QFilter("bizappid", "=", ((DynamicObject)this.getModel().getValue("bizappid")).getPkValue());
                    qFilter.and("modeltype", "=", (Object)"BillFormModel");
                    List fundBillTypes = QueryServiceHelper.query((String)"bei_fundbilltype", (String)"id, number", (QFilter[])new QFilter[0]).stream().map(o -> o.getString("number")).collect(Collectors.toList());
                    qFilter.and("number", "not in", fundBillTypes);
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                    break;
                }
                beforeF7SelectEvent.setCancel(true);
                break;
            }
            case "bizappid": {
                showParameter.getCustomParams().put("onlydeployed", Boolean.FALSE);
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", "not like", (Object)"%ext%"));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("deletetlap".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            int focusRow = this.getModel().getEntryCurrentRowIndex("linkentry");
            int rowCount = this.getModel().getEntryRowCount("linkentry");
            int[] deleteArr = new int[rowCount - focusRow];
            for (int i = focusRow; i < rowCount; ++i) {
                deleteArr[i - focusRow] = i;
            }
            this.getModel().deleteEntryRows("linkentry", deleteArr);
        }
    }

    private void showQueryFilter() {
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue("sourcebill");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bei_receiptqueryfilter");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "queryfilter"));
        showParameter.getShowParameter().setCustomParam("formid", (Object)sourceBill.getString("number"));
        String filterName = (String)this.getModel().getValue("queryfilter");
        if (!EmptyUtil.isEmpty((String)filterName)) {
            Object condition = this.getModel().getValue("filtercondition");
            showParameter.getShowParameter().setCustomParam("name", (Object)filterName);
            showParameter.getShowParameter().setCustomParam(CONDITION, condition);
        }
        this.getView().showForm(showParameter);
    }

    private void showQueryLink(String actionId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bei_receiptquerylink");
        if ("addcard".equals(actionId)) {
            DynamicObject sourceBill;
            DynamicObject bizApp;
            int entryRowCount = this.getModel().getEntryRowCount("linkentry");
            if (entryRowCount > 0) {
                bizApp = (DynamicObject)this.getModel().getValue("targetbillapp", entryRowCount - 1);
                sourceBill = (DynamicObject)this.getModel().getValue("targetbillname", entryRowCount - 1);
            } else {
                bizApp = (DynamicObject)this.getModel().getValue("bizappid");
                sourceBill = (DynamicObject)this.getModel().getValue("sourcebill");
            }
            parameter.setCustomParam("isTail", (Object)true);
            parameter.setCustomParam("sourcebillname", EmptyUtil.isNoEmpty((DynamicObject)sourceBill) ? sourceBill.getString("id") : null);
            parameter.setCustomParam("sourcebillapp", EmptyUtil.isNoEmpty((DynamicObject)bizApp) ? bizApp.getString("id") : null);
        } else if ("modifilap".equals(actionId)) {
            int rowCount;
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("linkentry");
            parameter.setCustomParam("isTail", (Object)(currentRowIndex == (rowCount = this.getModel().getEntryRowCount("linkentry")) - 1 ? 1 : 0));
            DynamicObject bizApp = (DynamicObject)this.getModel().getValue("sourcebillapp", currentRowIndex);
            DynamicObject sourceBill = (DynamicObject)this.getModel().getValue("sourcebillname", currentRowIndex);
            DynamicObject targetBillApp = (DynamicObject)this.getModel().getValue("targetbillapp", currentRowIndex);
            DynamicObject targetBill = (DynamicObject)this.getModel().getValue("targetbillname", currentRowIndex);
            parameter.setCustomParam("sourcebillname", EmptyUtil.isNoEmpty((DynamicObject)sourceBill) ? sourceBill.getString("id") : null);
            parameter.setCustomParam("sourcebillapp", EmptyUtil.isNoEmpty((DynamicObject)bizApp) ? bizApp.getString("id") : null);
            parameter.setCustomParam("targetbillname", EmptyUtil.isNoEmpty((DynamicObject)targetBill) ? targetBill.getString("id") : null);
            parameter.setCustomParam("targetbillapp", EmptyUtil.isNoEmpty((DynamicObject)targetBillApp) ? targetBillApp.getString("id") : null);
            parameter.setCustomParam("queryrule", (Object)ReceiptQueryTypeEnum.getValue((String)((String)this.getModel().getValue("queryrule", currentRowIndex))));
            parameter.setCustomParam("sourcequeryfield", this.getModel().getValue("sourcequeryfield", currentRowIndex));
            parameter.setCustomParam("targetqueryfield", this.getModel().getValue("targetqueryfield", currentRowIndex));
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    private void setQueryLink(Map<String, Object> returnData, int index) {
        DynamicObject sourceBillApp = (DynamicObject)returnData.get("sourcebillapp");
        DynamicObject sourceBill = (DynamicObject)returnData.get("sourcebillname");
        DynamicObject targetBillApp = (DynamicObject)returnData.get("targetbillapp");
        DynamicObject targetBill = (DynamicObject)returnData.get("targetbillname");
        this.getModel().setValue("linkname", (Object)(sourceBill.getString("name") + " >> " + targetBill.getString("name")), index);
        this.getModel().setValue("sourcebillapp", (Object)sourceBillApp, index);
        this.getModel().setValue("sourcebillname", (Object)sourceBill.getString("number"), index);
        this.getModel().setValue("targetbillapp", (Object)targetBillApp, index);
        this.getModel().setValue("targetbillname", (Object)targetBill.getString("number"), index);
        String queryRule = (String)returnData.get("queryrule");
        this.getModel().setValue("queryrule", (Object)ReceiptQueryTypeEnum.getName((String)queryRule), index);
        if ("botp".equals(queryRule)) {
            this.getModel().setValue("sourcequeryfield", null, index);
            this.getModel().setValue("targetqueryfield", null, index);
        } else {
            this.getModel().setValue("sourcequeryfield", returnData.get("sourcequeryfield"), index);
            this.getModel().setValue("targetqueryfield", returnData.get("targetqueryfield"), index);
        }
    }
}

