/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.elec;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.bei.business.bean.AccountPredictDateResult;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import org.apache.commons.lang3.StringUtils;

public class SyncElecEdit
extends AbstractTmcBillEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
    }

    private void initF7() {
        this.fillAcctBank();
    }

    private void fillAcctBank() {
        BasedataEdit acctbankF7 = (BasedataEdit)this.getControl("accountbank");
        acctbankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("issetbankinterface", "=", (Object)"1");
            String appId = this.getView().getFormShowParameter().getAppId();
            List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"bei_elecreceipt", (String)"47150e89000000ac");
            qFilter.and(new QFilter("company", "in", (Object)authOrgList));
            qFilter.and(new QFilter("acctstatus", "=", (Object)"normal"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String startStr = (String)parameter.getCustomParam("startdate");
        Date startdate = EmptyUtil.isNoEmpty((String)startStr) ? DateUtils.stringToDate((String)startStr, (String)"yyyy-MM-dd") : DateUtils.getLastDay((Date)new Date(), (int)1);
        String endStr = (String)parameter.getCustomParam("enddate");
        Date enddate = EmptyUtil.isNoEmpty((String)endStr) ? DateUtils.stringToDate((String)endStr, (String)"yyyy-MM-dd") : DateUtils.getLastDay((Date)new Date(), (int)1);
        String accountBanks = (String)parameter.getCustomParam("accountbank");
        this.getModel().setValue("startdate", (Object)startdate);
        this.getModel().setValue("enddate", (Object)enddate);
        if (EmptyUtil.isNoEmpty((String)accountBanks)) {
            this.getModel().setValue("accountbank", (Object)new String[]{accountBanks});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("sync".equals(key)) {
            Date enddate;
            DynamicObjectCollection accountbanks = (DynamicObjectCollection)this.getModel().getValue("accountbank");
            List accId = accountbanks.stream().map(o -> o.get("fbasedataid_id")).collect(Collectors.toList());
            Date startdate = (Date)this.getModel().getValue("startdate");
            if (startdate.after(enddate = (Date)this.getModel().getValue("enddate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u9700\u8981\u5927\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"SyncElecEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (enddate.after(new Date())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7cfb\u7edf\u5f53\u524d\u65e5\u671f\u3002", (String)"SyncElecEdit_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<DynamicObject> accountList = accountbanks.stream().map(t -> t.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            if (this.checkAllAccountPermit(startdate, enddate, accountList)) {
                args.setCancel(true);
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("close", "close");
            map.put("startdate", startdate);
            map.put("enddate", enddate);
            map.put("accId", accId);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private boolean checkAllAccountPermit(Date startDate, Date endDate, List<DynamicObject> accountBanks) {
        List resultList = AccountBankHelper.computerByAcctBanks((String)BankFuncEnum.RECEIPT.getValue(), accountBanks, (Date)startDate, (Date)endDate);
        List permitList = resultList.stream().filter(AccountPredictDateResult::isPermit).map(t -> t.getAccountBank().getString("bankaccountnumber")).collect(Collectors.toList());
        if (!EmptyUtil.isEmpty(permitList)) {
            if (accountBanks.size() == permitList.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s\u8bbe\u7f6e\u7684\u67e5\u8be2\u9884\u8ba1\u5f00\u901a\u65e5\u671f\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u4e0d\u80fd\u8054\u673a\u67e5\u8be2\u7535\u5b50\u56de\u5355\u3002", (String)"SyncElecEdit_2", (String)"tmc-bei-formplugin", (Object[])new Object[]{StringUtils.join(permitList, (String)"\u3001")}), Integer.valueOf(3000));
                return true;
            }
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\uff1a%s\u8bbe\u7f6e\u7684\u67e5\u8be2\u9884\u8ba1\u5f00\u901a\u65e5\u671f\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u4e0d\u80fd\u8054\u673a\u67e5\u8be2\u7535\u5b50\u56de\u5355\u3002", (String)"SyncElecEdit_2", (String)"tmc-bei-formplugin", (Object[])new Object[]{StringUtils.join(permitList, (String)"\u3001")}), Integer.valueOf(3000));
        }
        return false;
    }
}

