/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.home;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.helper.BalanceCheckErrorHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class DetailCorrectWarnCardPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ORG = "org";
    private static final String DATE = "date";
    private static final String BTN_REFRESH = "refresh";
    private static final String ENTRY = "entry";
    private static final String COMPANY = "company";
    private static final String BANKACCOUNT_NUMBER = "bankaccountnumber";
    private static final String CURRENCY = "currency";
    private static final String BIZDATE = "bizdate";
    private static final String CHECKRESULT = "checkresult";
    private static final String CHECKRESULT_DESC = "checkresultdesc";
    private static final String RECORDID = "recordid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_REFRESH});
        BasedataEdit compview = (BasedataEdit)this.getControl(ORG);
        compview.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.drawChart();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "refresh": {
                this.drawChart();
                break;
            }
            case "piechartap": {
                String name = ((ChartClickEvent)evt).getName();
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId("bei_missingreord");
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.addCustPlugin("kd.tmc.bei.formplugin.home.MissRecordListClickShowPlugin");
                DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue(ORG);
                List orgid = org.stream().map(o -> o.get("fbasedataid.id")).collect(Collectors.toList());
                String range = (String)this.getModel().getValue(DATE);
                listShowParameter.getCustomParams().put(ORG, orgid);
                listShowParameter.getCustomParams().put(DATE, range);
                if (this.getMissName().equals(name)) {
                    listShowParameter.getCustomParams().put(CHECKRESULT, "M");
                    this.getView().showForm((FormShowParameter)listShowParameter);
                    break;
                }
                if (!this.getNoMissName().equals(name)) break;
                listShowParameter.getCustomParams().put(CHECKRESULT, "C");
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey;
        switch (propKey = e.getProperty().getName()) {
            case "org": 
            case "date": {
                this.drawChart();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propName = event.getProperty().getName();
        if (ORG.equals(propName)) {
            List orgid = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)TmcAppEnum.BEI.getId(), (String)"bei_missingreord", (String)"47150e89000000ac");
            QFilter qFilter = new QFilter("id", "in", (Object)orgid);
            ListShowParameter sp = (ListShowParameter)event.getFormShowParameter();
            sp.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("showdetail".equals(operateKey)) {
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY);
            DynamicObject row = (DynamicObject)entryEntity.get(focusRow);
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("bei_missingreord");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPkId((Object)row.getLong(RECORDID));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void drawChart() {
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue(ORG);
        Pair<Date, Date> date = this.getDateRange();
        List orgid = EmptyUtil.isNoEmpty((DynamicObjectCollection)org) ? org.stream().map(o -> o.get("fbasedataid.id")).collect(Collectors.toList()) : TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)TmcAppEnum.BEI.getId(), (String)"bei_missingreord", (String)"47150e89000000ac");
        QFilter qFilter = new QFilter(COMPANY, "in", (Object)orgid).and(BIZDATE, ">=", date.getLeft()).and(BIZDATE, "<=", date.getRight()).and("checktype", "=", (Object)"B");
        DynamicObjectCollection records = QueryServiceHelper.query((String)"bei_missingreord", (String)"id recordid,company.id company,accountbank.bankaccountnumber bankaccountnumber,currency.id currency,bizdate,checkresult,correcttype,checkresultdesc", (QFilter[])new QFilter[]{qFilter});
        BalanceCheckErrorHelper.setLangCheckDesc((DynamicObjectCollection)records);
        this.setEntry(records);
        this.drawPieChart(records);
    }

    private void setEntry(DynamicObjectCollection records) {
        this.getModel().deleteEntryData(ENTRY);
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(COMPANY, new Object[0]);
        vs.addField(BANKACCOUNT_NUMBER, new Object[0]);
        vs.addField(CURRENCY, new Object[0]);
        vs.addField(BIZDATE, new Object[0]);
        vs.addField(CHECKRESULT, new Object[0]);
        vs.addField(CHECKRESULT_DESC, new Object[0]);
        vs.addField(RECORDID, new Object[0]);
        records.stream().filter(r -> "M".equals(r.getString(CHECKRESULT))).forEach(r -> vs.addRow(new Object[]{r.getLong(COMPANY), r.getString(BANKACCOUNT_NUMBER), r.getLong(CURRENCY), r.getDate(BIZDATE), r.getString(CHECKRESULT), r.getString(CHECKRESULT_DESC), r.getLong(RECORDID)}));
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow(ENTRY, vs);
        dataModel.endInit();
        this.getView().updateView(ENTRY);
    }

    private void drawPieChart(DynamicObjectCollection records) {
        int missCount = (int)records.stream().filter(r -> "M".equals(r.getString(CHECKRESULT))).count();
        int allCount = records.size();
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.createSeries("bei_missingreord");
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(false);
        int noMissCount = allCount - missCount;
        long rate = allCount == 0 ? 0L : BigDecimal.valueOf(noMissCount).divide(BigDecimal.valueOf(allCount), 3, 4).movePointRight(2).setScale(0, 1).longValue();
        pieChart.setTitlePropValue("text", (Object)(rate + "%"));
        pieChart.setTitlePropValue("top", (Object)"center");
        pieChart.setTitlePropValue("left", (Object)"center");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("color", "#000000");
        map.put("fontSize", 40);
        map.put("fontWeight", "normal");
        pieChart.setTitlePropValue("textStyle", map);
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u5b8c\u6574\u7387", (String)"DetailCorrectWarnCardPlugin_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
        ItemValue[] data = new ItemValue[2];
        ItemValue data1 = new ItemValue(this.getNoMissName(), (Number)noMissCount, "#276ff5");
        ItemValue data2 = new ItemValue(this.getMissName(), (Number)missCount, "#ff991c");
        data[0] = data1;
        data[1] = data2;
        HashMap<String, Boolean> label = new HashMap<String, Boolean>(4);
        label.put("show", false);
        series.setPropValue("label", label);
        series.setRadius("50%", "70%");
        series.setCenter("50%", "50%");
        series.setData(data);
        pieChart.refresh();
    }

    private Pair<Date, Date> getDateRange() {
        String range;
        Date curtime = new Date();
        switch (range = (String)this.getModel().getValue(DATE)) {
            case "11": {
                return Pair.of((Object)DateUtils.getDataFormat((Date)DateUtils.getLastDay((Date)curtime, (int)1), (boolean)true), (Object)DateUtils.truncateDate((Date)curtime));
            }
            case "13": {
                return Pair.of((Object)DateUtils.truncateDate((Date)curtime), (Object)curtime);
            }
            case "10": {
                return Pair.of((Object)DateUtils.getFirstDayOfWeek((Date)DateUtils.truncateDate((Date)curtime)), (Object)curtime);
            }
            case "63": {
                return Pair.of((Object)DateUtils.getFirstDayOfMonth((Date)curtime), (Object)curtime);
            }
        }
        return Pair.of((Object)DateUtils.getDataFormat((Date)DateUtils.getLastDay((Date)curtime, (int)1), (boolean)true), (Object)DateUtils.truncateDate((Date)curtime));
    }

    private String getNoMissName() {
        return ResManager.loadKDString((String)"\u5b8c\u6574\u8bb0\u5f55", (String)"DetailCorrectWarnCardPlugin_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
    }

    private String getMissName() {
        return ResManager.loadKDString((String)"\u7f3a\u5931\u8bb0\u5f55", (String)"DetailCorrectWarnCardPlugin_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
    }
}

