/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.missing;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.mvc.list.ListDataProvider;
import kd.tmc.bei.business.helper.BalanceCheckErrorHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import org.apache.commons.lang3.StringUtils;

public class MissingRecordList
extends AbstractTmcBillBaseList {
    private static final String BTN_LOG = "btn_log";
    private static final String LOG_FORM = "bei_missinglog";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection list = super.getData(start, limit);
                BalanceCheckErrorHelper.setLangCheckDesc((DynamicObjectCollection)list);
                return list;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"completecheck", "missingrepair"})) {
            this.getView().invokeOperation("refresh");
        } else if ("querylog".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.showRecordLogForm(this.getSelectedId());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Long selectedId;
        super.beforeItemClick(evt);
        if (BTN_LOG.equals(evt.getItemKey()) && Objects.isNull(selectedId = this.getSelectedId())) {
            evt.setCancel(true);
            return;
        }
    }

    private void showRecordLogForm(Long missingId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(LOG_FORM);
        showParameter.setCustomParam("missingId", (Object)missingId);
        this.getView().showForm(showParameter);
    }
}

