/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.online;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.bei.business.bean.AccountPredictDateResult;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.business.opservice.elec.ViewReceiptService;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.dync.AbstractTmcDyncListPlugin;

public class OnlineQueryPlugin
extends AbstractTmcDyncListPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(OnlineQueryPlugin.class);
    protected FilterContainerInitArgs initArgs;
    private static final String CACHE_SELECT_FAV = "SELECT_FAV";

    public void filterContainerInit(FilterContainerInitEvent event) {
        this.initArgs = new FilterContainerInitArgs(event);
        if (this.getPageCache().get("isFirstInit") == null) {
            this.getPageCache().put("isFirstInit", "true");
            this.fillPageData();
            this.getView().addClientCallBack("refreshcurrecny");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button favoriteMore = (Button)this.getControl("favoritemore");
        favoriteMore.addClickListener((ClickListener)this);
        Button favoriteAdd = (Button)this.getControl("addfavorite");
        favoriteAdd.addClickListener((ClickListener)this);
        Button favoriteDel = (Button)this.getControl("delfavorite");
        favoriteDel.addClickListener((ClickListener)this);
        CardEntry cardEntry = (CardEntry)this.getControl("favoriteentry");
        cardEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initFavoriteList();
    }

    private List<DynamicObject> getUserFavoriteList() {
        List<Object> collect = new ArrayList<DynamicObject>(16);
        QFilter[] filters = new QFilter[]{new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()), new QFilter("accountbank.issetbankinterface", "=", (Object)"1"), new QFilter("accountbank.bank.finorgtype.number", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getNumber()), VisibleVirtualAcctHelper.notVirtualAcctQfTOBankJournal()};
        Map favMap = TmcDataServiceHelper.loadFromCache((String)"bei_account_favorite", (QFilter[])filters);
        if (!favMap.isEmpty()) {
            Map bankMap = TmcDataServiceHelper.loadFromCache((Object[])favMap.values().stream().map(t -> t.getLong("accountbank.id")).distinct().toArray(), (String)"bd_accountbanks");
            collect = favMap.values().stream().filter(t -> Optional.ofNullable(bankMap.get(t.getLong("accountbank.id"))).map(at -> at.getDynamicObjectCollection("currency").stream().map(w -> w.getLong("fbasedataid.id")).anyMatch(x -> x.equals(t.getLong("currency.id")))).orElse(Boolean.FALSE)).collect(Collectors.toList());
            collect.sort(Collections.reverseOrder(Comparator.comparing(s -> s.getDate("modifytime"))));
        }
        return collect;
    }

    private void initFavoriteList() {
        List<DynamicObject> favoriteList = this.getUserFavoriteList();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("favoriteentry");
        if (EmptyUtil.isNoEmpty(favoriteList)) {
            model.beginInit();
            List<DynamicObject> list = favoriteList.size() > 7 ? favoriteList.subList(0, 7) : favoriteList;
            TableValueSetter setter = new TableValueSetter(new String[0]);
            Object[] accountArr = list.stream().map(t -> t.getLong("accountbank.bank.id")).toArray();
            Map accountMap = TmcDataServiceHelper.loadFromCache((Object[])accountArr, (String)"bd_finorginfo");
            Object[] favNames = list.stream().map(t -> this.makeFavoriteName((DynamicObject)t, (DynamicObject)accountMap.get(t.getLong("accountbank.bank.id")))).toArray(Object[]::new);
            setter.addField("favoritename", favNames);
            setter.addField("favorite", list.stream().map(DataEntityBase::getPkValue).toArray());
            model.batchCreateNewEntryRow("favoriteentry", setter);
            model.endInit();
        }
        this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty(favoriteList)), new String[]{"favoriteentry"});
        this.getView().updateView("favoriteentry");
        this.getView().setVisible(Boolean.valueOf(favoriteList.size() > 7), new String[]{"favoritemore"});
    }

    private String makeFavoriteName(DynamicObject favorite, DynamicObject finOrg) {
        String cateName = FinOrgTypeEnum.BANK.getNumber().equals(finOrg.getString("finorgtype.number")) ? finOrg.getString("bank_cate.name") : finOrg.getString("name");
        String bankNumber = favorite.getString("accountbank.bankaccountnumber");
        cateName = cateName.length() > 4 ? "..." + cateName.substring(cateName.length() - 4) : cateName;
        bankNumber = bankNumber.length() > 8 ? bankNumber.substring(0, 4) + "..." + bankNumber.substring(bankNumber.length() - 4) : bankNumber;
        return cateName + " | " + bankNumber + " | " + favorite.getString("currency.number");
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String name = e.getName();
        if ("refreshcurrecny".equals(name)) {
            this.fillPageData();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if ("refresh".equals(opKey)) {
            this.fillPageData();
        } else if ("transdetail".equals(opKey)) {
            this.checkPredictDate(args);
        } else if ("receipt".equals(opKey)) {
            String receiptNo = this.getModel().getEntryRowEntity("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity")).getString("receiptno");
            formOperate.getOption().setVariableValue("receiptNo", receiptNo);
        }
    }

    private void checkPredictDate(BeforeDoOperationEventArgs args) {
        Date currentDate = DateUtils.getCurrentDate();
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        if (EmptyUtil.isEmpty((DynamicObject)company) || EmptyUtil.isEmpty((DynamicObject)accountBank)) {
            return;
        }
        AccountPredictDateResult result = AccountBankHelper.computer((String)BankFuncEnum.QUERY.getValue(), (long)company.getLong("id"), (long)accountBank.getLong("id"), (Date)currentDate, (Date)currentDate);
        if (result.isPermit()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u8d26\u6237\u8bbe\u7f6e\u7684\u67e5\u8be2\u9884\u8ba1\u5f00\u901a\u65e5\u671f\u4e3a%s\uff0c\u4e0d\u5141\u8bb8\u8054\u673a\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u3002", (String)"OnlineQueryPlugin_0", (String)"tmc-bei-formplugin", (Object[])new Object[]{DateUtils.formatString((Date)result.getPredictDate(), (String)"yyyy-MM-dd")}));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (("onlinequery".equals(args.getOperateKey()) || "transdetail".equals(args.getOperateKey()) || "batchbalance".equals(args.getOperateKey())) && args.getOperationResult().isSuccess()) {
            this.fillPageData();
        }
        if ("receipt".equals(args.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            String elecReceiptId = args.getOperationResult().getMessage();
            ArrayList<String> pkList = new ArrayList<String>();
            pkList.add(elecReceiptId);
            ViewReceiptService service = new ViewReceiptService();
            service.openReceiptById(this.getView(), pkList.toArray());
        }
    }

    public void filterSearchClickEvent(SearchClickEvent event) {
        CardEntry favoriteCard = (CardEntry)this.getControl("favoriteentry");
        favoriteCard.selectCard(Integer.valueOf(-1));
        this.setSelectFavFontColor(-1);
        this.fillPageData();
    }

    public void fillPageData() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List qFilters = this.getQFilterFromPagCache();
        if (null == qFilters || qFilters.size() == 0) {
            return;
        }
        Long currency = null;
        Long bankid = 0L;
        Long accountBankid = null;
        Long orgid = 0L;
        for (QFilter qfilter : qFilters) {
            if ("bank.id".equals(qfilter.getProperty())) {
                List financialTypeIdFilter = qFilters.stream().filter(e -> "financialtype.id".equals(e.getProperty())).collect(Collectors.toList());
                if (financialTypeIdFilter.size() > 0 && "615763944224700416".equals(((QFilter)financialTypeIdFilter.get(0)).getValue().toString())) {
                    qfilter.__setProperty("bank.bank_cate.id");
                }
                accountBankid = Long.valueOf(qfilter.getValue().toString());
            }
            if ("currency.id".equals(qfilter.getProperty())) {
                currency = Long.valueOf(qfilter.getValue().toString());
            }
            if ("accountbank.id".equals(qfilter.getProperty())) {
                bankid = Long.valueOf(qfilter.getValue().toString());
            }
            if (!"company.id".equals(qfilter.getProperty())) continue;
            orgid = Long.valueOf(qfilter.getValue().toString());
        }
        qFilters.removeIf(t -> "financialtype.id".equals(t.getProperty()));
        qFilters.add(new QFilter("bank.finorgtype.number", "!=", (Object)"FI-015"));
        String balanceSelectField = "accountbank,accountbank.bank,accountbank.bank.name,accountbank.bank.logo,company,accountbank.bankaccountnumber,currency,modifytime,bizdate,amount,valibalance,lstbalance,bank.bank_cate,bank.logo,accountbank.currency,bank";
        String detailSelectField = "id,bizdate,biztime,description,creditamount,debitamount,transbalance,oppunit,oppbanknumber,oppbank,modifytime,accountbank.bank.id,sortno,receiptno,sortid";
        try (DataSet bankbalanceDataSet = QueryServiceHelper.queryDataSet((String)"initEntity()", (String)"bei_bankbalance", (String)balanceSelectField, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"bizdate ASC");
             DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)"initEntity()", (String)"bei_transdetail", (String)detailSelectField, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"biztime,sortid DESC,sortno ASC");){
            model.deleteEntryData("entryentity");
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("id", new Object[0]);
            vs.addField("biztime", new Object[0]);
            vs.addField("description", new Object[0]);
            vs.addField("creditamount", new Object[0]);
            vs.addField("debitamount", new Object[0]);
            vs.addField("transbalance", new Object[0]);
            vs.addField("oppunit", new Object[0]);
            vs.addField("oppbanknumber", new Object[0]);
            vs.addField("oppbank", new Object[0]);
            vs.addField("updatetime", new Object[0]);
            vs.addField("receiptno", new Object[0]);
            for (Row row : detailDataSet) {
                vs.addRow(new Object[]{row.get("id"), row.get("biztime"), row.get("description"), row.get("creditamount"), row.get("debitamount"), row.get("transbalance"), row.get("oppunit"), row.get("oppbanknumber"), row.get("oppbank"), row.get("modifytime"), row.get("receiptno")});
            }
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
            Iterator bb = bankbalanceDataSet.iterator();
            Row row = null;
            DynamicObjectCollection bankNumbers = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber,bank.id,bank.logo", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bankid)});
            String bankLogo = "";
            Long accountbank = null;
            if (bankNumbers.size() > 0) {
                accountbank = ((DynamicObject)bankNumbers.get(0)).getLong("id");
                accountBankid = ((DynamicObject)bankNumbers.get(0)).get("bank.id") == null ? Long.valueOf(0L) : ((DynamicObject)bankNumbers.get(0)).get("bank.id");
                bankLogo = ((DynamicObject)bankNumbers.get(0)).getString("bank.logo");
            }
            if (bb.hasNext()) {
                row = (Row)bb.next();
            }
            this.getModel().setValue("bank", row == null ? accountBankid : row.get("bank"));
            bankLogo = row == null ? bankLogo : row.getString("bank.logo");
            this.getModel().setValue("banklogo", (Object)TmcAttachmentHelper.getRealPath((String)bankLogo));
            this.getModel().setValue("company", row == null ? orgid : row.getString("company"));
            this.getModel().setValue("accountbank", row == null ? accountbank : row.getString("accountbank"));
            this.getModel().setValue("currency", row == null ? currency : row.getString("currency"));
            this.getModel().setValue("modifytime", row == null ? null : row.get("modifytime"));
            this.getModel().setValue("bizdate", row == null ? DateUtils.getCurrentDate() : row.get("bizdate"));
            this.getModel().setValue("amount", row == null || row.get("amount") == null ? null : row.getBigDecimal("amount"));
            this.getModel().setValue("valibalance", row == null || row.get("valibalance") == null ? null : row.getBigDecimal("valibalance"));
            this.getModel().setValue("lstbalance", row == null || row.get("lstbalance") == null ? null : row.getBigDecimal("lstbalance"));
            this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty((Object)this.getModel().getValue("currency"))), new String[]{"valibalance", "amount", "lstbalance"});
            this.getView().setVisible(Boolean.valueOf(this.getModel().getValue("amount") != null), new String[]{"amount"});
            this.getView().setVisible(Boolean.valueOf(this.getModel().getValue("valibalance") != null), new String[]{"valibalance"});
            this.getView().setVisible(Boolean.valueOf(this.getModel().getValue("lstbalance") != null), new String[]{"lstbalance"});
            DynamicObject accBanks = (DynamicObject)this.getModel().getValue("accountbank");
            boolean isShow = EmptyUtil.isNoEmpty((DynamicObject)accBanks) && accBanks.getBoolean("iselecpayment");
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"dceplab"});
            this.showFavoriteButton();
        }
    }

    private void showFavoriteButton() {
        boolean showAddFav = false;
        boolean showDelFav = false;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject accu = dataEntity.getDynamicObject("accountbank");
        DynamicObject curr = dataEntity.getDynamicObject("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)accu) && EmptyUtil.isNoEmpty((DynamicObject)curr)) {
            QFilter[] filters = new QFilter[]{new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()), new QFilter("accountbank.id", "=", accu.getPkValue()), new QFilter("currency.id", "=", curr.getPkValue())};
            DynamicObject favorite = TmcDataServiceHelper.loadSingleFromCache((String)"bei_account_favorite", (QFilter[])filters);
            if (EmptyUtil.isNoEmpty((DynamicObject)favorite)) {
                showDelFav = true;
                this.getPageCache().put("delfavorite", favorite.getPkValue().toString());
            } else {
                showAddFav = true;
            }
        }
        this.getView().setVisible(Boolean.valueOf(showAddFav), new String[]{"addfavorite"});
        this.getView().setVisible(Boolean.valueOf(showDelFav), new String[]{"delfavorite"});
    }

    protected String getEntityName() {
        return "bei_bankbalance_view";
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        IDataModel model = this.getModel();
        if (source instanceof Button) {
            String buttonKey = ((Button)source).getKey();
            if ("favoritemore".equals(buttonKey)) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setLookUp(true);
                showParameter.setMultiSelect(false);
                showParameter.setFormId("bos_listf7");
                showParameter.setBillFormId("bei_account_favorite");
                StyleCss styleCss = new StyleCss();
                styleCss.setWidth("960px");
                styleCss.setHeight("580px");
                showParameter.getOpenStyle().setInlineStyleCss(styleCss);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "favoritemore"));
                Set favIds = this.getUserFavoriteList().stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                List<QFilter> filterList = Collections.singletonList(new QFilter("id", "in", favIds));
                showParameter.setListFilterParameter(new ListFilterParameter(filterList, "modifytime desc"));
                this.getView().showForm((FormShowParameter)showParameter);
            } else if ("addfavorite".equals(buttonKey)) {
                DynamicObject favorite = TmcDataServiceHelper.newDynamicObject((String)"bei_account_favorite");
                favorite.set("accountbank", model.getValue("accountbank"));
                favorite.set("currency", model.getValue("currency"));
                favorite.set("creator", (Object)RequestContext.get().getCurrUserId());
                favorite.set("name", (Object)(favorite.getString("accountbank.number") + "|" + favorite.getString("currency.number")));
                favorite.set("enable", (Object)"1");
                favorite.set("status", (Object)BillStatusEnum.SAVE.getValue());
                OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"save", (String)"bei_account_favorite", (DynamicObject[])new DynamicObject[]{favorite}, (OperateOption)OperateOption.create());
                if (result.isSuccess()) {
                    this.initFavoriteList();
                    this.showFavoriteButton();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u6210\u529f\u3002", (String)"OnlineQueryPlugin_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u85cf\u5931\u8d25\u3002", (String)"OnlineQueryPlugin_2", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                    logger.error("save favorite fail {}", (Object)result.getMessage());
                }
            } else if ("delfavorite".equals(buttonKey)) {
                long pkVal = Long.parseLong(this.getPageCache().get("delfavorite"));
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bei_account_favorite"), (Object[])new Object[]{pkVal});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6536\u85cf\u6210\u529f\u3002", (String)"OnlineQueryPlugin_3", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                this.initFavoriteList();
                this.showFavoriteButton();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(event);
        if ("favoritemore".equals(event.getActionId()) && EmptyUtil.isNoEmpty((Object)(returnData = (ListSelectedRowCollection)event.getReturnData()))) {
            String favId = returnData.get(0).getPrimaryKeyValue().toString();
            this.getPageCache().put("favorite.name", favId);
            this.getView().updateView("filtercontainerap");
            this.selectFavoriteItem(Long.parseLong(favId));
            this.fillPageData();
        }
    }

    private void selectFavoriteItem(long favId) {
        CardEntry cardEntry = (CardEntry)this.getControl("favoriteentry");
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("favoriteentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject fav = (DynamicObject)model.getValue("favorite", i);
            if (fav.getLong("id") != favId) continue;
            cardEntry.selectCard(Integer.valueOf(i));
            this.setSelectFavFontColor(i);
            break;
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String entryKey;
        super.entryRowClick(evt);
        Object source = evt.getSource();
        if (source instanceof CardEntry && "favoriteentry".equals(entryKey = ((CardEntry)source).getEntryKey())) {
            DynamicObject fav = (DynamicObject)this.getModel().getValue("favorite", evt.getRow());
            this.setSelectFavFontColor(evt.getRow());
            this.getPageCache().put("favorite.name", fav.getPkValue().toString());
            this.getView().updateView("filtercontainerap");
            this.fillPageData();
        }
    }

    private void setSelectFavFontColor(int curIndex) {
        IPageCache pageCache = this.getPageCache();
        CardEntry cardEntry = (CardEntry)this.getControl("favoriteentry");
        String index = pageCache.get(CACHE_SELECT_FAV);
        if (EmptyUtil.isNotBlank((CharSequence)index)) {
            int favIdx = Integer.parseInt(index);
            cardEntry.setCustomProperties("favoriteentry", favIdx, Collections.singletonMap("favoitem", Collections.singletonMap("fc", "#666666")));
        }
        if (curIndex < 0) {
            pageCache.remove(CACHE_SELECT_FAV);
        } else {
            pageCache.put(CACHE_SELECT_FAV, String.valueOf(curIndex));
            cardEntry.setCustomProperties("favoriteentry", curIndex, Collections.singletonMap("favoitem", Collections.singletonMap("fc", "#5F81EB")));
        }
    }
}

