/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.serviceconfig;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.upload.UploadOption;
import kd.tmc.bei.common.resource.ServiceConfigResource;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.security.utils.HufuManager;
import kd.tmc.fbp.service.ebservice.security.utils.XOREncrypter;

public class ServiceConfigEdit
extends AbstractBasePlugIn
implements UploadListener {
    private static final Log logger = LogFactory.getLog(ServiceConfigEdit.class);
    private static final Integer ID_CONFIG1 = 1;
    private static final Integer ID_CONFIG2 = 2;
    private static final String OLD_CONFIG_HYPERLINK = "oldconfighyperlink";
    private String customerKey;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label oldConfigHyperlink = (Label)this.getControl(OLD_CONFIG_HYPERLINK);
        oldConfigHyperlink.addClickListener((ClickListener)this);
    }

    public void initialize() {
        super.initialize();
        this.customerKey = HufuManager.getCustomerKey();
        Button btn = (Button)this.getControl("btn_upload");
        btn.addUploadListener((UploadListener)this);
        Button btn2 = (Button)this.getControl("btn_upload2");
        btn2.addUploadListener((UploadListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        DynamicObject currOrg;
        super.preOpenForm(e);
        boolean hasServiceConfig = TmcDataServiceHelper.exists((String)"bei_serviceconfig", (QFilter[])new QFilter[0]);
        if (!(hasServiceConfig || (currOrg = TmcOrgDataHelper.getCurrentOrg()) != null && currOrg.getBoolean("fisbankroll"))) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u5207\u6362\u7ec4\u7ec7\u804c\u80fd\u4e3a\u8d44\u91d1\u7ec4\u7ec7\u7684\u4e1a\u52a1\u5355\u5143\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ServiceConfigEdit_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("batchdownstrategy"))) {
            logger.info("batchdownstrategy is null ");
            this.getModel().setValue("batchdownstrategy", (Object)"groupbybankinterface");
        } else {
            logger.info("batchdownstrategy is " + this.getModel().getValue("batchdownstrategy"));
        }
        this.loadData(true);
    }

    private void loadData(boolean invokeTestConnect) {
        IBillModel model = (IBillModel)this.getModel();
        DynamicObjectCollection servConfInits = QueryServiceHelper.query((String)"bei_serviceconfig", (String)"id", null);
        if (servConfInits.size() > 0) {
            block9: {
                String id = ((DynamicObject)servConfInits.get(0)).getString("id");
                DynamicObject servConfInit = TmcDataServiceHelper.loadSingle((Object)id, (String)"bei_serviceconfig");
                model.load(servConfInit.getPkValue());
                try {
                    String password = servConfInit.getString("customerprivatekey");
                    byte[] decodePW = XOREncrypter.decode((String)this.customerKey, (String)password);
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"privatekey", (Object)new String(decodePW));
                }
                catch (Exception ee) {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    StringBuilder expMessage = new StringBuilder();
                    expMessage.append(new ServiceConfigResource().getMessage());
                    expMessage.append(buf);
                    try {
                        buf.close();
                    }
                    catch (IOException ioe) {
                        this.getView().showErrorNotification(ioe.getMessage());
                    }
                    if (!EmptyUtil.isNotEmpty((CharSequence)expMessage)) break block9;
                    this.getView().showMessage(expMessage.toString());
                }
            }
            if (invokeTestConnect) {
                try {
                    this.getView().invokeOperation("testconnect");
                }
                catch (Exception exception) {
                    this.connectFail();
                    this.connectFail2();
                    this.getView().showErrorNotification(new ServiceConfigResource().getConnectFail());
                }
            }
        } else {
            this.connectFail();
            this.connectFail2();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "upload": {
                UploadOption option = new UploadOption();
                option.setMultiple(false);
                option.setTitle(new ServiceConfigResource().getCustomerCaTitle());
                option.setSuffix(".p12,.cer,.pem,.crt,.pfx");
                option.setLimitSize(ServiceConfigResource.CUSTOMER_CA_LIMITSIZE.longValue());
                this.getView().showUpload(option, "btn_upload");
                break;
            }
            case "upload2": {
                UploadOption option2 = new UploadOption();
                option2.setMultiple(false);
                option2.setTitle(new ServiceConfigResource().getPublicCertTitle());
                option2.setSuffix(".p12,.cer,.pem,.crt,.pfx");
                option2.setLimitSize(ServiceConfigResource.CUSTOMER_CA_LIMITSIZE.longValue());
                this.getView().showUpload(option2, "btn_upload2");
                break;
            }
            case "save": {
                String value = (String)this.getModel().getValue("privatekey");
                if (StringUtils.isEmpty((CharSequence)value)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b89\u5168\u914d\u7f6e\u7684\u5ba2\u6237\u79c1\u94a5\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ServiceConfigEdit_0", (String)"tmc-bei-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                String defaultPublicCaContext = this.getDefaultPublicCaContext();
                this.getModel().setValue("publiccaname", (Object)"ebg_formal.cer");
                this.getModel().setValue("publiccafile_tag", (Object)defaultPublicCaContext);
                Boolean isenable = (Boolean)this.getModel().getValue("isenable");
                Boolean isenable2 = (Boolean)this.getModel().getValue("isenable2");
                DynamicObjectCollection scopeEntry = this.getModel().getEntryEntity("appscope_entity");
                if (isenable2.booleanValue() && !isenable.booleanValue() && scopeEntry.size() > 0) {
                    this.getModel().deleteEntryData("appscope_entity");
                }
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"tenantid", (Object)RequestContext.get().getTenantId());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "save": {
                this.getModel().setDataChanged(false);
                break;
            }
            case "testconnect": {
                OperationResult result = args.getOperationResult();
                List successPkIds = result.getSuccessPkIds();
                if (result.isSuccess() && successPkIds != null) {
                    logger.info("successPkIds:{}", (Object)successPkIds);
                    if (successPkIds.contains(ID_CONFIG1)) {
                        logger.info("___\u72ec\u7acb\u7248\u94f6\u4f01\u4e91\u8fde\u63a5\u6210\u529f");
                        this.getModel().setValue("connectstatus", (Object)"1");
                        this.getView().setVisible(Boolean.FALSE, new String[]{"unconnect"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{"connect"});
                    } else {
                        this.connectFail();
                    }
                    if (successPkIds.contains(ID_CONFIG2)) {
                        logger.info("___\u661f\u701a-\u94f6\u4f01\u4e91\u8fde\u63a5\u6210\u529f");
                        this.getModel().setValue("connectstatus2", (Object)"1");
                        this.getView().setVisible(Boolean.FALSE, new String[]{"unconnect2"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{"connect2"});
                    } else {
                        this.connectFail2();
                    }
                    if (successPkIds.contains(ID_CONFIG1) && successPkIds.contains(ID_CONFIG2)) {
                        logger.info("\u94f6\u4f01\u72ec\u7acb\u7248\u94f6\u4f01\u4e91\u548c\u94f6\u4f01\u661f\u701a-\u94f6\u4f01\u4e91\u90fd\u8fde\u901a\u6210\u529f result.getMessage()\uff1a{}", (Object)result.getMessage());
                        this.getView().showSuccessNotification(result.getMessage(), Integer.valueOf(2000));
                        break;
                    }
                    if (successPkIds.contains(ID_CONFIG1) && !successPkIds.contains(ID_CONFIG2) || !successPkIds.contains(ID_CONFIG1) && successPkIds.contains(ID_CONFIG2)) {
                        this.getView().showSuccessNotification(result.getMessage(), Integer.valueOf(2000));
                        break;
                    }
                    logger.info("\u94f6\u4f01\u72ec\u7acb\u7248\u94f6\u4f01\u4e91\u548c\u94f6\u4f01\u661f\u701a-\u94f6\u4f01\u4e91 \u6709\u4e00\u4e2a\u6210\u529f\u6216\u8005\u90fd\u6ca1\u6210\u529f result.getMessage()\uff1a{}", (Object)result.getMessage());
                    this.getView().showTipNotification(result.getMessage());
                    break;
                }
                logger.info("\u8fde\u63a5\u5931\u8d25\uff0cresult.isSuccess:{} successPkIds:{}", (Object)result.isSuccess(), (Object)successPkIds);
                this.getModel().setValue("connectstatus", (Object)"0");
                this.getModel().setValue("connectstatus2", (Object)"0");
                this.connectFail();
                this.connectFail2();
                this.getView().showErrorNotification(result.getMessage());
                break;
            }
            case "refresh": {
                this.loadData(false);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String hyperlinkKey = ((Control)evt.getSource()).getKey();
        if (OLD_CONFIG_HYPERLINK.equals(hyperlinkKey)) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("bei_serviceconfig_old");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private String getDefaultPublicCaContext() {
        DynamicObjectCollection servConfInits = QueryServiceHelper.query((String)"bei_servicecfgdefaultca", (String)"id,publiccafile_tag", null);
        if (servConfInits.size() > 0) {
            String publicCaFile = ((DynamicObject)servConfInits.get(0)).getString("publiccafile_tag");
            String[] publicCaArr = publicCaFile.split(",");
            byte[] bytes = new byte[publicCaArr.length];
            for (int i = 0; i < publicCaArr.length; ++i) {
                bytes[i] = Byte.parseByte(publicCaArr[i]);
            }
            return XOREncrypter.encode((String)this.customerKey, (byte[])bytes);
        }
        return "";
    }

    public void upload(UploadEvent evt) {
        if (evt.getUrls().length > 1) {
            this.getView().showErrorNotification(new ServiceConfigResource().getUploadErrorMessage());
            return;
        }
        if (evt.getCallbackKey().equals("btn_upload")) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)evt.getUrls()[0];
            Object fileName = linkedHashMap.get("name");
            this.getModel().setValue("cafile", linkedHashMap.get("url"));
            String url = linkedHashMap.get("url").toString();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            fileService.download(url, (OutputStream)bos, "httpclient");
            byte[] byteArray = bos.toByteArray();
            String fileContent = XOREncrypter.encode((String)this.customerKey, (byte[])byteArray);
            this.getModel().setValue("customerca", fileName);
            this.getModel().setValue("cafile_tag", (Object)fileContent);
        } else if (evt.getCallbackKey().equals("btn_upload2")) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)evt.getUrls()[0];
            Object fileName = linkedHashMap.get("name");
            this.getModel().setValue("publiccafile", linkedHashMap.get("url"));
            String url = linkedHashMap.get("url").toString();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            fileService.download(url, (OutputStream)bos, "httpclient");
            byte[] byteArray = bos.toByteArray();
            String fileContent = XOREncrypter.encode((String)this.customerKey, (byte[])byteArray);
            this.getModel().setValue("publiccaname", fileName);
            this.getModel().setValue("publiccafile_tag", (Object)fileContent);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue != null && "privatekey".equals(key)) {
            this.getModel().setValue("customerprivatekey", (Object)XOREncrypter.encode((String)this.customerKey, (String)newValue.toString()));
        }
        if ("isenable2".equals(key) && newValue != null && !((Boolean)newValue).booleanValue()) {
            this.getModel().setValue("isopenapi", (Object)false);
        }
        if ("e_bankcgno".equals(key) && newValue != null) {
            this.getModel().setValue("e_lastupdater", (Object)Long.parseLong(RequestContext.get().getUserId()), rowIndex);
            this.getModel().setValue("e_lastupdate", (Object)new Date(), rowIndex);
        }
    }

    private void connectFail() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"connect"});
    }

    private void connectFail2() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"connect2"});
    }
}

