/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.formplugin.workbench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.CasFlowConfirmLogHelper;
import kd.tmc.bei.business.helper.RecClaimHelper;
import kd.tmc.bei.common.helper.ExtendConfigHelper;
import kd.tmc.fbp.common.enums.MatchBizTypeEnum;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ClaimRecWorkbenchList
extends AbstractListPlugin {
    private static IAppCache cache = TmcAppCache.get((String)"cas", (String)"intelrec", (String)"claim");
    private static final String SYSTEMTYPE = "tmc-bei-formplugin";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        Object[] selectids = selectedRows.getPrimaryKeyValues();
        if (args.getOperationResult() != null && EmptyUtil.isNoEmpty((Object)args.getOperationResult().getSuccessPkIds())) {
            if (EmptyUtil.isEmpty((Object[])selectids)) {
                return;
            }
            switch (operateKey) {
                case "noticeclaim": {
                    this.noticeClaim(selectids, selectedRows);
                    break;
                }
                case "cancelnotice": {
                    if (EmptyUtil.isEmpty((Collection)args.getOperationResult().getAllErrorInfo())) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ClaimRecWorkbenchList_2", (String)SYSTEMTYPE, (Object[])new Object[0]));
                    }
                    this.getView().invokeOperation("refresh");
                    break;
                }
            }
        }
    }

    private void noticeClaim(Object[] ids, ListSelectedRowCollection selectedRows) {
        boolean isHasMatch;
        String thisOpnumber = DB.genGlobalLongId() + "";
        BillList billList = (BillList)this.getControl("billlistap");
        String entityName = billList.getEntityId();
        if ("bei_intelrec".equals(entityName)) {
            isHasMatch = AutoMatchHelper.autoMatch((ListSelectedRowCollection)selectedRows, Arrays.asList(MatchBizTypeEnum.REC, MatchBizTypeEnum.TRANSUP), (String)thisOpnumber, (String)"rec");
        } else {
            ArrayList<MatchBizTypeEnum> bizTypeList = new ArrayList<MatchBizTypeEnum>(10);
            bizTypeList.add(MatchBizTypeEnum.TRANSDOWN);
            bizTypeList.add(MatchBizTypeEnum.PAY);
            bizTypeList.add(MatchBizTypeEnum.TRANSHANDLE);
            bizTypeList.add(MatchBizTypeEnum.AGENTPAY);
            bizTypeList.add(MatchBizTypeEnum.EXCHANGE);
            bizTypeList.add(MatchBizTypeEnum.REC);
            isHasMatch = AutoMatchHelper.autoMatch((ListSelectedRowCollection)selectedRows, bizTypeList, (String)thisOpnumber, (String)"pay");
        }
        if (!isHasMatch) {
            this.execAutoClaim(ids);
        } else {
            QFilter numberFilter = new QFilter("number", "=", (Object)thisOpnumber);
            DynamicObject[] automatchresultsaves = BusinessDataServiceHelper.load((String)"cas_autocalresult", (String)"id,name,entryentity,entryentity.billid", (QFilter[])new QFilter[]{numberFilter});
            HashSet<Long> successDetailIds = new HashSet<Long>(automatchresultsaves.length);
            HashSet<Object> remainDetailIds = new HashSet<Object>();
            for (DynamicObject dynamicObject : automatchresultsaves) {
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                Long billid = Long.valueOf(((DynamicObject)entryentity.get(0)).getString("billid"));
                successDetailIds.add(billid);
            }
            for (Object object : ids) {
                if (successDetailIds.contains(object)) continue;
                remainDetailIds.add(object);
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cas_enterconfirm");
            formShowParameter.setCustomParam("opflag", (Object)"notice");
            formShowParameter.setCustomParam("type", (Object)"notice");
            formShowParameter.setCustomParam("thisOpnumber", (Object)thisOpnumber);
            formShowParameter.setCustomParam("selectedSize", (Object)(selectedRows.size() + ""));
            formShowParameter.setCustomParam("successIds", (Object)(successDetailIds.size() + ""));
            formShowParameter.setCustomParam("failIds", (Object)(remainDetailIds.size() + ""));
            formShowParameter.setCustomParam("noticeId", (Object)SerializationUtils.toJsonString(remainDetailIds));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "noticeClaimCloseCallBack");
            formShowParameter.setCloseCallBack(callBack);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    private void execAutoClaim(Object[] ids) {
        ArrayList<Object> failIdList = new ArrayList<Object>(Arrays.asList(ids));
        OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"autoclaim", (String)"bei_transdetail_cas", (Object[])ids, (OperateOption)OperateOption.create());
        List successPkIdList = result.getSuccessPkIds();
        ArrayList errorPkIdList = new ArrayList(result.getValidateResult().getErrorPkIds());
        StringBuilder pkIdBuilder = new StringBuilder();
        StringBuilder errorPkIdBuilder = new StringBuilder();
        failIdList.removeAll(successPkIdList);
        failIdList.removeAll(errorPkIdList);
        for (Object pkId : successPkIdList) {
            pkIdBuilder.append(pkId).append(",");
        }
        for (Object pkId : failIdList) {
            errorPkIdBuilder.append(pkId).append(",");
        }
        if (pkIdBuilder.length() != 0) {
            this.getPageCache().put("successIds", pkIdBuilder.deleteCharAt(pkIdBuilder.length() - 1).toString());
        }
        StringBuilder recPayRuleFailMessage = new StringBuilder();
        if (!failIdList.isEmpty()) {
            for (IOperateInfo operateInfo : result.getAllErrorOrValidateInfo()) {
                recPayRuleFailMessage.append(operateInfo.getMessage()).append("\r\n");
            }
            DynamicObject[] transdetails = this.getSelectRow(failIdList.toArray());
            Set orgSet = Arrays.stream(transdetails).map(t -> t.getDynamicObject("company").getPkValue()).collect(Collectors.toSet());
            if (orgSet.size() > 1) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5df2\u6309\u89c4\u5219\u901a\u77e5\u8ba4\u9886%2$s\u6761\uff0c\u5269\u4f59%3$s\u6761\u4ea4\u6613\u660e\u7ec6\u4e8e\u4e0d\u540c\u7684\u8d44\u91d1\u7ec4\u7ec7\uff0c\u5982\u9700\u6279\u91cf\u901a\u77e5\u8ba4\u9886\u8bf7\u9884\u5148\u914d\u7f6e\u901a\u77e5\u8ba4\u9886\u65b9\u6848", (String)"ClaimRecWorkbenchList_01", (String)SYSTEMTYPE, (Object[])new Object[0]), ids.length, successPkIdList.size(), failIdList.size());
                recPayRuleFailMessage.append(errorMsg).append("\r\n");
                this.getView().showErrorNotification(errorMsg);
                this.getView().invokeOperation("refresh");
            } else {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("claimconfirm", (IFormPlugin)this);
                String confirmMessage = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5df2\u6309\u89c4\u5219\u901a\u77e5\u8ba4\u9886%2$s\u6761\uff0c\u9700\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f%3$s\u6761\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ClaimRecWorkbenchList_0", (String)SYSTEMTYPE, (Object[])new Object[0]), ids.length, successPkIdList.size(), failIdList.size());
                this.getView().showConfirm(confirmMessage, recPayRuleFailMessage.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
            this.getPageCache().put("failids", errorPkIdBuilder.deleteCharAt(errorPkIdBuilder.length() - 1).toString());
        } else {
            for (IOperateInfo operateInfo : result.getAllErrorOrValidateInfo()) {
                recPayRuleFailMessage.append(operateInfo.getMessage()).append("\r\n");
            }
            if (result.getAllErrorOrValidateInfo().isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ClaimRecWorkbenchList_2", (String)SYSTEMTYPE, (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(recPayRuleFailMessage.toString());
            }
            this.getPageCache().remove("successIds");
            this.getView().invokeOperation("refresh");
        }
    }

    private void noticeMessage(Map<String, String> ruleNotice) {
        HashMap claimTypeMap = new HashMap(ruleNotice.size());
        HashMap<String, List> typeValue = null;
        for (Map.Entry<String, String> rule : ruleNotice.entrySet()) {
            Map map = (Map)SerializationUtils.fromJsonString((String)rule.getValue(), Map.class);
            typeValue = new HashMap<String, List>();
            typeValue.put("usergroupids", (List)map.get("usergroupids"));
            typeValue.put("orgids", (List)map.get("orgids"));
            typeValue.put("roleids", (List)map.get("roleids"));
            typeValue.put("userids", (List)map.get("userids"));
            claimTypeMap.put(rule.getKey(), typeValue);
        }
        if (ExtendConfigHelper.shouldSendClaimMsg()) {
            RecClaimHelper.sendClaimNoticeMessage(claimTypeMap, (String)"notice");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getCallBackId().equals("claimconfirm") && e.getResult() == MessageBoxResult.Yes) {
            FormShowParameter formParameter = new FormShowParameter();
            formParameter.setFormId("cas_noticeclaim");
            formParameter.getOpenStyle().setShowType(ShowType.Modal);
            formParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "noticetype"));
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            DynamicObjectCollection transdetails = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id, billno, claimnoticebillno , receredtype , company.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)transdetails)) {
                formParameter.setCustomParam("orgId", (Object)((DynamicObject)transdetails.get(0)).getLong("company.id"));
            }
            this.getView().showForm(formParameter);
        } else {
            String successString = this.getPageCache().get("successIds");
            if (EmptyUtil.isNotEmpty((CharSequence)successString)) {
                String[] successIds = successString.split(",");
                HashMap<String, String> ruleNotice = new HashMap<String, String>(successIds.length);
                for (int i = 0; i < successIds.length; ++i) {
                    ruleNotice.put(successIds[i], (String)cache.get(successIds[i], String.class));
                }
                this.noticeMessage(ruleNotice);
            }
            this.getPageCache().remove("successIds");
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("noticetype".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (EmptyUtil.isEmpty((Object)returnData)) {
                return;
            }
            Map noticeData = (Map)returnData;
            if (!RecClaimHelper.checkEnableUserExist((Map)noticeData)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u5b9a\u7684\u8ba4\u9886\u7528\u6237\u7ec4\u6216\u89d2\u8272\u4e2d\u4e0d\u5b58\u5728\u53ef\u7528\u72b6\u6001\u7684\u7528\u6237\uff0c\u65e0\u6cd5\u63d0\u4ea4\u901a\u77e5\u8ba4\u9886\u3002", (String)"ClaimRecWorkbenchList_10", (String)SYSTEMTYPE, (Object[])new Object[0]));
                return;
            }
            String jsonString = SerializationUtils.toJsonString((Object)noticeData);
            String failidString = this.getPageCache().get("failids");
            String[] failids = failidString.split(",");
            HashMap<String, String> ruleNotice = new HashMap<String, String>(failids.length);
            for (int i = 0; i < failids.length; ++i) {
                cache.put(failids[i], (Object)jsonString);
                ruleNotice.put(failids[i], jsonString);
            }
            Object[] ids = (Long[])Arrays.stream(failids).mapToLong(Long::valueOf).boxed().toArray(Long[]::new);
            OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"pushandsave", (String)"bei_transdetail_cas", (Object[])ids, (OperateOption)OperateOption.create());
            String successString = this.getPageCache().get("successIds");
            if (EmptyUtil.isNotEmpty((CharSequence)successString)) {
                String[] successIds = successString.split(",");
                for (int i = 0; i < successIds.length; ++i) {
                    ruleNotice.put(successIds[i], (String)cache.get(successIds[i], String.class));
                }
            }
            this.noticeMessage(ruleNotice);
            try (TXHandle tx = TX.requiresNew();){
                CasFlowConfirmLogHelper.saveNoticeLog(Arrays.stream(ids).collect(Collectors.toList()));
            }
            this.getPageCache().remove("successIds");
            this.getView().invokeOperation("refresh");
            this.showOperateResult(result);
        } else if ("noticeClaimCloseCallBack".equals(actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            String returnNoticeId = (String)returnData.get("returnNoticeId");
            Set noticeId = (Set)SerializationUtils.fromJsonString((String)returnNoticeId, Set.class);
            this.execAutoClaim(noticeId.toArray());
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("claimnoticebillno".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            Object focusRowPkId = list.getFocusRowPkId();
            DynamicObject detail = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"bei_transdetail_cas", (String)"id,claimnoticebillno");
            String recBillNo = detail.getString("claimnoticebillno");
            if (!StringUtils.isEmpty((CharSequence)recBillNo)) {
                QFilter filter = new QFilter("billno", "=", (Object)recBillNo);
                DynamicObject recbillDo = BusinessDataServiceHelper.loadSingle((String)"cas_claimcenterbill", (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
                if (!EmptyUtil.isEmpty((DynamicObject)recbillDo)) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.setFormId("cas_claimcenterbill");
                    showParameter.setPkId(recbillDo.getPkValue());
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        }
    }

    private DynamicObject[] getSelectRow(Object[] ids) {
        DynamicObject[] transdetails = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id, billno, claimnoticebillno , receredtype , company, debitamount, creditamount", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        return transdetails;
    }

    private void showOperateResult(OperationResult result) {
        List allErrorInfo = result.getAllErrorInfo();
        if (!EmptyUtil.isEmpty((Collection)allErrorInfo)) {
            String containsMessage = ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u5b9a\u4e49\u89c4\u5219\u3002", (String)"ClaimRecWorkbenchList_25", (String)SYSTEMTYPE, (Object[])new Object[0]);
            allErrorInfo.forEach(operateErrorInfo -> {
                String message = operateErrorInfo.getMessage();
                if (message.contains(containsMessage)) {
                    int start = message.indexOf(":");
                    int end = message.indexOf("\uff1a");
                    message = message.substring(0, start) + "" + message.substring(end);
                    operateErrorInfo.setMessage(message);
                }
            });
            this.getView().showOperationResult(result);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ClaimRecWorkbenchList_2", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
    }
}

